package com.dayouzc.e2eapp.mcard.mcardcsm.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author wugang
 */
@EnableAutoConfiguration
@SpringBootApplication
@EnableScheduling       //开启定时任务
public class McardCsmApplication extends SpringBootServletInitializer {
    private static final Logger logger = LoggerFactory.getLogger(McardCsmApplication.class);

    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(McardCsmApplication.class);
    }

    /**
     * Start
     */
    public static void main(String[] args) {
        SpringApplication.run(McardCsmApplication.class, args);
        logger.info("SpringBoot Start Success");
    }
}
