package com.dayouzc.e2e.core.util.data;


import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

/**
 * XML序列化 反序列化软件
 *
 * @author 何鑫
 * @date 2018/5/24 10:55
 */
public class XmlUtils {

    /**
     * 将对象序列化成XML
     * 对已经加了XStream注解的对象序列化 固定XML编码格式（UTF-8）
     *
     * @param obj 要序列化的对象
     * @return
     */
    static public String obj2xml(Object obj) {
        return obj2xml(obj, "UTF-8");
    }

    /**
     * 将对象序列化成XML
     * 对已经加了XStream注解的对象序列化 固定XML编码格式（UTF-8）
     *
     * @param obj 要序列化的对象
     * @return
     */
    static public String obj2xmlGBK(Object obj) {
        return obj2xml(obj, "GBK");
    }

    /**
     * 将对象序列化成XML
     * 对已经加了XStream注解的对象序列化 自定义XML编码格式
     *
     * @param obj      要序列化的对象
     * @param encoding XML编码
     * @return
     */
    static public String obj2xml(Object obj, String encoding) {
        try {
            if (obj == null) {
                return null;
            }
            XStream xStream = new XStream(new DomDriver());
            xStream.autodetectAnnotations(true);
            String xml = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n"
                    + xStream.toXML(obj);
            xml = xml.replaceAll("__", "_");
            return xml;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 将XML反序列化成对象
     *
     * @param content 将要反序列化的XML
     * @param clazz   要反序列化成的对象的class
     * @return Object 对象
     */
    static public Object xml2Obj(String content, Class<?> clazz) {
        try {
            if (content == null || "".equals(content)) {
                return null;
            }
            XStream xStream = new XStream(new DomDriver());
//		xStream.autodetectAnnotations(true);
            xStream.processAnnotations(clazz);
            return xStream.fromXML(content);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }


    static public Object xml2Obj(String content, Class<?>[] clazzes) {
        try {
            if (content == null || "".equals(content)) {
                return null;
            }
            XStream xStream = new XStream(new DomDriver());
//		xStream.autodetectAnnotations(true);
            xStream.processAnnotations(clazzes);
            return xStream.fromXML(content);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

}
