/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.resource;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import com.dayouzc.e2e.core.DYUtils;
import com.dayouzc.e2e.core.util.StringUtils;
import com.dayouzc.e2e.core.util.file.CloseUtils;
import com.dayouzc.e2e.core.util.file.FileIOUtils;
import com.dayouzc.e2e.core.util.file.FileUtils;
import com.dayouzc.e2e.core.util.resource.ResUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class ResourceUtils {
    private static final String LINE_BREAK = "\r\n";

    private ResourceUtils() {
        throw new Error("Do not need instantiate!");
    }

    public static String readStringFromAssert(String fileName) {
        return ResourceUtils.readStringFromAssert(fileName, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readStringFromAssert(String fileName, String encodingCode) {
        String string;
        InputStream inputStream = null;
        try {
            inputStream = ResourceUtils.openAssetsFile(fileName);
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            string = new String(buffer, encodingCode);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtils.closeIO(inputStream);
                throw throwable;
            }
            CloseUtils.closeIO(inputStream);
            return "";
        }
        CloseUtils.closeIO(inputStream);
        return string;
    }

    public static InputStream openAssetsFile(String fileName) {
        try {
            return ResourceUtils.getAssetManager().open(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream openAssetsFileWithException(String fileName) throws IOException {
        return ResourceUtils.getAssetManager().open(fileName);
    }

    public static InputStream openRawResource(int resId) {
        return ResUtils.getResources().openRawResource(resId);
    }

    public static AssetManager getAssetManager() {
        return ResUtils.getResources().getAssets();
    }

    public static String getFileFromAssets(String fileName) {
        return ResourceUtils.getFileFromAssets(fileName, true);
    }

    public static String getFileFromAssets(String fileName, boolean isNeedAddLine) {
        if (StringUtils.isEmpty(fileName)) {
            return "";
        }
        return ResourceUtils.readInputStream(ResourceUtils.openAssetsFile(fileName), isNeedAddLine);
    }

    public static String getFileFromRaw(int resId) {
        return ResourceUtils.getFileFromRaw(resId, true);
    }

    public static String getFileFromRaw(int resId, boolean isNeedAddLine) {
        return ResourceUtils.readInputStream(ResourceUtils.openRawResource(resId), isNeedAddLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInputStream(InputStream inputStream, boolean isNeedAddLine) {
        StringBuilder s = new StringBuilder("");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(inputStream));
            if (isNeedAddLine) {
                String line;
                while ((line = br.readLine()) != null) {
                    s.append(line).append(LINE_BREAK);
                }
            } else {
                String line;
                while ((line = br.readLine()) != null) {
                    s.append(line);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtils.closeIO(br);
                throw throwable;
            }
            CloseUtils.closeIO(br);
        }
        CloseUtils.closeIO(br);
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Bitmap getImageFromAssetsFile(String fileName) {
        Bitmap bitmap;
        InputStream is = null;
        AssetManager am = ResourceUtils.getAssetManager();
        try {
            is = am.open(fileName);
            bitmap = BitmapFactory.decodeStream((InputStream)is);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtils.closeIO(is);
                throw throwable;
            }
            CloseUtils.closeIO(is);
            return null;
        }
        CloseUtils.closeIO(is);
        return bitmap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Bitmap getImageFromAssets(String fileName) {
        Bitmap bitmap;
        InputStream is = null;
        try {
            is = ResourceUtils.openAssetsFileWithException("drawable/" + fileName);
            bitmap = BitmapFactory.decodeStream((InputStream)is);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtils.closeIO(is);
                throw throwable;
            }
            CloseUtils.closeIO(is);
            return null;
        }
        CloseUtils.closeIO(is);
        return bitmap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Drawable getImageDrawableFromAssets(String fileName) {
        Drawable drawable2;
        InputStream is = null;
        try {
            is = ResourceUtils.openAssetsFileWithException("drawable/" + fileName);
            drawable2 = ResourceUtils.bitmap2Drawable(BitmapFactory.decodeStream((InputStream)is));
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtils.closeIO(is);
                throw throwable;
            }
            CloseUtils.closeIO(is);
            return null;
        }
        CloseUtils.closeIO(is);
        return drawable2;
    }

    public static Drawable bitmap2Drawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(DYUtils.getContext().getResources(), bitmap);
    }

    public static void copyFilesFromAssets(String oldPath, String newPath) {
        try {
            String[] fileNames = ResourceUtils.getAssetManager().list(oldPath);
            if (fileNames != null && fileNames.length > 0) {
                if (FileUtils.createOrExistsDir(newPath)) {
                    for (String fileName : fileNames) {
                        ResourceUtils.copyFilesFromAssets(oldPath + File.separator + fileName, newPath + File.separator + fileName);
                    }
                }
            } else {
                FileIOUtils.writeFileFromIS(newPath, ResourceUtils.getAssetManager().open(oldPath));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean copyFileFromAssets(String fileName, String srcDir, String destDir) {
        try {
            if (FileUtils.createOrExistsDir(destDir)) {
                return FileIOUtils.writeFileFromIS(destDir + File.separator + fileName, ResourceUtils.getAssetManager().open(srcDir + File.separator + fileName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getCopyFileFromAssets(String fileName, String assetsSrcDir, String destDir) {
        try {
            String copyFilePath;
            if (FileUtils.createOrExistsDir(destDir) && FileIOUtils.writeFileFromIS(copyFilePath = destDir + File.separator + fileName, ResourceUtils.getAssetManager().open(assetsSrcDir + File.separator + fileName))) {
                return copyFilePath;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

