/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.resource;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.annotation.AnimRes;
import androidx.annotation.ArrayRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleableRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.dayouzc.e2e.core.DYUtils;

public final class ResUtils {
    private ResUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Resources getResources() {
        return DYUtils.getContext().getResources();
    }

    public static String getString(@StringRes int resId) {
        return ResUtils.getResources().getString(resId);
    }

    public static Drawable getDrawable(@DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return DYUtils.getContext().getDrawable(resId);
        }
        return ResUtils.getResources().getDrawable(resId);
    }

    public static Drawable getDrawable(Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return context.getResources().getDrawable(resId);
    }

    public static Drawable getVectorDrawable(Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return AppCompatResources.getDrawable((Context)context, (int)resId);
    }

    public static Drawable getDrawableAttrRes(Context context, TypedArray typedArray, @StyleableRes int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return typedArray.getDrawable(index);
        }
        int resourceId = typedArray.getResourceId(index, -1);
        if (resourceId != -1) {
            return AppCompatResources.getDrawable((Context)context, (int)resourceId);
        }
        return null;
    }

    public static float getDimens(@DimenRes int resId) {
        return ResUtils.getResources().getDimension(resId);
    }

    public static int getColor(@ColorRes int resId) {
        return ResUtils.getResources().getColor(resId);
    }

    public static ColorStateList getColors(@ColorRes int resId) {
        return ResUtils.getResources().getColorStateList(resId);
    }

    public static int getDimensionPixelOffset(@DimenRes int resId) {
        return ResUtils.getResources().getDimensionPixelOffset(resId);
    }

    public static int getDimensionPixelSize(@DimenRes int resId) {
        return ResUtils.getResources().getDimensionPixelSize(resId);
    }

    public static String[] getStringArray(@ArrayRes int resId) {
        return ResUtils.getResources().getStringArray(resId);
    }

    public static int[] getIntArray(@ArrayRes int resId) {
        return ResUtils.getResources().getIntArray(resId);
    }

    public static Animation getAnim(@AnimRes int resId) {
        return AnimationUtils.loadAnimation((Context)DYUtils.getContext(), (int)resId);
    }

    public static void setBackgroundCompat(View view, Drawable d) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(d);
        } else {
            view.setBackground(d);
        }
    }

    public static boolean isRtl() {
        return Build.VERSION.SDK_INT >= 17 && ResUtils.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    public static <T> boolean isIn(@NonNull T find, @Nullable T[] ary) {
        if (ary == null || ary.length == 0) {
            return false;
        }
        for (T item : ary) {
            if (!item.equals(find)) continue;
            return true;
        }
        return false;
    }
}

