/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.data;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String toJSON(Object obj) {
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, obj);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String result = writer.toString();
        return null == result ? "" : result.replaceAll("null", "\"\"");
    }

    public static <T> T fromJson(String jsonString, JavaType javaType) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JavaType createCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> T fromJSON(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJSON(InputStream json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Object> getJsonList(String jstr, List<Object> li) {
        char[] cstr = jstr.toCharArray();
        boolean bend = false;
        int istart = 0;
        int iend = 0;
        for (int i = 0; i < cstr.length; ++i) {
            if (cstr[i] == '{' && !bend) {
                istart = i;
            }
            if (cstr[i] != '}' || bend) continue;
            iend = i;
            bend = true;
        }
        if (istart != 0) {
            String substr = jstr.substring(istart, iend + 1);
            jstr = jstr.substring(0, istart - 1) + jstr.substring(iend + 1, jstr.length());
            substr = substr.replace(",\"children\":", "");
            substr = substr.replace("]", "");
            substr = substr.replace("[", "");
            li.add(substr);
            JsonUtils.getJsonList(jstr, li);
        }
        return li;
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }
}

