package com.dayouzc.e2e.core.util.system;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;

import java.lang.reflect.Method;

public class SystemUtils {

    static Context context;

    private static void init(Application application) {
        if (context == null){
            context = application;
        }
    }
    /**
     * 获取程序的权限
     */
    public static String[] AppPremission(Context context) {
        try {
            init((Application) context);
            PackageInfo packinfo = context.getPackageManager().getPackageInfo(context.getPackageCodePath(),
                    PackageManager.GET_PERMISSIONS);
            // 获取到所有的权限
            return packinfo.requestedPermissions;

        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();

        }
        return null;
    }
    /**
     * 获取程序的签名
     */
    public static String AppSignature(Context context) {
        try {
            init((Application) context);
            PackageInfo packinfo = context.getPackageManager().getPackageInfo(context.getPackageCodePath(),
                    PackageManager.GET_SIGNATURES);
            // 获取到所有的权限
            return packinfo.signatures[0].toCharsString();

        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();

        }
        return "No Search";
    }

    /**
     * 获得程序图标
     */
    public static Drawable AppIcon(Context context) {
        try {
            init((Application) context);
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(
                    context.getPackageName(), 0);
            return info.loadIcon(context.getPackageManager());
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();

        }
        return null;
    }

    /**
     * 获得程序名称
     */
    public static String AppName(Context context) {
        try {
            init((Application) context);
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageCodePath(), 0);
            return info.loadLabel(context.getPackageManager()).toString();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return "No Search";
    }

    /**
     * 获得软件版本号
     */
    public static int VersionCode(Context context) {
        int versioncode = 0;
        try {
            init((Application) context);
            versioncode = context.getPackageManager().getPackageInfo(
                    context.getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        return versioncode;
    }

    /**
     * 获得软件版本名
     */
    public static String VersionName(Context context) {
        String versionname = "unknow";
        try {
            init((Application) context);
            versionname = context.getPackageManager().getPackageInfo(
                    context.getPackageName(), 0).versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        return versionname;
    }

    /**
     * 得到软件包名
     */
    public static String PackgeName(Context context) {
        String packgename = "unknow";
        try {
            init((Application) context);
            packgename = context.getPackageManager().getPackageInfo(
                    context.getPackageName(), 0).packageName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return packgename;
    }

    /**
     * 获得imei号
     */
    @SuppressLint("MissingPermission")
    public static String IMEI(Context context) {
        init((Application) context);
        String imei = "NO Search";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            return imei;
        }
        TelephonyManager telephonyManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            imei = telephonyManager.getImei();
        }else {
            imei = telephonyManager.getDeviceId();
        }
        return imei;
    }

    /**
     * 获得MEID
     */
    @SuppressLint("MissingPermission")
    public static String MEID(Context context) {
        init((Application) context);
        String imei = "NO Search";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            return imei;
        }
        TelephonyManager telephonyManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            imei = telephonyManager.getMeid();
        }
        return imei;
    }


    /**
     * 获得imsi号
     */
    @SuppressLint({"MissingPermission", "HardwareIds"})
    public static String IMSI(Context context) {
        init((Application) context);
        String imsi = "NO Search";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            return imsi;
        }
        TelephonyManager telephonyManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
        imsi = telephonyManager.getSubscriberId();
        return imsi;
    }

    /**
     * 返回本机电话号码
     */
    @SuppressLint("MissingPermission")
    public static String Num(Context context) {
        init((Application) context);
        String num = "NO Search";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            return num;
        }
        TelephonyManager telephonyManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
        num = telephonyManager.getLine1Number();
        return num;
    }

    /**
     * 得到手机产品序列号
     */
    public static String SN(Context context) {
        init((Application) context);
        String sn = "NO Search";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            return sn;
        }
        // 第二种得到序列号的方法
        String serial = android.os.Build.SERIAL;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            sn = (String) get.invoke(c, "ro.serialno");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sn;
    }

    /**
     * 获得手机sim号
     */
    @SuppressLint("MissingPermission")
    public static String SIM(Context context) {
        init((Application) context);
        String sim = "NO Search";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            return sim;
        }
        TelephonyManager telephonyManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
        sim = telephonyManager.getSimSerialNumber();

        return sim;
    }

    /**
     * 返回安卓设备ID
     */
    @SuppressLint("HardwareIds")
    public static String ID(Context context) {
        init((Application) context);
        String id = "NO Search";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            return id;
        }
        id = android.provider.Settings.Secure.getString(
                context.getContentResolver(),
                android.provider.Settings.Secure.ANDROID_ID);

        return id;
    }

    /**
     * 得到设备mac地址
     */
    public static String MAC(Context context) {
        init((Application) context);
        String mac = "NO Search";
        WifiManager manager = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        @SuppressLint("MissingPermission") WifiInfo info = manager.getConnectionInfo();
        mac = info.getMacAddress();
        return mac;
    }

    /**
     * 得到当前系统国家和地区
     */
    public static String Country(Context context) {
        init((Application) context);
        String country = "NO Search";
        country = context.getResources().getConfiguration().locale.getCountry();
        return country;
    }

    /**
     * 得到当前系统语言
     */
    public static String Language(Context context) {
        init((Application) context);
        String language = "NO Search";
        String country = context.getResources().getConfiguration().locale
                .getCountry();
        language = context.getResources().getConfiguration().locale
                .getLanguage();
        // 区分简体和繁体中文
        if (language.equals("zh")) {
            if (country.equals("CN")) {
                language = "Simplified Chinese";
            } else {
                language = "Traditional Chinese";
            }
        }
        return language;
    }

    /**
     * 返回系统屏幕的高度（像素单位）
     */
    public static int Height(Context context) {
        init((Application) context);
        int height = 0;
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        height = dm.heightPixels;
        return height;
    }

    /**
     * 返回系统屏幕的宽度（像素单位）
     */
    public static int Width(Context context) {
        init((Application) context);
        int width = 0;
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        width = dm.widthPixels;
        return width;
    }

}