/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.display;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class ViewUtils {
    private static final String CLASS_NAME_GRID_VIEW = "android.widget.GridView";
    private static final String FIELD_NAME_VERTICAL_SPACING = "mVerticalSpacing";

    private ViewUtils() {
        throw new Error("Do not need instantiate!");
    }

    public static int getListViewHeightBasedOnChildren(ListView view) {
        int adapterCount;
        ListAdapter adapter;
        int height = ViewUtils.getAbsListViewHeightBasedOnChildren((AbsListView)view);
        if (view != null && (adapter = view.getAdapter()) != null && (adapterCount = adapter.getCount()) > 0) {
            height += view.getDividerHeight() * (adapterCount - 1);
        }
        return height;
    }

    public static int getGridViewVerticalSpacing(GridView view) {
        Class<?> demo = null;
        int verticalSpacing = 0;
        try {
            demo = Class.forName(CLASS_NAME_GRID_VIEW);
            Field field = demo.getDeclaredField(FIELD_NAME_VERTICAL_SPACING);
            field.setAccessible(true);
            verticalSpacing = (Integer)field.get(view);
            return verticalSpacing;
        }
        catch (Exception e) {
            e.printStackTrace();
            return verticalSpacing;
        }
    }

    public static int getAbsListViewHeightBasedOnChildren(AbsListView view) {
        ListAdapter adapter;
        if (view == null || (adapter = (ListAdapter)view.getAdapter()) == null) {
            return 0;
        }
        int height = 0;
        for (int i = 0; i < adapter.getCount(); ++i) {
            View item = adapter.getView(i, null, (ViewGroup)view);
            if (item instanceof ViewGroup) {
                item.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
            }
            item.measure(0, 0);
            height += item.getMeasuredHeight();
        }
        return height += view.getPaddingTop() + view.getPaddingBottom();
    }

    public static void setViewHeight(View view, int height) {
        if (view == null) {
            return;
        }
        ViewGroup.LayoutParams params = view.getLayoutParams();
        params.height = height;
    }

    public static void setListViewHeightBasedOnChildren(ListView view) {
        ViewUtils.setViewHeight((View)view, ViewUtils.getListViewHeightBasedOnChildren(view));
    }

    public static void setAbsListViewHeightBasedOnChildren(AbsListView view) {
        ViewUtils.setViewHeight((View)view, ViewUtils.getAbsListViewHeightBasedOnChildren(view));
    }

    public static void setSearchViewOnClickListener(View v, View.OnClickListener listener) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = group.getChildAt(i);
                if (child instanceof LinearLayout || child instanceof RelativeLayout) {
                    ViewUtils.setSearchViewOnClickListener(child, listener);
                }
                if (child instanceof TextView) {
                    TextView text = (TextView)child;
                    text.setFocusable(false);
                }
                child.setOnClickListener(listener);
            }
        }
    }

    public static <T extends View> List<T> getDescendants(ViewGroup parent, Class<T> filter, boolean includeSubClass) {
        ArrayList<T> descendedViewList = new ArrayList<T>();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            Class<?> childsClass = child.getClass();
            if (includeSubClass && filter.isAssignableFrom(childsClass) || !includeSubClass && childsClass == filter) {
                descendedViewList.add(filter.cast(child));
            }
            if (!(child instanceof ViewGroup)) continue;
            descendedViewList.addAll(ViewUtils.getDescendants((ViewGroup)child, filter, includeSubClass));
        }
        return descendedViewList;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static FrameLayout getContentView(@NonNull Activity activity) {
        ViewGroup view = (ViewGroup)activity.getWindow().getDecorView();
        return (FrameLayout)view.findViewById(0x1020002);
    }

    public static void setBackground(Context context, View view, int res) {
        Bitmap bmp = BitmapFactory.decodeResource((Resources)context.getResources(), (int)res);
        BitmapDrawable bd = new BitmapDrawable(context.getResources(), bmp);
        if (view != null) {
            view.setBackgroundDrawable((Drawable)bd);
        }
    }

    public static void recycleBackground(@NonNull View v) {
        Bitmap bmp;
        Drawable d = v.getBackground();
        v.setBackgroundResource(0);
        if (d != null && d instanceof BitmapDrawable && (bmp = ((BitmapDrawable)d).getBitmap()) != null && !bmp.isRecycled()) {
            bmp.recycle();
        }
        if (d != null) {
            d.setCallback(null);
        }
    }

    public static void clearImageView(@NonNull View view) {
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewUtils.clearImageView(parent.getChildAt(i));
            }
        } else if (view instanceof ImageView) {
            ViewUtils.clearImgMemory((ImageView)view);
        }
    }

    public static void clearImgMemory(@NonNull ImageView imageView) {
        Bitmap bmp;
        Drawable d = imageView.getDrawable();
        if (d != null && d instanceof BitmapDrawable && (bmp = ((BitmapDrawable)d).getBitmap()) != null && !bmp.isRecycled()) {
            bmp.recycle();
        }
        imageView.setImageBitmap(null);
        if (d != null) {
            d.setCallback(null);
        }
    }
}

