/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import androidx.annotation.NonNull;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final String EMPTY = "";

    private StringUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmptyTrim(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        return a == null ? b == null : a.equalsIgnoreCase(b);
    }

    public static String getString(String s) {
        return StringUtils.isEmptyTrim(s) ? EMPTY : s;
    }

    public static String getStringTrim(String s) {
        return StringUtils.isEmptyTrim(s) ? EMPTY : s.trim();
    }

    public static String getStringNoSpace(String s) {
        return StringUtils.isEmptyTrim(s) ? EMPTY : StringUtils.replaceBlank(s);
    }

    public static int toInt(String value) {
        return StringUtils.toInt(value, 0);
    }

    public static int toInt(String value, int defValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static float toFloat(String value) {
        return StringUtils.toFloat(value, 0.0f);
    }

    public static float toFloat(String value, float defValue) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static short toShort(String value) {
        return StringUtils.toShort(value, (short)0);
    }

    public static short toShort(String value, short defValue) {
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static long toLong(String value) {
        return StringUtils.toLong(value, 0L);
    }

    public static long toLong(String value, long defValue) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static double toDouble(String value) {
        return StringUtils.toDouble(value, 0.0);
    }

    public static double toDouble(String value, double defValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static boolean toBoolean(String value) {
        return StringUtils.toBoolean(value, false);
    }

    public static boolean toBoolean(String value, boolean defValue) {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return value.contains(".");
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNumber(String value) {
        return StringUtils.isInteger(value) || StringUtils.isDouble(value);
    }

    public static int length(CharSequence s) {
        return s == null ? 0 : s.length();
    }

    public static String upperFirstLetter(String s) {
        if (StringUtils.isEmpty(s) || !Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf((char)(s.charAt(0) - 32)) + s.substring(1);
    }

    public static String lowerFirstLetter(String s) {
        if (StringUtils.isEmpty(s) || !Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf((char)(s.charAt(0) + 32)) + s.substring(1);
    }

    public static String reverse(String s) {
        int len = StringUtils.length(s);
        if (len <= 1) {
            return s;
        }
        int mid = len >> 1;
        char[] chars = s.toCharArray();
        for (int i = 0; i < mid; ++i) {
            char c = chars[i];
            chars[i] = chars[len - i - 1];
            chars[len - i - 1] = c;
        }
        return new String(chars);
    }

    public static String getStackTraceString(@NonNull Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String concat(Object ... more) {
        return StringUtils.concatSpiltWith(EMPTY, more);
    }

    public static String concatSpiltWith(String split, Object ... more) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < more.length; ++i) {
            if (i != 0) {
                buf.append(split);
            }
            buf.append(StringUtils.toString(more[i]));
        }
        return buf.toString();
    }

    public static boolean contains(Object[] arr, Object ... obj) {
        if (arr == null || obj == null || arr.length == 0) {
            return false;
        }
        return Arrays.asList(arr).containsAll(Arrays.asList(obj));
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (!object.getClass().isArray()) {
            return object.toString();
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        return "Couldn't find a correct type for the object";
    }

    public static String replaceSpecialCharacter(String str) {
        String dest = EMPTY;
        if (str != null) {
            String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(str);
            dest = m.replaceAll(EMPTY).trim();
        }
        return dest;
    }

    public static String replaceBracket(String str) {
        String dest = EMPTY;
        if (str != null) {
            String regEx = "[\\[\\]]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(str);
            dest = m.replaceAll(EMPTY).trim();
        }
        return dest;
    }

    public static String replaceBlank(String str) {
        String dest = EMPTY;
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll(EMPTY);
        }
        return dest;
    }

    public static List<String> stringToList(String str, String separator) {
        return Arrays.asList(str.split(separator));
    }

    public static String listToString(List<String> list, String separator) {
        if (list == null || list.size() == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i)).append(separator);
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static String getSimpleName(Object object) {
        return object != null ? object.getClass().getSimpleName() : "NULL";
    }

    public static String getName(Object object) {
        return object != null ? object.getClass().getName() : "NULL";
    }

    public static String format2Decimals(String str) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        return StringUtils.isEmpty(str) ? EMPTY : decimalFormat.format(StringUtils.toDouble(str, -1.0));
    }

    public static String format2Decimals(double number) {
        return new DecimalFormat("0.00").format(number);
    }

    public static String format2Decimals(float number) {
        return new DecimalFormat("0.00").format(number);
    }

    public static int compareVersionName(@NonNull String versionName1, @NonNull String versionName2) {
        if (versionName1.equals(versionName2)) {
            return 0;
        }
        String[] versionArray1 = versionName1.split("\\.");
        String[] versionArray2 = versionName2.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }
}

