/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.os.Environment;
import android.util.Log;
import com.dayouzc.e2e.core.DYUtils;
import com.orhanobut.logger.AndroidLogAdapter;
import com.orhanobut.logger.FormatStrategy;
import com.orhanobut.logger.LogAdapter;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.PrettyFormatStrategy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;

@SuppressLint(value={"SimpleDateFormat"})
public class LogUtils {
    public static final String CACHE_DIR_NAME = "DayouLog";
    public static boolean isDebugModel = false;
    public static boolean isSaveDebugInfo = false;
    public static boolean isSaveCrashInfo = false;

    public static void init(boolean isDebugModel, boolean isSaveDebugInfo, boolean isSaveCrashInfo) {
        PrettyFormatStrategy formatStrategy = PrettyFormatStrategy.newBuilder().showThreadInfo(true).tag("E2EContext").build();
        Logger.addLogAdapter((LogAdapter)new AndroidLogAdapter((FormatStrategy)formatStrategy));
        LogUtils.isDebugModel = isDebugModel;
        LogUtils.isSaveDebugInfo = isSaveDebugInfo;
        LogUtils.isSaveCrashInfo = isSaveCrashInfo;
        if (isSaveCrashInfo && isSaveDebugInfo) {
            LogUtils.d("<-<-<-<-<-<-<-<- \u5f00\u542f\u8c03\u8bd5\u6a21\u5f0f ->->->->->->->->");
        }
    }

    public static void v(String tag, String msg) {
        if (isDebugModel) {
            Log.v((String)tag, (String)("--> " + msg));
        }
    }

    public static void d(String tag, String msg) {
        if (isDebugModel) {
            Log.d((String)tag, (String)("--> " + msg));
        }
    }

    public static void i(String tag, String msg) {
        if (isDebugModel) {
            Log.i((String)tag, (String)("--> " + msg));
        }
    }

    public static void w(String tag, String msg) {
        if (isDebugModel) {
            Log.w((String)tag, (String)("--> " + msg));
        }
    }

    public static void e(final String tag, final String msg) {
        if (isDebugModel) {
            Log.e((String)tag, (String)("--> " + msg));
        }
        if (isSaveDebugInfo) {
            new Thread(){

                @Override
                public void run() {
                    LogUtils.write(LogUtils.time() + tag + " --> " + msg + "\n");
                }
            }.start();
        }
    }

    public static void v(String msg) {
        Logger.v((String)msg, (Object[])new Object[0]);
    }

    public static void d(String msg) {
        Logger.d((Object)msg);
    }

    public static void i(String msg) {
        Logger.d((Object)msg);
    }

    public static void w(String msg) {
        Logger.w((String)msg, (Object[])new Object[0]);
    }

    public static void e(final String msg) {
        Logger.e((String)msg, (Object[])new Object[0]);
        if (isSaveDebugInfo) {
            new Thread(){

                @Override
                public void run() {
                    LogUtils.write(LogUtils.time() + " --> " + msg + "\n");
                }
            }.start();
        }
    }

    public static void e(final String tag, final Throwable tr) {
        if (isSaveCrashInfo) {
            new Thread(){

                @Override
                public void run() {
                    LogUtils.write(LogUtils.time() + tag + " [CRASH] --> " + LogUtils.getStackTraceString(tr) + "\n");
                }
            }.start();
        }
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        return sw.toString();
    }

    private static String time() {
        return "[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis())) + "] ";
    }

    private static String date() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
    }

    public static synchronized void write(String content) {
        try {
            FileWriter writer = new FileWriter(LogUtils.getFile(), true);
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getFile() throws IOException {
        File filePath;
        File sdDir;
        block9: {
            sdDir = null;
            if (Environment.getExternalStorageState().equals("mounted")) {
                sdDir = Environment.getExternalStorageDirectory();
            }
            if (null == sdDir) {
                sdDir = DYUtils.getContext().getExternalCacheDir();
            }
            File cacheDir = new File(sdDir + File.separator + CACHE_DIR_NAME);
            try {
                if (!cacheDir.exists()) {
                    cacheDir.mkdir();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            filePath = new File(cacheDir + File.separator + LogUtils.date() + ".txt");
            if (!filePath.exists()) {
                try {
                    filePath.createNewFile();
                }
                catch (Exception e) {
                    sdDir = DYUtils.getContext().getExternalCacheDir();
                    cacheDir = new File(sdDir + File.separator + CACHE_DIR_NAME);
                    if (!cacheDir.exists()) {
                        cacheDir.mkdir();
                    }
                    if ((filePath = new File(cacheDir + File.separator + LogUtils.date() + ".txt")).exists()) break block9;
                    filePath.createNewFile();
                }
            }
        }
        LogUtils.d("\u65e5\u5fd7\u4fdd\u5b58\u76ee\u5f55\u4e3a\uff1a" + sdDir + "\u8be6\u7ec6\u5730\u5740\u4e3a\uff1a" + filePath);
        return filePath.toString();
    }
}

