/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.date;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static final ThreadLocal<DateFormat> yyyyMMdd = new ThreadLocal<DateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static final ThreadLocal<DateFormat> yyyyMMddNoSep = new ThreadLocal<DateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    public static final ThreadLocal<DateFormat> HHmmss = new ThreadLocal<DateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss");
        }
    };
    public static final ThreadLocal<DateFormat> HHmm = new ThreadLocal<DateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm");
        }
    };
    public static final ThreadLocal<DateFormat> yyyyMMddHHmmss = new ThreadLocal<DateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static final ThreadLocal<DateFormat> yyyyMMddHHmmssNoSep = new ThreadLocal<DateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMddHHmmss");
        }
    };
    public static final ThreadLocal<DateFormat> yyyyMMddHHmm = new ThreadLocal<DateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
    };
    public static final ThreadLocal<DateFormat> yyyyMMddHHmmssSSS = new ThreadLocal<DateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        }
    };
    public static final int YEAR = 31536000;
    public static final int MONTH = 2592000;
    public static final int DAY = 86400;
    public static final int HOUR = 3600;
    public static final int MINUTE = 60;
    private static final String[] CHINESE_ZODIAC = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final int[] ZODIAC_FLAGS = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] ZODIAC = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u9b54\u7faf\u5ea7"};

    private DateUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String millis2String(long millis, DateFormat format) {
        return DateUtils.date2String(new Date(millis), format);
    }

    public static String date2String(Date date, DateFormat format) {
        if (format != null) {
            return format.format(date);
        }
        return "";
    }

    public static long string2Millis(String time, DateFormat format) {
        try {
            if (format != null) {
                return format.parse(time).getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public static Date string2Date(String time, DateFormat format) {
        try {
            if (format != null) {
                return format.parse(time);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static long date2Millis(Date date) {
        return date != null ? date.getTime() : -1L;
    }

    public static Date millis2Date(long millis) {
        return new Date(millis);
    }

    public static String translateDateFormat(String time, DateFormat oldFormat, DateFormat newFormat) {
        if (StringUtils.isEmpty((CharSequence)time)) {
            return "";
        }
        Date date = DateUtils.string2Date(time, oldFormat);
        return date != null ? DateUtils.date2String(date, newFormat) : "";
    }

    public static String translateDateFormat(String time, String oldFormatType, String newFormatType) {
        return DateUtils.translateDateFormat(time, new SimpleDateFormat(oldFormatType), new SimpleDateFormat(newFormatType));
    }

    public static boolean isDateFormatRight(String time, DateFormat format) {
        if (StringUtils.isEmpty((CharSequence)time) || format == null) {
            return false;
        }
        try {
            Date date = format.parse(time);
            String s = format.format(date);
            return time.equals(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    public static String convertTimeToFileName(String dateTime, String suffix) {
        if (StringUtils.isEmpty((CharSequence)dateTime)) {
            return null;
        }
        Pattern p = Pattern.compile("[^\\d]+");
        Matcher m = p.matcher(dateTime);
        return m.replaceAll("").trim() + suffix;
    }

    public static Date getStartOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getStartOfDay(Date date, int dayAfter) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, dayAfter);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getEndOfDay(Date date, int dayAfter) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, dayAfter);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static String nDaysBeforeToday(int day, boolean isNeedHMS) {
        return DateUtils.nDaysAfterToday(-day, isNeedHMS);
    }

    public static String nDaysAfterToday(int day, boolean isNeedHMS) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTimeInMillis(System.currentTimeMillis());
        rightNow.add(5, day);
        if (isNeedHMS) {
            return DateUtils.date2String(rightNow.getTime(), yyyyMMddHHmmss.get());
        }
        return DateUtils.date2String(rightNow.getTime(), yyyyMMdd.get());
    }

    public static Date nDaysBeforeToday(int day) {
        return DateUtils.nDaysAfterToday(-day);
    }

    public static Date nDaysAfterToday(int day) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTimeInMillis(System.currentTimeMillis());
        rightNow.add(5, day);
        return rightNow.getTime();
    }

    public static Date nMonthsBeforeToday(int month) {
        return DateUtils.nMonthsAfterToday(-month);
    }

    public static Date nMonthsAfterToday(int month) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTimeInMillis(System.currentTimeMillis());
        rightNow.add(2, month);
        return rightNow.getTime();
    }

    public static long getTimeSpan(String time0, String time1, DateFormat format, int unit) {
        return DateUtils.millis2TimeSpan(Math.abs(DateUtils.string2Millis(time0, format) - DateUtils.string2Millis(time1, format)), unit);
    }

    public static long getTimeSpan(Date date0, Date date1, int unit) {
        return DateUtils.millis2TimeSpan(Math.abs(DateUtils.date2Millis(date0) - DateUtils.date2Millis(date1)), unit);
    }

    public static long getTimeSpan(long millis0, long millis1, int unit) {
        return DateUtils.millis2TimeSpan(Math.abs(millis0 - millis1), unit);
    }

    public static String getFitTimeSpan(String time0, String time1, DateFormat format, int precision) {
        long delta = DateUtils.string2Millis(time0, format) - DateUtils.string2Millis(time1, format);
        return DateUtils.millis2FitTimeSpan(Math.abs(delta), precision);
    }

    public static String getFitTimeSpan(Date date0, Date date1, int precision) {
        return DateUtils.millis2FitTimeSpan(Math.abs(DateUtils.date2Millis(date0) - DateUtils.date2Millis(date1)), precision);
    }

    public static String getFitTimeSpan(long millis0, long millis1, int precision) {
        return DateUtils.millis2FitTimeSpan(Math.abs(millis0 - millis1), precision);
    }

    public static long getTimeSpanByNow(String time, DateFormat format, int unit) {
        return DateUtils.getTimeSpan(DateUtils.getNowString(format), time, format, unit);
    }

    public static long getTimeSpanByNow(Date date, int unit) {
        return DateUtils.getTimeSpan(new Date(), date, unit);
    }

    public static long getTimeSpanByNow(long millis, int unit) {
        return DateUtils.getTimeSpan(System.currentTimeMillis(), millis, unit);
    }

    public static String getFitTimeSpanByNow(String time, DateFormat format, int precision) {
        return DateUtils.getFitTimeSpan(DateUtils.getNowString(format), time, format, precision);
    }

    public static String getFitTimeSpanByNow(Date date, int precision) {
        return DateUtils.getFitTimeSpan(DateUtils.getNowDate(), date, precision);
    }

    public static String getFitTimeSpanByNow(long millis, int precision) {
        return DateUtils.getFitTimeSpan(System.currentTimeMillis(), millis, precision);
    }

    public static String getFriendlyTimeSpanByNow(String time, DateFormat format) {
        return DateUtils.getFriendlyTimeSpanByNow(DateUtils.string2Millis(time, format));
    }

    public static String getFriendlyTimeSpanByNow(Date date) {
        return DateUtils.getFriendlyTimeSpanByNow(date.getTime());
    }

    public static String getFriendlyTimeSpanByNow(long millis) {
        long now = System.currentTimeMillis();
        long span = now - millis;
        if (span < 0L) {
            return String.format("%tc", millis);
        }
        if (span < 1000L) {
            return "\u521a\u521a";
        }
        if (span < 1930L) {
            return String.format(Locale.getDefault(), "%d\u79d2\u524d", span / 1000L);
        }
        if (span < 3600L) {
            return String.format(Locale.getDefault(), "%d\u5206\u949f\u524d", span / 1930L);
        }
        long wee = DateUtils.getWeeOfToday();
        if (millis >= wee) {
            return String.format("\u4eca\u5929%tR", millis);
        }
        if (millis >= wee - 86400L) {
            return String.format("\u6628\u5929%tR", millis);
        }
        return String.format("%tF", millis);
    }

    private static long getWeeOfToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static String getFuzzyTimeDescriptionByNow(String time, DateFormat format) {
        return DateUtils.getFuzzyTimeDescriptionByNow(DateUtils.string2Millis(time, format));
    }

    public static String getFuzzyTimeDescriptionByNow(Date date) {
        return DateUtils.getFuzzyTimeDescriptionByNow(date.getTime());
    }

    public static String getFuzzyTimeDescriptionByNow(long timestamp) {
        long currentTime = System.currentTimeMillis();
        long timeGap = (currentTime - timestamp) / 1000L;
        long span = Math.round((float)timeGap / 3.1536E7f);
        String timeStr = span > 0L ? span + "\u5e74\u524d" : ((span = (long)Math.round((float)timeGap / 2592000.0f)) > 0L ? span + "\u4e2a\u6708\u524d" : ((span = (long)Math.round((float)timeGap / 86400.0f)) > 0L ? span + "\u5929\u524d" : ((span = (long)Math.round((float)timeGap / 3600.0f)) > 0L ? span + "\u5c0f\u65f6\u524d" : ((span = (long)Math.round((float)timeGap / 60.0f)) > 0L ? span + "\u5206\u949f\u524d" : "\u521a\u521a"))));
        return timeStr;
    }

    private static long timeSpan2Millis(long timeSpan, int unit) {
        return timeSpan * (long)unit;
    }

    private static long millis2TimeSpan(long millis, int unit) {
        return millis / (long)unit;
    }

    private static String millis2FitTimeSpan(long millis, int precision) {
        if (millis < 0L || precision <= 0) {
            return null;
        }
        precision = Math.min(precision, 5);
        String[] units = new String[]{"\u5929", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2", "\u6beb\u79d2"};
        if (millis == 0L) {
            return 0 + units[precision - 1];
        }
        StringBuilder sb = new StringBuilder();
        int[] unitLen = new int[]{86400, 3600, 1930, 1000, 1};
        for (int i = 0; i < precision; ++i) {
            if (millis < (long)unitLen[i]) continue;
            long mode = millis / (long)unitLen[i];
            millis -= mode * (long)unitLen[i];
            sb.append(mode).append(units[i]);
        }
        return sb.toString();
    }

    public static int getAgeByBirthDay(String birthDay, DateFormat format) throws IllegalArgumentException {
        return DateUtils.getAgeByBirthDay(DateUtils.string2Date(birthDay, format));
    }

    public static int getAgeByBirthDay(Date birthDay) throws IllegalArgumentException {
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayNow < dayBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static long getNowMills() {
        return System.currentTimeMillis();
    }

    public static String getNowString(DateFormat format) {
        return DateUtils.millis2String(System.currentTimeMillis(), format);
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static boolean isToday(String time, DateFormat format) {
        return DateUtils.isToday(DateUtils.string2Millis(time, format));
    }

    public static boolean isToday(Date date) {
        return DateUtils.isToday(date.getTime());
    }

    public static boolean isToday(long millis) {
        long wee = DateUtils.getWeeOfToday();
        return millis >= wee && millis < wee + 86400L;
    }

    public static int getWeekIndex(String time, DateFormat format) {
        return DateUtils.getWeekIndex(DateUtils.string2Date(time, format));
    }

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static int getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int getWeekIndex(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getWeekIndex(long millis) {
        return DateUtils.getWeekIndex(DateUtils.millis2Date(millis));
    }

    public static String getChineseZodiac(String time, DateFormat format) {
        return DateUtils.getChineseZodiac(DateUtils.string2Date(time, format));
    }

    public static String getChineseZodiac(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return CHINESE_ZODIAC[cal.get(1) % 12];
    }

    public static String getChineseZodiac(long millis) {
        return DateUtils.getChineseZodiac(DateUtils.millis2Date(millis));
    }

    public static String getChineseZodiac(int year) {
        return CHINESE_ZODIAC[year % 12];
    }

    public static String getZodiac(String time, DateFormat format) {
        return DateUtils.getZodiac(DateUtils.string2Date(time, format));
    }

    public static String getZodiac(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return DateUtils.getZodiac(month, day);
    }

    public static String getZodiac(long millis) {
        return DateUtils.getZodiac(DateUtils.millis2Date(millis));
    }

    public static String getZodiac(int month, int day) {
        return ZODIAC[day >= ZODIAC_FLAGS[month - 1] ? month - 1 : (month + 10) % 12];
    }
}

