/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.system;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import androidx.annotation.RequiresPermission;
import com.dayouzc.e2e.core.DYUtils;
import com.dayouzc.e2e.core.bean.DeviceData;
import com.dayouzc.e2e.core.bean.DeviceDataDTO;
import com.dayouzc.e2e.core.util.DevicesUtils;
import com.dayouzc.e2e.core.util.LoginUtils;
import com.dayouzc.e2e.core.util.StringUtils;
import com.dayouzc.e2e.core.util.app.AppUtils;
import com.dayouzc.e2e.core.util.common.ShellUtils;
import com.dayouzc.e2e.core.util.data.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public final class DeviceUtils {
    private static final String ANDROID = "Android";
    @SuppressLint(value={"SdCardPath"})
    private static String YOUPIE_PATH = "/mnt/sdcard/dycsctek/token/youpie.txt";

    private DeviceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Map<String, String> getDeviceInfos() {
        TreeMap<String, String> deviceInfos = new TreeMap<String, String>();
        Field[] fields = Build.class.getDeclaredFields();
        try {
            PackageManager packageManager = AppUtils.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(AppUtils.getPackageName(), 1);
            if (packageInfo != null) {
                deviceInfos.put("packageName", packageInfo.packageName);
                deviceInfos.put("versionName", packageInfo.versionName);
                deviceInfos.put("versionCode", String.valueOf(packageInfo.versionCode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                deviceInfos.put(field.getName(), StringUtils.toString(field.get("")));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return deviceInfos;
    }

    public static String getDisplayDeviceInfos() {
        Map<String, String> deviceInfos = DeviceUtils.getDeviceInfos();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : deviceInfos.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key + "=" + value + "\r\n");
        }
        return sb.toString();
    }

    public static String getAndroidVersionName() {
        return "Android " + DeviceUtils.getSDKVersionName() + ", API " + DeviceUtils.getSDKVersionCode();
    }

    public static String getSDKVersionName() {
        return Build.VERSION.RELEASE;
    }

    public static int getSDKVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    public static String getDeviceBrand() {
        return Build.BOARD + "  " + Build.MANUFACTURER;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID() {
        return Settings.Secure.getString((ContentResolver)DYUtils.getContext().getContentResolver(), (String)"android_id");
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getHardware() {
        return Build.HARDWARE;
    }

    public static String getProduct() {
        return Build.PRODUCT;
    }

    public static String getDevice() {
        return Build.DEVICE;
    }

    public static String getDisplayVersion() {
        return Build.DISPLAY;
    }

    public static String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static String getCountry(Context ctx) {
        TelephonyManager tm = (TelephonyManager)ctx.getSystemService("phone");
        Locale locale = Locale.getDefault();
        return tm.getSimState() == 5 ? tm.getSimCountryIso().toLowerCase(Locale.getDefault()) : locale.getCountry().toLowerCase(locale);
    }

    public static String getDeviceUA(Context context) {
        String ua = "";
        try {
            if (Build.VERSION.SDK_INT < 19) {
                WebView mWebView = new WebView(context);
                ua = mWebView.getSettings().getUserAgentString();
                mWebView.destroy();
                mWebView = null;
            } else {
                ua = WebSettings.getDefaultUserAgent((Context)context);
            }
            if (DevicesUtils.isYouPie() || DevicesUtils.isARM()) {
                ua = ua + ";webview_android;youpie";
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return ua;
    }

    public static String getDeviceType() {
        String type = DeviceUtils.getYPSN();
        if (type.startsWith("YP")) {
            return "YP";
        }
        if (type.startsWith("CS")) {
            return "CS";
        }
        return "OTHER";
    }

    public static String getYPSN() {
        String youpieSn = LoginUtils.getyoupieSn();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)youpieSn)) {
            LoginUtils.setYouPieSn((String)DeviceUtils.getSerial());
            return DeviceUtils.getSerial();
        }
        return youpieSn;
    }

    public static String getyoupieSn() {
        String youpiesn = "";
        DeviceDataDTO data = new DeviceDataDTO();
        if (!DeviceUtils.fileIsExists(YOUPIE_PATH)) {
            return "";
        }
        String userStr = DeviceUtils.read(YOUPIE_PATH);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userStr)) {
            DeviceData user = JsonUtils.fromJSON(userStr, DeviceData.class);
            youpiesn = user.getDevicesSn();
        }
        return youpiesn;
    }

    public static String read(String filePath) {
        String sbStr = null;
        try {
            if (Environment.getExternalStorageState().equals("mounted")) {
                File sdDirFile = new File(filePath);
                FileInputStream fis = new FileInputStream(sdDirFile);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                StringBuilder sb = new StringBuilder("");
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                sbStr = sb.toString();
                return sbStr;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sbStr;
    }

    public static boolean fileIsExists(String filePath) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    private static String getSerial() {
        String serial = "NO Search";
        if (Build.VERSION.SDK_INT >= 29) {
            return serial;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            serial = Build.getSerial();
            return serial;
        }
        serial = Build.SERIAL;
        return serial;
    }

    public static String getDeviceModel() {
        String model = Build.MODEL;
        model = model != null ? model.trim() : "";
        return model;
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static String getMacAddress() {
        String macAddress = DeviceUtils.getMacAddressByWifiInfo();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByNetworkInterface();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByFile();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        return "please open wifi";
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    private static String getMacAddressByWifiInfo() {
        try {
            WifiInfo info;
            WifiManager wifi = (WifiManager)DYUtils.getContext().getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null) {
                return info.getMacAddress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    @RequiresPermission(value="android.permission.INTERNET")
    private static String getMacAddressByNetworkInterface() {
        try {
            ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface ni : nis) {
                byte[] macBytes;
                if (!ni.getName().equalsIgnoreCase("wlan0") || (macBytes = ni.getHardwareAddress()) == null || macBytes.length <= 0) continue;
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02x:", b));
                }
                return res1.deleteCharAt(res1.length() - 1).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByFile() {
        String name;
        ShellUtils.CommandResult result = ShellUtils.execCommand("getprop wifi.interface", false);
        if (result.result == 0 && (name = result.successMsg) != null) {
            result = ShellUtils.execCommand("cat /sys/class/net/" + name + "/address", false);
            if (result.result == 0 && result.successMsg != null) {
                return result.successMsg;
            }
        }
        return "02:00:00:00:00:00";
    }

    public static boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    public static void shutdown() {
        ShellUtils.execCommand("reboot -p", true);
        Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
        DYUtils.getContext().startActivity(intent.addFlags(0x10000000));
    }

    public static void reboot() {
        ShellUtils.execCommand("reboot", true);
        Intent intent = new Intent("android.intent.action.REBOOT");
        intent.putExtra("nowait", 1);
        intent.putExtra("interval", 1);
        intent.putExtra("window", 0);
        DYUtils.getContext().sendBroadcast(intent);
    }

    public static void reboot(String reason) {
        PowerManager mPowerManager = (PowerManager)DYUtils.getContext().getSystemService("power");
        try {
            if (mPowerManager == null) {
                return;
            }
            mPowerManager.reboot(reason);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reboot2Recovery() {
        ShellUtils.execCommand("reboot recovery", true);
    }

    public static void reboot2Bootloader() {
        ShellUtils.execCommand("reboot bootloader", true);
    }
}

