package com.dayouzc.e2e.core.util.system;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.hardware.Camera;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

/**
 * 运行环境信息
 *
 * @author 何鑫
 * @date 2018/5/24 10:50
 */
public final class SysEnvUtils {

   /***Log输出标识**/
   private static final String TAG = SysEnvUtils.class.getSimpleName();

   /***屏幕显示材质**/
   private static final DisplayMetrics mDisplayMetrics = new DisplayMetrics();

   /**上下文**/
   private static Context context;

   /**操作系统名称(GT-I9100G)***/
   public static final String MODEL_NUMBER = Build.MODEL;

   /**操作系统名称(I9100G)***/
   public static final String DISPLAY_NAME = Build.DISPLAY;

   /**操作系统版本(4.4)***/
   public static final String OS_VERSION = Build.VERSION.RELEASE;;

   /**应用程序版本***/
   public static final String APP_VERSION = getVersion();

   /***屏幕宽度**/
   public static final int SCREEN_WIDTH = getDisplayMetrics().widthPixels;

   /***屏幕高度**/
   public static final int SCREEN_HEIGHT = getDisplayMetrics().heightPixels;

   /***Activity之间数据传输数据对象Key**/
   public static final String ACTIVITY_DTO_KEY = "ACTIVITY_DTO_KEY";



   /**获取系统显示材质***/
   public static DisplayMetrics getDisplayMetrics(){
         WindowManager windowMgr = (WindowManager)context.getSystemService(Context.WINDOW_SERVICE);
         windowMgr.getDefaultDisplay().getMetrics(mDisplayMetrics);
         return mDisplayMetrics;
   }

   /**获取摄像头支持的分辨率***/
   public static List<Camera.Size> getSupportedPreviewSizes(Camera camera){
       Camera.Parameters parameters = camera.getParameters();
       List<Camera.Size> sizeList = parameters.getSupportedPreviewSizes();
       return sizeList;
   }

   /**
    * 获取应用程序版本（versionName）
    * @return 当前应用的版本号
    */
   public static String getVersion() {
       PackageManager manager = context.getPackageManager();
       PackageInfo info = null;
       try {
           info = manager.getPackageInfo(context.getPackageName(), 0);
       } catch (NameNotFoundException e) {
           Log.e(TAG, "获取应用程序版本失败，原因："+e.getMessage());
           return "";
       }

       return info.versionName;
   }

   /**
    * 获取系统内核版本
    * @return
    */
   public static String getKernelVersion(){
       String strVersion= "";
       FileReader mFileReader = null;
       BufferedReader mBufferedReader = null;
       try {
           mFileReader = new FileReader("/proc/version");
           mBufferedReader = new BufferedReader(mFileReader, 8192);
           String str2 = mBufferedReader.readLine();
           strVersion = str2.split("\\s+")[2];//KernelVersion

       } catch (Exception e) {
           Log.e(TAG, "获取系统内核版本失败，原因："+e.getMessage());
       }finally{
           try {
               mBufferedReader.close();
           } catch (IOException e) {
               e.printStackTrace();
           }
       }

       return strVersion;
   }
}
