/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.dayouzc.e2e.core.DYUtils;
import java.lang.reflect.Field;
import java.util.HashMap;

public class KeyboardUtils
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final int MAGIC_NUMBER = 200;
    private SoftKeyboardToggleListener mCallback;
    private View mRootView;
    private Boolean prevValue = null;
    private float mScreenDensity = 1.0f;
    private static HashMap<SoftKeyboardToggleListener, KeyboardUtils> sListenerMap = new HashMap();

    public void onGlobalLayout() {
        boolean isVisible;
        Rect r = new Rect();
        this.mRootView.getWindowVisibleDisplayFrame(r);
        int heightDiff = this.mRootView.getRootView().getHeight() - (r.bottom - r.top);
        float dp = (float)heightDiff / this.mScreenDensity;
        boolean bl = isVisible = dp > 200.0f;
        if (this.mCallback != null && (this.prevValue == null || isVisible != this.prevValue)) {
            this.prevValue = isVisible;
            this.mCallback.onToggleSoftKeyboard(isVisible);
        }
    }

    public static void addKeyboardToggleListener(Activity act, SoftKeyboardToggleListener listener) {
        KeyboardUtils.removeKeyboardToggleListener(listener);
        sListenerMap.put(listener, new KeyboardUtils(act, listener));
    }

    public static void addKeyboardToggleListener(ViewGroup act, SoftKeyboardToggleListener listener) {
        KeyboardUtils.removeKeyboardToggleListener(listener);
        sListenerMap.put(listener, new KeyboardUtils(act, listener));
    }

    public static void removeKeyboardToggleListener(SoftKeyboardToggleListener listener) {
        if (sListenerMap.containsKey(listener)) {
            KeyboardUtils k = sListenerMap.get(listener);
            k.removeListener();
            sListenerMap.remove(listener);
        }
    }

    public static void removeAllKeyboardToggleListeners() {
        for (SoftKeyboardToggleListener l : sListenerMap.keySet()) {
            sListenerMap.get(l).removeListener();
        }
        sListenerMap.clear();
    }

    public static void toggleKeyboardVisibility(Context context) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        inputMethodManager.toggleSoftInput(2, 0);
    }

    public static void forceCloseKeyboard(View activeView) {
        InputMethodManager inputMethodManager = (InputMethodManager)activeView.getContext().getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(activeView.getWindowToken(), 0);
    }

    private void removeListener() {
        this.mCallback = null;
        if (Build.VERSION.SDK_INT >= 16) {
            this.mRootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        } else {
            this.mRootView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    private KeyboardUtils(Activity act, SoftKeyboardToggleListener listener) {
        this.mCallback = listener;
        this.mRootView = ((ViewGroup)act.findViewById(0x1020002)).getChildAt(0);
        this.mRootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.mScreenDensity = act.getResources().getDisplayMetrics().density;
    }

    private KeyboardUtils(ViewGroup viewGroup, SoftKeyboardToggleListener listener) {
        this.mCallback = listener;
        this.mRootView = viewGroup;
        this.mRootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.mScreenDensity = viewGroup.getResources().getDisplayMetrics().density;
    }

    public static void setSoftInputAdjustNothing(@NonNull Activity activity) {
        activity.getWindow().setSoftInputMode(50);
    }

    public static void setSoftInputAdjustResize(@NonNull Activity activity) {
        activity.getWindow().setSoftInputMode(18);
    }

    public static void setSoftInputAdjustPan(@NonNull Activity activity) {
        activity.getWindow().setSoftInputMode(34);
    }

    public static boolean onDisableBackKeyDown(int keyCode) {
        switch (keyCode) {
            case 4: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public static void dispatchTouchEvent(MotionEvent ev, Activity activity) {
        View v;
        if (ev.getAction() == 0 && KeyboardUtils.isShouldHideKeyboard(v = activity.getCurrentFocus(), ev)) {
            KeyboardUtils.hideSoftInput(v);
        }
    }

    public static void dispatchTouchEvent(MotionEvent ev, Dialog dialog) {
        View v;
        if (ev.getAction() == 0 && KeyboardUtils.isShouldHideKeyboard(v = dialog.getCurrentFocus(), ev)) {
            KeyboardUtils.hideSoftInput(v);
        }
    }

    public static void dispatchTouchEvent(MotionEvent ev, View focusView) {
        if (ev.getAction() == 0 && KeyboardUtils.isShouldHideKeyboard(focusView, ev)) {
            KeyboardUtils.hideSoftInput(focusView);
        }
    }

    public static void dispatchTouchEvent(MotionEvent ev, Window window) {
        View v;
        if (ev.getAction() == 0 && KeyboardUtils.isShouldHideKeyboard(v = window.getCurrentFocus(), ev)) {
            KeyboardUtils.hideSoftInput(v);
        }
    }

    public static boolean isShouldHideKeyboard(View v, MotionEvent event) {
        if (v != null && v instanceof EditText) {
            int[] l = new int[]{0, 0};
            v.getLocationInWindow(l);
            int left = l[0];
            int top = l[1];
            int bottom = top + v.getHeight();
            int right = left + v.getWidth();
            return !(event.getX() > (float)left && event.getX() < (float)right && event.getY() > (float)top && event.getY() < (float)bottom);
        }
        return false;
    }

    public static void hideSoftInput(View view) {
        InputMethodManager imm = (InputMethodManager)DYUtils.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void toggleSoftInput() {
        InputMethodManager imm = (InputMethodManager)DYUtils.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.toggleSoftInput(2, 0);
    }

    public static void fixSoftInputLeaks(Context context) {
        if (context == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        String[] strArr = new String[]{"mCurRootView", "mServedView", "mNextServedView"};
        for (int i = 0; i < strArr.length; ++i) {
            try {
                Object obj;
                Field declaredField = imm.getClass().getDeclaredField(strArr[i]);
                if (declaredField == null) continue;
                if (!declaredField.isAccessible()) {
                    declaredField.setAccessible(true);
                }
                if ((obj = declaredField.get(imm)) == null || !(obj instanceof View)) continue;
                View view = (View)obj;
                if (view.getContext() == context) {
                    declaredField.set(imm, null);
                    continue;
                }
                return;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static interface SoftKeyboardToggleListener {
        public void onToggleSoftKeyboard(boolean var1);
    }
}

