package com.dayouzc.e2e.core.util.file;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.format.Formatter;

import com.dayouzc.e2e.core.constant.common.BaseConstant;
import com.dayouzc.e2e.core.util.FileUtils;
import com.dayouzc.e2e.core.util.LogUtils;
import com.dayouzc.e2e.core.util.ToastUtils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.callback.FileCallback;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.base.Request;

import org.apache.commons.lang3.StringUtils;

import java.io.File;
/**
 * 下载文件并打开
 *
 * @version V1.0 <<br>>
 * @author: hexin
 * @date 2017-04-01 15:07
 */
@SuppressLint("SimpleDateFormat")
public class DownLoadUtils {
    /** 下载文件夹地址 */
    public static String DM_TARGET_FOLDER = LoadFileUtils.DM_TARGET_FOLDER;
    public static Context sContext;
    public static Handler mHandler;

    private DownLoadUtils() {

    }

    public static void register(Context context,String downloadUrl) {
        sContext = context;
        if (StringUtils.isNotEmpty(downloadUrl)){
            DM_TARGET_FOLDER = downloadUrl;
        }
    }

    public static void downFile(String url, Handler mHandler) {
        DownLoadUtils.mHandler = mHandler;
        // 从路径中获取
        String filename = null;
        if (filename == null || "".equals(filename)) {
            filename = url.substring(url.lastIndexOf("/") + 1);
        }
        checkFile(url, filename);
    }

    public static void checkFile(String url, String filename) {
        String filenames = DM_TARGET_FOLDER + filename;
        LogUtils.e(BaseConstant.TAG,filenames);
        if (fileIsExists(filenames)) {
            File file = new File(filenames);
            FileUtils.openFile(sContext, file);
        } else {
            fileDownLoad(url, filename);
        }
    }

    /**
     * 判断  存在返回false
     * */
    public static boolean fileIsExists(String filePath) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                return false;
            }
        } catch (Exception e) {

            return false;
        }
        return true;
    }

    public static void fileDownLoad(String url, String filename) {
        OkGo.<File>get(url)
                .tag(sContext)
                .execute(new FileCallback(DM_TARGET_FOLDER,null){
                    @Override
                    public void onStart(Request<File, ? extends Request> request) {
                        LogUtils.d(BaseConstant.TAG, "正在下载中");
                        mHandler.sendEmptyMessage(333);
//                        ToastUtils.showShort("正在下载");
                    }

                    @Override
                    public void onSuccess(Response<File> response) {
                        File body = response.body();
                        LogUtils.d(BaseConstant.TAG, "下载完成");
                        Message msg = new Message();
                        msg.what = 222;
                        msg.obj = body;
                        mHandler.sendMessage(msg);
                    }

                    @Override
                    public void onError(Response<File> response) {
                        super.onError(response);
                        ToastUtils.showToast(sContext, response.getException().getMessage());
                    }

                    @Override
                    public void downloadProgress(Progress progress) {
                        String downloadLength = Formatter.formatFileSize(sContext, progress.currentSize);
                        String totalLength = Formatter.formatFileSize(sContext, progress.totalSize);
                        LogUtils.e(BaseConstant.TAG, (Math.round(progress.fraction * 10000) * 1.0f / 100) + "%");
                        Message msg = new Message();
                        msg.what = 111;
                        msg.obj = (Math.round(progress.fraction * 10000) * 1.0f / 100);
                        mHandler.sendMessage(msg);

                    }
                });
    }
}