package com.dayouzc.e2e.core.util.file;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.format.Formatter;

import com.dayouzc.e2e.core.constant.common.BaseConstant;
import com.dayouzc.e2e.core.util.FileUtils;
import com.dayouzc.e2e.core.util.LogUtils;
import com.dayouzc.e2e.core.util.LoginUtils;
import com.dayouzc.e2e.core.util.ToastUtils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.callback.FileCallback;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.base.Request;

import java.io.File;


/**
 * 下载文件并打开
 *
 * @author 何鑫
 * @date 2018/5/23 11:52
 */
@SuppressLint("SimpleDateFormat")
public class LoadFileUtils {
    public static final String DM_TARGET_FOLDER = "/mnt/sdcard/DYYP/ISERVERAS/PREINST";
    public static Context sContext;

    private LoadFileUtils() {
    }

    public static void register(Context context) {
        sContext = context.getApplicationContext();
    }

    public static void downFile(String url) {
        // 从路径中获取
        String filename = null;
        if (filename == null || "".equals(filename)) {
            filename = url.substring(url.lastIndexOf("/") + 1);
        }
        checkFile(url, filename);
    }

    public static void checkFile(String url, String filename) {
        String filenames = DM_TARGET_FOLDER + filename;
        if (LoginUtils.fileIsExists(filenames)) {
            File file = new File(filenames);
            com.dayouzc.e2e.core.util.FileUtils.openFile(sContext, file);
        } else {
            fileDownLoad(url, filename);
        }
    }

    public static void fileDownLoad(String url, String filename) {
        OkGo.<File>get(url)
                .tag(sContext)
                .execute(new FileCallback(){
                    @Override
                    public void onStart(Request<File, ? extends Request> request) {
                        LogUtils.d(BaseConstant.TAG, "正在下载中");
                        ToastUtils.showToast(sContext, "正在下载");
                    }

                    @Override
                    public void onSuccess(Response<File> response) {
                        File body = response.body();
                        FileUtils.openFile(sContext,body);
                    }

                    @Override
                    public void onError(Response<File> response) {
                        super.onError(response);
                        File body = response.body();
                        ToastUtils.showToast(sContext, "下载出错");
                    }

                    @Override
                    public void downloadProgress(Progress progress) {
                        String downloadLength = Formatter.formatFileSize(DownLoadUtils.sContext, progress.currentSize);
                        String totalLength = Formatter.formatFileSize(DownLoadUtils.sContext, progress.totalSize);
                        LogUtils.e(BaseConstant.TAG, (Math.round(progress.fraction * 10000) * 1.0f / 100) + "%");
//                        ToastUtils.showShort((Math.round(progress.fraction * 10000) * 1.0f / 100) + "%");
                    }
                });

    }
}