/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.security;

import android.os.Build;
import android.text.Html;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class EncodeUtils {
    private EncodeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String urlEncode(String input) {
        return EncodeUtils.urlEncode(input, "UTF-8");
    }

    public static String urlEncode(String input, String charset) {
        try {
            return URLEncoder.encode(input, charset);
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    public static String urlDecode(String input) {
        return EncodeUtils.urlDecode(input, "UTF-8");
    }

    public static String urlDecode(String input, String charset) {
        try {
            return URLDecoder.decode(input, charset);
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    public static byte[] base64Encode(String input) {
        return EncodeUtils.base64Encode(input.getBytes());
    }

    public static byte[] base64Encode(byte[] input) {
        return Base64.encode((byte[])input, (int)2);
    }

    public static String base64Encode2String(byte[] input) {
        return Base64.encodeToString((byte[])input, (int)2);
    }

    public static byte[] base64Decode(String input) {
        return Base64.decode((String)input, (int)2);
    }

    public static byte[] base64Decode(byte[] input) {
        return Base64.decode((byte[])input, (int)2);
    }

    public static byte[] base64UrlSafeEncode(String input) {
        return Base64.encode((byte[])input.getBytes(), (int)8);
    }

    public static String htmlEncode(CharSequence input) {
        StringBuilder sb = new StringBuilder();
        int len = input.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static CharSequence htmlDecode(String input) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)input, (int)0);
        }
        return Html.fromHtml((String)input);
    }
}

