package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.os.Environment;

import com.dayouzc.e2e.core.bean.DeviceData;
import com.dayouzc.e2e.core.bean.PublicData;
import com.dayouzc.e2e.core.constant.common.BaseConstant;
import com.dayouzc.e2e.core.util.data.JsonUtils;

import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

/**
 * 确认领取 本地化信息帮助类
 *
 * @author 何鑫
 * @date 2018/5/24 10:44
 */
public class LoginUtils {

    static String filePath = "/mnt/sdcard/dycsctek/token/publicdata.txt";
    static String filePath2 = "/mnt/sdcard/dycsctek/token/youpie.txt";

    @SuppressLint("SdCardPath")
    private static String FALE_PATH = "/mnt/sdcard/dycsctek/token/publicdata.txt";
    @SuppressLint("SdCardPath")
    private static String YOUPIE_PATH = "/mnt/sdcard/dycsctek/token/youpie.txt";
    @SuppressLint("SdCardPath")
    private static String SAVE_PATH = "/mnt/sdcard/dycsctek/token/";

    public LoginUtils() {
    }

    //写入
    public static boolean setUserInfo(PublicData publicData) {
        boolean isTrue = false;
        PublicData organInfo = getOrganData();
        if (StringUtils.isNotEmpty(organInfo.getOrganId())) {
            publicData.setOrganId(organInfo.getOrganId());
            publicData.setOrganName(organInfo.getOrganName());
        }
        if (publicData != null) {
            String data = com.dayouzc.e2e.core.util.data.JsonUtils.toJSON(publicData);
//            data = JieMe3DES.setData(data);
            try {
                String fileName = "publicdata" + ".txt";
                if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
                    File dir = new File(SAVE_PATH);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(SAVE_PATH + fileName);
                    fos.write(data.toString().getBytes("utf-8"));
                    fos.flush();
                    fos.close();
                    isTrue = true;
                    File file = new File(FALE_PATH);
                    FileInputStream fis = new FileInputStream(file);
                    Reader reader = new InputStreamReader(fis);
                    int line = -1;
                    if ((line = reader.read()) == -1) {
                        isTrue = false;
                    }
                    return isTrue;
                }
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            } catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            } catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return isTrue;
    }

    /**
     * 给组织赋值
     */
    public static boolean setOrganInfo(String OrganId, String Organname) {
        boolean isTrue = false;
        PublicData publicData = getData();
        if (StringUtils.isNotEmpty(OrganId) && StringUtils.isNotEmpty(Organname)) {
            publicData.setOrganId(OrganId);
            publicData.setOrganName(Organname);

            String data = com.dayouzc.e2e.core.util.data.JsonUtils.toJSON(publicData);
            try {
                String fileName = "publicdata" + ".txt";
                if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
                    File dir = new File(SAVE_PATH);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(SAVE_PATH + fileName);
                    fos.write(data.toString().getBytes("utf-8"));
                    fos.flush();
                    fos.close();
                    isTrue = true;
                    File file = new File(FALE_PATH);
                    FileInputStream fis = new FileInputStream(file);
                    Reader reader = new InputStreamReader(fis);
                    int line = -1;
                    if ((line = reader.read()) == -1) {
                        isTrue = false;
                    }
                    return isTrue;
                }
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            } catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            } catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return isTrue;
    }

    // TODO: 2019/7/24 个人不建议这么搞  耗内存 没有安全性

    /**
     * 写入 有派 sn
     */
    public static boolean setYouPieSn(String deviceSn) {
        boolean isTrue = false;
        DeviceData deviceData = new DeviceData();

        if (StringUtils.isEmpty(deviceSn)) {
            return isTrue;
        }
        deviceData.setDevicesSn(deviceSn);
        if (deviceData != null) {
            String data = com.dayouzc.e2e.core.util.data.JsonUtils.toJSON(deviceData);
//            data = JieMe3DES.setData(data);
            try {
                String fileName = "youpie" + ".txt";
                if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
                    File dir = new File(SAVE_PATH);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(SAVE_PATH + fileName);
                    fos.write(data.toString().getBytes("utf-8"));
                    fos.flush();
                    fos.close();
                    isTrue = true;
                    File file = new File(YOUPIE_PATH);
                    FileInputStream fis = new FileInputStream(file);
                    Reader reader = new InputStreamReader(fis);
                    int line = -1;
                    if ((line = reader.read()) == -1) {
                        isTrue = false;
                    }
                    return isTrue;
                }
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            } catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            } catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return isTrue;
    }

    /**
     * 读取文件中的信息
     */
    public static String read(String filePath) {
        // 如果手机插入了SD卡，而且应用程序具有访问SD的权限
        String sbStr = null;
        try {
            if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
                // 获取SD卡的目录
                File sdDirFile = new File(filePath);
                //获取指定文件对应的输入流
                FileInputStream fis = new FileInputStream(sdDirFile);
                //将指定输入流包装成BufferedReader
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));

                StringBuilder sb = new StringBuilder("");
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                sbStr = sb.toString();
                return sbStr;
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return sbStr;
    }

    /**
     * 判断  存在返回fakse
     */
    public static boolean fileIsExists(String filePath) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                return false;
            }
        } catch (Exception e) {
            // TODO: handle exception
            return false;
        }
        return true;
    }

    /**
     * 删除登录文件
     */
    public static void deleteFileForPublicData() {
        try {
            File file = new File(filePath);
            if (file.isFile()) {
                file.delete();
            }
            file.exists();
        } catch (Exception e) {
            // TODO: handle exception
            LogUtils.e(BaseConstant.TAG, "删除文件失败！请检查权限！");
        }
    }

/*
    */
/**
     * 获取所有信息
     *//*

    public static PublicData getData() {
        PublicData response = new PublicData();
        response.setAccountId("account001");
        response.setOrganId("organ001");
        response.setOrganName("organ001");
        response.setAccountName("周宜亮");
        response.setUserName("周宜亮");
        response.setEquipSn("YP116110100000799");
        return response;

    }
*/


    /**
     * 获取所有信息
     */
    public static PublicData getData() {
        PublicData response = new PublicData();
        if (!fileIsExists(FALE_PATH)) {
            return response;
        } else {
            String userStr = read(FALE_PATH);
            if (StringUtils.isNotEmpty(userStr)) {
                PublicData user = com.dayouzc.e2e.core.util.data.JsonUtils.fromJSON(userStr, PublicData.class);
                response = user;
            }
            return response;
        }
    }

    /**
     * 获取用户信息 对象
     */
    public static PublicData getUserData() {
        PublicData response = new PublicData();
        PublicData data = new PublicData();
        if (!fileIsExists(FALE_PATH)) {
            // TODO: 2017-05-03
            return response;
        } else {//存在
            String userStr = read(FALE_PATH);
            if (StringUtils.isNotEmpty(userStr)) {
                PublicData user = com.dayouzc.e2e.core.util.data.JsonUtils.fromJSON(userStr, PublicData.class);
                data.setAccountId(user.getAccountId());
                data.setAccountName(user.getAccountName());
                data.setUserName(user.getUserName());
                data.setPassword(user.getPassword());
                data.setMobile(user.getMobile());
                data.setEquipType("");
                data.setEquipName("");
                data.setEquipSn("");
            }
            return data;
        }
    }

    /**
     * 获取用户信息
     */
    public static String getAccountInfo() {
        String response = null;
        PublicData data = new PublicData();
        if (!fileIsExists(filePath)) {
            return response;
        } else {//存在
            String userStr = read(filePath);
            PublicData user = com.dayouzc.e2e.core.util.data.JsonUtils.fromJSON(userStr, PublicData.class);
            data.setAccountId(user.getAccountId());
            data.setAccountName(user.getAccountName());
            data.setUserName(user.getUserName());
            data.setMobile(user.getMobile());
            response = com.dayouzc.e2e.core.util.data.JsonUtils.toJSON(data);
            // 替换请求数据公用标签头
            return response;
        }
    }

    /**
     * 获取设备信息
     */
    public static String getEquipInfo() {
        String response = null;
        PublicData data = new PublicData();
        if (!fileIsExists(filePath)) {
            // TODO: 2017-05-03
            return response;
        } else {
            String userStr = read(filePath);
            PublicData user = com.dayouzc.e2e.core.util.data.JsonUtils.fromJSON(userStr, PublicData.class);
            data.setEquipType(user.getEquipType());
            data.setEquipName(user.getEquipName());
            data.setEquipSn(user.getEquipSn());
            response = com.dayouzc.e2e.core.util.data.JsonUtils.toJSON(data);
            return response;
        }
    }

    /**
     * 获取组织信息 对象
     */
    public static PublicData getOrganData() {
        PublicData data = new PublicData();
        if (!fileIsExists(FALE_PATH)) {
            // TODO: 2017-05-03
            return data;
        } else {//存在
            String userStr = read(FALE_PATH);
            if (StringUtils.isNotEmpty(userStr)) {
                PublicData user = com.dayouzc.e2e.core.util.data.JsonUtils.fromJSON(userStr, PublicData.class);
                data.setOrganId(user.getOrganId());
                data.setOrganName(user.getOrganName());
            }
            return data;
        }
    }

    /**
     * 获取有派sn 对象
     */
    public static String getyoupieSn() {
        String youpiesn = "";
        DeviceData data = new DeviceData();
        if (!fileIsExists(YOUPIE_PATH)) {
            // TODO: 2017-05-03
            return "";
        } else {//存在
            String userStr = read(YOUPIE_PATH);
            if (StringUtils.isNotEmpty(userStr)) {
                DeviceData user = JsonUtils.fromJSON(userStr, DeviceData.class);
                youpiesn = user.getDevicesSn();
            }
            return youpiesn;
        }
    }


}
