package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.os.Build;

import com.dayouzc.e2e.core.constant.common.BaseConstant;
import com.dayouzc.e2e.core.consts.UIConsts;
import com.dayouzc.e2e.core.util.display.ScreenUtils;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import com.dayouzc.e2eplatform.registerbind.constant.DeviceConstant;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * 设备Sn 相关帮助类
 *
 * @author 何鑫
 */
public class DevicesUtils {

    /**
     * 获取当前设备类型
     */
    public static String getDeviceType() {
        String type = getYPSN();
        if (type.startsWith(UIConsts.DeviceType.YP_DEVICE)) {
            return UIConsts.DeviceType.YP_DEVICE;
        } else if (type.startsWith(UIConsts.DeviceType.ARM_DEVICE)) {
            return UIConsts.DeviceType.ARM_DEVICE;
        } else {
            return UIConsts.DeviceType.OTHER_DEVICE;
        }
    }

    /**
     * 获取设备SN  读取的本地文件
     *//*
    public static String getYPSN() {
        String youpieSn = LoginUtils.getyoupieSn();
        if (StringUtils.isEmpty(youpieSn)) {
            LoginUtils.setYouPieSn(getSerial());
            return getSerial();
        } else {
            return youpieSn;
        }
    }*/

    /**
     * 获取设备SN  读取的本地文件
     */
    public static String getYPSN() {
        return "YP116110100000799";

    }

    @SuppressLint("MissingPermission")
    private static String getSerial() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            return Build.getSerial();
        } else if (Build.VERSION.SDK_INT == Build.VERSION_CODES.Q) {
            return "null";
        } else {
            return Build.SERIAL;
        }
    }

    /**
     * 获取当前设备真实的类型
     */
    public static String getDeviceMode() {
        String type = getYPNum();
        if (type.startsWith(UIConsts.DeviceType.YP_DEVICE)) {
            return UIConsts.DeviceType.YP_DEVICE;
        } else if (type.startsWith(UIConsts.DeviceType.ARM_DEVICE)) {
            return UIConsts.DeviceType.ARM_DEVICE;
        } else {
            return UIConsts.DeviceType.OTHER_DEVICE;
        }
    }

    /**
     * 判断是否是 有派 设备
     */
    public static boolean isYouPie() {
        String type = getDeviceType();
        if (type.equals(UIConsts.DeviceType.YP_DEVICE)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 判断是否是 ARM 设备
     */
    public static boolean isARM() {
        String type = getDeviceType();
        if (type.equals(UIConsts.DeviceType.ARM_DEVICE)) {
            return true;
        } else {
            return false;
        }
    }

    // TODO: 2020/5/27  我们认证的其他设备 暂不考虑 如 K9 桌面机等

    /**
     * 判断是否是 终端 设备
     */
    public static boolean isOtherDevices() {
        String type = getDeviceType();
        if (type.equals(UIConsts.DeviceType.YP_DEVICE)) {
            return false;
        } else if (type.equals(UIConsts.DeviceType.ARM_DEVICE)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * 获取真实的SN
     */
    public static String getYPNum() {
        return getSerial();
    }

    /**
     * 获取屏幕方向
     *
     * @return 0横屏；1竖屏
     */
    public static String getScreenOrientation(ConnectionInfoDTO tokenInfo) {
        //默认为横屏
        String screenOrientation = UIConsts.ScreenOrientationType.LANDSCAPE;
        if (tokenInfo == null) {
            return screenOrientation;
        }

        //如果设备是云端、云端arm、有派，则为横屏；只有终端时，才可能是竖屏（终端时 判断设备屏幕方向 改变横竖屏）
        //是终端
        if (StringUtils.equals(tokenInfo.getObjType(), DeviceConstant.DeviceType.PERIPHER)) {
            //终端默认是竖屏
            screenOrientation = UIConsts.ScreenOrientationType.PORTRAIT;
            //判断屏幕方向 true为横屏
            if (ScreenUtils.isLandscape()) {
                screenOrientation = UIConsts.ScreenOrientationType.LANDSCAPE;
            }

            //如果是微信，则为竖屏
            //TODO 对于某些我们支持的终端，也要是横屏！！！
            // 锐捷桌面机、PAD、等
            String[] deviceModels = {"K9"};
            if (tokenInfo.getPeripher() != null && StringUtils.isNotBlank(tokenInfo.getPeripher().getDeviceModel())
                    && ArrayUtils.contains(deviceModels, tokenInfo.getPeripher().getDeviceModel())) {
                screenOrientation = UIConsts.ScreenOrientationType.LANDSCAPE;
            }
        }
        LogUtils.e(BaseConstant.TAG, "当前设备 屏幕方向为->->->" + UIConsts.ScreenOrientationType.map.get(screenOrientation));
        return screenOrientation;
    }

    /**
     * 判断是否横屏 (设备包括大有自有的设备 以及 合作方的设备)
     *
     * @return {@code true}: 是<br>{@code false}: 否
     */
    public static boolean isLandscape() {
        //默认为横屏 true
        boolean screenOrientation = true;

        //如果设备是云端、云端arm、有派，则为横屏；只有终端时，才可能是竖屏（终端时 判断设备屏幕方向 改变横竖屏）
        //是终端
        if (isOtherDevices()) {
            //终端默认是竖屏
            screenOrientation = false;
            //判断屏幕方向 true为横屏
            if (ScreenUtils.isLandscape()) {
                screenOrientation = true;
            }

            //如果是微信，则为竖屏
            //TODO 对于某些我们支持的终端，也要是横屏！！！ 这个以后再添加 维护
            // 锐捷桌面机、PAD、等
            String[] deviceModels = {"K9"};
            if (ArrayUtils.contains(deviceModels, Build.MODEL)) {
                screenOrientation = true;
            }
        }
        LogUtils.e(BaseConstant.TAG, "是否横屏 ->->->" + screenOrientation);
        return screenOrientation;
    }
}
