/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.dayouzc.android.util.common.R;
import com.dayouzc.e2e.core.util.LogUtils;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;
import uk.co.chrisjenx.calligraphy.TypefaceUtils;

public class DYUtils {
    private static volatile DYUtils sInstance = null;
    private static Application sContext;
    private static boolean sIsTabletChecked;
    private static int sScreenType;

    private DYUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DYUtils getInstance() {
        if (sInstance != null) return sInstance;
        Class<DYUtils> clazz = DYUtils.class;
        synchronized (DYUtils.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DYUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static void init(Application context) {
        sContext = context;
    }

    public static Context getContext() {
        DYUtils.testInitialize();
        return sContext;
    }

    private static void testInitialize() {
        if (sContext == null) {
            throw new ExceptionInInitializerError("\u8bf7\u5148\u5728\u5168\u5c40Application\u4e2d\u8c03\u7528 DYUtils.init() \u521d\u59cb\u5316\uff01");
        }
    }

    public static void debug(String tag) {
    }

    public static void debug(boolean isDebug, boolean isSaveDebugInfo, boolean isSaveCrashInfo) {
        LogUtils.init(isDebug, isSaveDebugInfo, isSaveCrashInfo);
    }

    @Nullable
    public static Typeface getDefaultTypeface() {
        String fontPath = CalligraphyConfig.get().getFontPath();
        if (!TextUtils.isEmpty((CharSequence)fontPath)) {
            return TypefaceUtils.load((AssetManager)DYUtils.getContext().getAssets(), (String)fontPath);
        }
        return null;
    }

    @Nullable
    public static Typeface getDefaultTypeface(String fontPath) {
        if (TextUtils.isEmpty((CharSequence)fontPath)) {
            fontPath = CalligraphyConfig.get().getFontPath();
        }
        if (!TextUtils.isEmpty((CharSequence)fontPath)) {
            return TypefaceUtils.load((AssetManager)DYUtils.getContext().getAssets(), (String)fontPath);
        }
        return null;
    }

    private static int checkScreenSize(Context context) {
        int screenSize = context.getResources().getConfiguration().screenLayout & 0xF;
        if (screenSize >= 3) {
            if (screenSize >= 4) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public static int getScreenType() {
        if (sIsTabletChecked) {
            return sScreenType;
        }
        sScreenType = DYUtils.checkScreenSize(DYUtils.getContext());
        sIsTabletChecked = true;
        return sScreenType;
    }

    public static boolean isTablet() {
        return DYUtils.getScreenType() == 2 || DYUtils.getScreenType() == 3;
    }

    public static void initTheme(Activity activity) {
        int screenType = DYUtils.getScreenType();
        if (screenType == 1) {
            activity.setTheme(R.style.XUITheme_Phone);
        } else if (screenType == 2) {
            activity.setTheme(R.style.XUITheme_Tablet_Small);
        } else {
            activity.setTheme(R.style.XUITheme_Tablet_Big);
        }
    }
}

