package com.dayouzc.e2e.core.consts;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * UI常量&设备类型常量
 *
 * @author xuexiang
 * @since 2018/11/22 下午5:24
 */
public final class UIConsts {

    /**
     * 屏幕类型
     */
    public final static class ScreenType {
        /**
         * 手机
         */
        public final static int PHONE = 1;
        /**
         * 小平板（7寸左右）
         */
        public final static int SMALL_TABLET = 2;
        /**
         * 大平板（10寸左右）
         */
        public final static int BIG_TABLET = 3;
    }

    /**
     * 设备类型
     */
    public final static class DeviceType {
        /**
         * 有派
         */
        public final static int YP = 1;
        /**
         * ARM
         */
        public final static int ARM = 2;
        /**
         * 其他（手机、pos等）
         */
        public final static int OTHER = 3;

        /**
         * 有派
         */
        public final static String YP_DEVICE = "YP";
        /**
         * ARM
         */
        public final static String ARM_DEVICE = "CS";
        /**
         * 其他（手机、pos等）
         */
        public final static String OTHER_DEVICE = "OTHER";

    }

    /**
     * 设备类型  暂时定义 三种
     */
    public static final class ScreenOrientationType {
        /**
         * 横屏
         */
        public static final String LANDSCAPE = "0";
        /**
         * 竖屏
         */
        public static final String PORTRAIT = "1";

        public static Map<String, String> map = new LinkedHashMap<String, String>() {
            {
                put("0", "横屏");
                put("1", "竖屏");
            }
        };
    }


}
