package com.dayouzc.e2e.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.dayouzc.android.util.common.R;
import com.dayouzc.e2e.core.consts.UIConsts;
import com.dayouzc.e2e.core.util.LogUtils;

import uk.co.chrisjenx.calligraphy.CalligraphyConfig;
import uk.co.chrisjenx.calligraphy.TypefaceUtils;

 /**
  * TODO UI全局设置
  *
  * @author 何鑫
  * @date 2020/3/12 下午 05:23
  */

public class DYUtils {

    private static volatile DYUtils sInstance = null;

    private static Application sContext;

    private static boolean sIsTabletChecked;

    private static int sScreenType;

    private DYUtils() {

    }

    /**
     * 获取单例
     *
     * @return sInstance
     */
    public static DYUtils getInstance() {
        if (sInstance == null) {
            synchronized (DYUtils.class) {
                if (sInstance == null) {
                    sInstance = new DYUtils();
                }
            }
        }
        return sInstance;
    }

    //=======================初始化设置===========================//
    /**
     * 初始化
     *
     * @param context
     */
    public static void init(Application context) {
        sContext = context;
    }

    public static Context getContext() {
        testInitialize();
        return sContext;
    }

    private static void testInitialize() {
        if (sContext == null) {
            throw new ExceptionInInitializerError("请先在全局Application中调用 DYUtils.init() 初始化！");
        }
    }

    //=======================日志调试===========================//
    /**
     * 设置调试模式
     *
     * @param tag
     * @return
     */
    public static void debug(String tag) {
//        UILog.debug(tag);
    }

    /**
     * 设置调试模式
     * @param   isDebug  是否输出日志  默认 false
     * @param  isSaveDebugInfo 是否保存调试日志 默认 false
     * @param isSaveCrashInfo 是否保存报错日志 默认 false
     *
     *  isDebug
     * @return
     */
    public static void debug(boolean isDebug,boolean isSaveDebugInfo,boolean isSaveCrashInfo) {
        LogUtils.init(isDebug,isSaveDebugInfo,isSaveCrashInfo);
    }

    //=======================字体===========================//
    /**
     * @return 获取默认字体
     */
    @Nullable
    public static Typeface getDefaultTypeface() {
        String fontPath = CalligraphyConfig.get().getFontPath();
        if (!TextUtils.isEmpty(fontPath)) {
            return TypefaceUtils.load(getContext().getAssets(), fontPath);
        }
        return null;
    }

    /**
     * @param fontPath 字体路径
     * @return 获取默认字体
     */
    @Nullable
    public static Typeface getDefaultTypeface(String fontPath) {
        if (TextUtils.isEmpty(fontPath)) {
            fontPath = CalligraphyConfig.get().getFontPath();
        }
        if (!TextUtils.isEmpty(fontPath)) {
            return TypefaceUtils.load(getContext().getAssets(), fontPath);
        }
        return null;
    }

    //=======================屏幕尺寸===========================//

    /**
     * 检验设备屏幕的尺寸
     * @param context
     * @return
     */
    private static int checkScreenSize(Context context) {
        int screenSize = context.getResources().getConfiguration().screenLayout & Configuration.SCREENLAYOUT_SIZE_MASK;
        if (screenSize >= Configuration.SCREENLAYOUT_SIZE_LARGE) {
            //证明是平板
            if (screenSize >= Configuration.SCREENLAYOUT_SIZE_XLARGE) {
                return UIConsts.ScreenType.BIG_TABLET;
            } else {
                return UIConsts.ScreenType.SMALL_TABLET;
            }
        } else {
            return UIConsts.ScreenType.PHONE;
        }
    }

    /**
     * 判断是否平板设备
     * @return true:平板,false:手机
     */
    public static int getScreenType() {
        if (sIsTabletChecked) {
            return sScreenType;
        }
        sScreenType = checkScreenSize(DYUtils.getContext());
        sIsTabletChecked = true;
        return sScreenType;
    }

    /**
     * 是否是平板
     * @return
     */
    public static boolean isTablet() {
        return getScreenType() == UIConsts.ScreenType.SMALL_TABLET || getScreenType() == UIConsts.ScreenType.BIG_TABLET;
    }

    /**
     * 初始化主题
     * @param activity
     */
    public static void initTheme(Activity activity) {
        int screenType = getScreenType();
        if (screenType == UIConsts.ScreenType.PHONE) {
            activity.setTheme(R.style.XUITheme_Phone);
        } else if (screenType == UIConsts.ScreenType.SMALL_TABLET){
            activity.setTheme(R.style.XUITheme_Tablet_Small);
        } else {
            activity.setTheme(R.style.XUITheme_Tablet_Big);
        }
    }

}
