/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.dayouzc.e2e.core.DYUtils;
import com.dayouzc.e2e.core.constant.common.BaseConstant;
import com.dayouzc.e2e.core.util.LogUtils;
import com.dayouzc.e2e.core.util.app.IntentUtils;
import com.dayouzc.e2e.core.util.app.ProcessUtils;
import com.dayouzc.e2e.core.util.common.ShellUtils;
import com.dayouzc.e2e.core.util.file.CleanUtils;
import com.dayouzc.e2e.core.util.file.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class AppUtils {
    private static final int APP_INSTALL_AUTO = 0;
    private static final int APP_INSTALL_INTERNAL = 1;
    private static final int APP_INSTALL_EXTERNAL = 2;

    private AppUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isInstallApp(String action, String category) {
        Intent intent = new Intent(action);
        intent.addCategory(category);
        PackageManager pm = AppUtils.getPackageManager();
        ResolveInfo info = pm.resolveActivity(intent, 0);
        return info != null;
    }

    public static boolean isInstallApp(String packageName) {
        return !AppUtils.isSpace(packageName) && IntentUtils.getLaunchAppIntent(packageName) != null;
    }

    @RequiresPermission(value="android.permission.REQUEST_INSTALL_PACKAGES")
    public static void installApp(String filePath, String authority) {
        AppUtils.installApp(FileUtils.getFileByPath(filePath), authority);
    }

    @RequiresPermission(value="android.permission.REQUEST_INSTALL_PACKAGES")
    public static void installApp(File file, String authority) {
        if (!FileUtils.isFileExists(file)) {
            return;
        }
        DYUtils.getContext().startActivity(IntentUtils.getInstallAppIntent(file, authority, true));
    }

    @RequiresPermission(value="android.permission.REQUEST_INSTALL_PACKAGES")
    public static void installApp(Activity activity, String filePath, String authority, int requestCode) {
        AppUtils.installApp(activity, FileUtils.getFileByPath(filePath), authority, requestCode);
    }

    @RequiresPermission(value="android.permission.REQUEST_INSTALL_PACKAGES")
    public static void installApp(Activity activity, File file, String authority, int requestCode) {
        if (!FileUtils.isFileExists(file)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getInstallAppIntent(file, authority), requestCode);
    }

    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    public static boolean installAppSilent(String filePath) {
        if (Build.VERSION.SDK_INT < 24) {
            return AppUtils.installAppSilentBelow24(DYUtils.getContext(), filePath);
        }
        return AppUtils.installAppSilentAbove24(DYUtils.getContext().getPackageName(), filePath);
    }

    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    private static boolean installAppSilentBelow24(Context context, String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        if (!FileUtils.isFileExists(file)) {
            return false;
        }
        String pmParams = " -r " + AppUtils.getInstallLocationParams();
        StringBuilder command = new StringBuilder().append("LD_LIBRARY_PATH=/vendor/lib:/system/lib pm install ").append(pmParams).append(" ").append(filePath.replace(" ", "\\ "));
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand(command.toString(), !AppUtils.isSystemApplication(context), true);
        return commandResult.successMsg != null && (commandResult.successMsg.contains("Success") || commandResult.successMsg.contains("success"));
    }

    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    private static boolean installAppSilentAbove24(String packageName, String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        if (!FileUtils.isFileExists(file)) {
            return false;
        }
        boolean isRoot = AppUtils.isDeviceRooted();
        String command = "pm install -i " + packageName + " --user 0 " + filePath;
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand(command, isRoot);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    public static void uninstallApp(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        DYUtils.getContext().startActivity(IntentUtils.getUninstallAppIntent(packageName, true));
    }

    public static void uninstallApp(Activity activity, String packageName, int requestCode) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getUninstallAppIntent(packageName), requestCode);
    }

    public static boolean uninstallAppSilent(String packageName, boolean isKeepData) {
        if (AppUtils.isSpace(packageName)) {
            return false;
        }
        boolean isRoot = AppUtils.isDeviceRooted();
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm uninstall " + (isKeepData ? "-k " : "") + packageName;
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand(command, isRoot, true);
        if (commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success")) {
            return true;
        }
        command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib64 pm uninstall " + (isKeepData ? "-k " : "") + packageName;
        commandResult = ShellUtils.execCommand(command, isRoot, true);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    public static boolean isAppRoot() {
        ShellUtils.CommandResult result = ShellUtils.execCommand("echo root", true);
        if (result.result == 0) {
            return true;
        }
        if (result.errorMsg != null) {
            LogUtils.d(BaseConstant.TAG, "isAppRoot() called" + result.errorMsg);
        }
        return false;
    }

    public static void launchApp(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        DYUtils.getContext().startActivity(IntentUtils.getLaunchAppIntent(packageName, true));
    }

    public static void launchApp(Activity activity, String packageName, int requestCode) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getLaunchAppIntent(packageName), requestCode);
    }

    public static String getAppPackageName() {
        return DYUtils.getContext().getPackageName();
    }

    public static void getAppDetailsSettings() {
        AppUtils.getAppDetailsSettings(DYUtils.getContext().getPackageName());
    }

    public static void getAppDetailsSettings(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        DYUtils.getContext().startActivity(IntentUtils.getAppDetailsSettingsIntent(packageName, true));
    }

    public static String getAppName() {
        return AppUtils.getAppName(DYUtils.getContext().getPackageName());
    }

    public static String getAppName(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = AppUtils.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Drawable getAppIcon() {
        return AppUtils.getAppIcon(DYUtils.getContext().getPackageName());
    }

    public static Drawable getAppIcon(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = AppUtils.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadIcon(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppPath() {
        return AppUtils.getAppPath(DYUtils.getContext().getPackageName());
    }

    public static String getAppPath(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = AppUtils.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.sourceDir;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppVersionName() {
        return AppUtils.getAppVersionName(DYUtils.getContext().getPackageName());
    }

    public static String getAppVersionName(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = AppUtils.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAppVersionCode() {
        return AppUtils.getAppVersionCode(DYUtils.getContext().getPackageName());
    }

    public static int getAppVersionCode(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return -1;
        }
        try {
            PackageManager pm = AppUtils.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? -1 : pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isSystemApp() {
        return AppUtils.isSystemApp(DYUtils.getContext().getPackageName());
    }

    public static boolean isSystemApp(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return false;
        }
        try {
            PackageManager pm = AppUtils.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAppDebug() {
        return AppUtils.isAppDebug(DYUtils.getContext().getPackageName());
    }

    public static boolean isAppDebug(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return false;
        }
        try {
            PackageManager pm = AppUtils.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 2) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Signature[] getAppSignature() {
        return AppUtils.getAppSignature(DYUtils.getContext().getPackageName());
    }

    public static Signature[] getAppSignature(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = AppUtils.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 64);
            return pi == null ? null : pi.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAppForeground() {
        ActivityManager manager = AppUtils.getActivityManager();
        List info = manager.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.importance != 100) continue;
            return aInfo.processName.equals(DYUtils.getContext().getPackageName());
        }
        return false;
    }

    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public static boolean isAppForeground(String packageName) {
        return !AppUtils.isSpace(packageName) && packageName.equals(ProcessUtils.getForegroundProcessName());
    }

    public static boolean isTopActivity(String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        ComponentName topActivity = AppUtils.getTopActivityComponent();
        return topActivity != null && packageName.equals(topActivity.getPackageName());
    }

    public static ComponentName getTopActivityComponent() {
        ComponentName topActivity = null;
        ActivityManager activityManager = AppUtils.getActivityManager();
        List runningTaskInfos = activityManager.getRunningTasks(1);
        if (runningTaskInfos != null) {
            topActivity = ((ActivityManager.RunningTaskInfo)runningTaskInfos.get((int)0)).topActivity;
        }
        return topActivity;
    }

    public static ActivityManager getActivityManager() {
        return (ActivityManager)DYUtils.getContext().getSystemService("activity");
    }

    public static AppInfo getAppInfo() {
        return AppUtils.getAppInfo(DYUtils.getContext().getPackageName());
    }

    public static AppInfo getAppInfo(String packageName) {
        try {
            PackageManager pm = AppUtils.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return AppUtils.getBean(pm, pi);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static AppInfo getBean(PackageManager pm, PackageInfo pi) {
        if (pm == null || pi == null) {
            return null;
        }
        ApplicationInfo ai = pi.applicationInfo;
        String packageName = pi.packageName;
        String name = ai.loadLabel(pm).toString();
        Drawable icon = ai.loadIcon(pm);
        String packagePath = ai.sourceDir;
        String versionName = pi.versionName;
        int versionCode = pi.versionCode;
        boolean isSystem = (1 & ai.flags) != 0;
        return new AppInfo(packageName, name, icon, packagePath, versionName, versionCode, isSystem);
    }

    public static List<AppInfo> getAppsInfo() {
        ArrayList<AppInfo> list = new ArrayList<AppInfo>();
        PackageManager pm = AppUtils.getPackageManager();
        List installedPackages = pm.getInstalledPackages(0);
        for (PackageInfo pi : installedPackages) {
            AppInfo ai = AppUtils.getBean(pm, pi);
            if (ai == null) continue;
            list.add(ai);
        }
        return list;
    }

    public static PackageManager getPackageManager() {
        return DYUtils.getContext().getPackageManager();
    }

    public static String getPackageName() {
        return DYUtils.getContext().getPackageName();
    }

    @Nullable
    public static Bundle getMetaDatas() {
        try {
            PackageManager pm = AppUtils.getPackageManager();
            return pm.getApplicationInfo((String)AppUtils.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            LogUtils.e("dyshell", e);
            return null;
        }
    }

    @Nullable
    public static String getStringValueInMetaData(String key) {
        Bundle metaData = AppUtils.getMetaDatas();
        return metaData != null ? metaData.getString(key) : null;
    }

    @Nullable
    public static int getIntValueInMetaData(String key) {
        Bundle metaData = AppUtils.getMetaDatas();
        return metaData != null ? metaData.getInt(key) : 0;
    }

    @Nullable
    public static float getFloatValueInMetaData(String key) {
        Bundle metaData = AppUtils.getMetaDatas();
        return metaData != null ? metaData.getFloat(key) : 0.0f;
    }

    @Nullable
    public static double getDoubleValueInMetaData(String key) {
        Bundle metaData = AppUtils.getMetaDatas();
        return metaData != null ? metaData.getDouble(key) : 0.0;
    }

    public static boolean cleanAppData(String ... dirPaths) {
        File[] dirs = new File[dirPaths.length];
        int i = 0;
        for (String dirPath : dirPaths) {
            dirs[i++] = new File(dirPath);
        }
        return AppUtils.cleanAppData(dirs);
    }

    public static boolean cleanAppData(File ... dirs) {
        boolean isSuccess = CleanUtils.cleanInternalCache();
        isSuccess &= CleanUtils.cleanInternalDbs();
        isSuccess &= CleanUtils.cleanInternalSp();
        isSuccess &= CleanUtils.cleanInternalFiles();
        isSuccess &= CleanUtils.cleanExternalCache();
        for (File dir : dirs) {
            isSuccess &= CleanUtils.cleanCustomCache(dir);
        }
        return isSuccess;
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    private static String getInstallLocationParams() {
        int location = AppUtils.getInstallLocation();
        switch (location) {
            case 1: {
                return "-f";
            }
            case 2: {
                return "-s";
            }
        }
        return "";
    }

    private static int getInstallLocation() {
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand("LD_LIBRARY_PATH=/vendor/lib:/system/lib pm get-install-location", false, true);
        if (commandResult.result == 0 && commandResult.successMsg != null && commandResult.successMsg.length() > 0) {
            try {
                int location = Integer.parseInt(commandResult.successMsg.substring(0, 1));
                switch (location) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                LogUtils.e(BaseConstant.TAG, "pm get-install-location error");
            }
        }
        return 0;
    }

    private static boolean isSystemApplication(Context context) {
        return context != null && AppUtils.isSystemApplication(context, context.getPackageName());
    }

    private static boolean isSystemApplication(Context context, String packageName) {
        return context != null && AppUtils.isSystemApplication(context.getPackageManager(), packageName);
    }

    private static boolean isSystemApplication(PackageManager packageManager, String packageName) {
        if (packageManager == null || packageName == null || packageName.length() == 0) {
            return false;
        }
        try {
            ApplicationInfo app = packageManager.getApplicationInfo(packageName, 0);
            return app != null && (app.flags & 1) > 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class AppInfo {
        private String name;
        private Drawable icon;
        private String packageName;
        private String packagePath;
        private String versionName;
        private int versionCode;
        private boolean isSystem;

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public boolean isSystem() {
            return this.isSystem;
        }

        public void setSystem(boolean isSystem) {
            this.isSystem = isSystem;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public void setPackagePath(String packagePath) {
            this.packagePath = packagePath;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public void setVersionCode(int versionCode) {
            this.versionCode = versionCode;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public AppInfo(String packageName, String name, Drawable icon, String packagePath, String versionName, int versionCode, boolean isSystem) {
            this.setName(name);
            this.setIcon(icon);
            this.setPackageName(packageName);
            this.setPackagePath(packagePath);
            this.setVersionName(versionName);
            this.setVersionCode(versionCode);
            this.setSystem(isSystem);
        }

        public String toString() {
            return "pkg name: " + this.getPackageName() + "\napp name: " + this.getName() + "\napp path: " + this.getPackagePath() + "\napp v name: " + this.getVersionName() + "\napp v code: " + this.getVersionCode() + "\nis system: " + this.isSystem();
        }
    }
}

