/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.os.Build;
import com.dayouzc.e2e.core.constant.common.BaseConstant;
import com.dayouzc.e2e.core.consts.UIConsts;
import com.dayouzc.e2e.core.util.LogUtils;
import com.dayouzc.e2e.core.util.LoginUtils;
import com.dayouzc.e2e.core.util.display.ScreenUtils;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DevicesUtils {
    public static String getDeviceType() {
        String type = DevicesUtils.getYPSN();
        if (type.startsWith("YP")) {
            return "YP";
        }
        if (type.startsWith("CS")) {
            return "CS";
        }
        return "OTHER";
    }

    public static String getYPSN() {
        String youpieSn = LoginUtils.getyoupieSn();
        if (StringUtils.isEmpty((CharSequence)youpieSn)) {
            LoginUtils.setYouPieSn(DevicesUtils.getSerial());
            return DevicesUtils.getSerial();
        }
        return youpieSn;
    }

    @SuppressLint(value={"MissingPermission"})
    private static String getSerial() {
        if (Build.VERSION.SDK_INT >= 26) {
            return Build.getSerial();
        }
        if (Build.VERSION.SDK_INT == 29) {
            return "null";
        }
        return Build.SERIAL;
    }

    public static String getDeviceMode() {
        String type = DevicesUtils.getYPNum();
        if (type.startsWith("YP")) {
            return "YP";
        }
        if (type.startsWith("CS")) {
            return "CS";
        }
        return "OTHER";
    }

    public static boolean isYouPie() {
        String type = DevicesUtils.getDeviceType();
        return type.equals("YP");
    }

    public static boolean isARM() {
        String type = DevicesUtils.getDeviceType();
        return type.equals("CS");
    }

    public static boolean isOtherDevices() {
        String type = DevicesUtils.getDeviceType();
        if (type.equals("YP")) {
            return false;
        }
        return !type.equals("CS");
    }

    public static String getYPNum() {
        return DevicesUtils.getSerial();
    }

    public static String getScreenOrientation(ConnectionInfoDTO tokenInfo) {
        String screenOrientation = "0";
        if (tokenInfo == null) {
            return screenOrientation;
        }
        if (StringUtils.equals((CharSequence)tokenInfo.getObjType(), (CharSequence)"3")) {
            screenOrientation = "1";
            if (ScreenUtils.isLandscape()) {
                screenOrientation = "0";
            }
            Object[] deviceModels = new String[]{"K9"};
            if (tokenInfo.getPeripher() != null && StringUtils.isNotBlank((CharSequence)tokenInfo.getPeripher().getDeviceModel()) && ArrayUtils.contains((Object[])deviceModels, (Object)tokenInfo.getPeripher().getDeviceModel())) {
                screenOrientation = "0";
            }
        }
        LogUtils.e(BaseConstant.TAG, "\u5f53\u524d\u8bbe\u5907 \u5c4f\u5e55\u65b9\u5411\u4e3a->->->" + UIConsts.ScreenOrientationType.map.get(screenOrientation));
        return screenOrientation;
    }

    public static boolean isLandscape() {
        boolean screenOrientation = true;
        if (DevicesUtils.isOtherDevices()) {
            Object[] deviceModels;
            screenOrientation = false;
            if (ScreenUtils.isLandscape()) {
                screenOrientation = true;
            }
            if (ArrayUtils.contains((Object[])(deviceModels = new String[]{"K9"}), (Object)Build.MODEL)) {
                screenOrientation = true;
            }
        }
        LogUtils.e(BaseConstant.TAG, "\u662f\u5426\u6a2a\u5c4f ->->->" + screenOrientation);
        return screenOrientation;
    }
}

