/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.file;

import com.dayouzc.e2e.core.util.file.CloseUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private static final int BUFFER_LEN = 8192;

    private ZipUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean zipFiles(Collection<String> resFiles, String zipFilePath) throws IOException {
        return ZipUtils.zipFiles(resFiles, zipFilePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zipFiles(Collection<String> resFilePaths, String zipFilePath, String comment) throws IOException {
        block8: {
            block6: {
                block7: {
                    if (resFilePaths == null || zipFilePath == null) {
                        return false;
                    }
                    zos = null;
                    try {
                        zos = new ZipOutputStream(new FileOutputStream(zipFilePath));
                        for (String resFile : resFilePaths) {
                            if (ZipUtils.zipFile(ZipUtils.getFileByPath(resFile), "", zos, comment)) continue;
                            var6_7 = false;
                            if (zos == null) break block6;
                            break block7;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var7_8) {
                        if (zos != null) {
                            zos.finish();
                            CloseUtils.closeIO(new Closeable[]{zos});
                        }
                        throw var7_8;
                    }
                }
                zos.finish();
                CloseUtils.closeIO(new Closeable[]{zos});
            }
            return var6_7;
lbl-1000:
            // 1 sources

            {
                var4_5 = true;
                if (zos == null) break block8;
            }
            zos.finish();
            CloseUtils.closeIO(new Closeable[]{zos});
        }
        return var4_5;
    }

    public static boolean zipFiles(Collection<File> resFiles, File zipFile) throws IOException {
        return ZipUtils.zipFiles(resFiles, zipFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zipFiles(Collection<File> resFiles, File zipFile, String comment) throws IOException {
        block8: {
            block6: {
                block7: {
                    if (resFiles == null || zipFile == null) {
                        return false;
                    }
                    zos = null;
                    try {
                        zos = new ZipOutputStream(new FileOutputStream(zipFile));
                        for (File resFile : resFiles) {
                            if (ZipUtils.zipFile(resFile, "", zos, comment)) continue;
                            var6_7 = false;
                            if (zos == null) break block6;
                            break block7;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var7_8) {
                        if (zos != null) {
                            zos.finish();
                            CloseUtils.closeIO(new Closeable[]{zos});
                        }
                        throw var7_8;
                    }
                }
                zos.finish();
                CloseUtils.closeIO(new Closeable[]{zos});
            }
            return var6_7;
lbl-1000:
            // 1 sources

            {
                var4_5 = true;
                if (zos == null) break block8;
            }
            zos.finish();
            CloseUtils.closeIO(new Closeable[]{zos});
        }
        return var4_5;
    }

    public static boolean zipFile(String resFilePath, String zipFilePath) throws IOException {
        return ZipUtils.zipFile(ZipUtils.getFileByPath(resFilePath), ZipUtils.getFileByPath(zipFilePath), null);
    }

    public static boolean zipFile(String resFilePath, String zipFilePath, String comment) throws IOException {
        return ZipUtils.zipFile(ZipUtils.getFileByPath(resFilePath), ZipUtils.getFileByPath(zipFilePath), comment);
    }

    public static boolean zipFile(File resFile, File zipFile) throws IOException {
        return ZipUtils.zipFile(resFile, zipFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFile(File resFile, File zipFile, String comment) throws IOException {
        boolean bl;
        block4: {
            if (resFile == null || zipFile == null) {
                return false;
            }
            ZipOutputStream zos = null;
            try {
                zos = new ZipOutputStream(new FileOutputStream(zipFile));
                bl = ZipUtils.zipFile(resFile, "", zos, comment);
                if (zos == null) break block4;
            }
            catch (Throwable throwable) {
                if (zos != null) {
                    CloseUtils.closeIO(zos);
                }
                throw throwable;
            }
            CloseUtils.closeIO(zos);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean zipFile(File resFile, String rootPath, ZipOutputStream zos, String comment) throws IOException {
        rootPath = rootPath + (ZipUtils.isSpace(rootPath) ? "" : File.separator) + resFile.getName();
        if (resFile.isDirectory()) {
            File[] fileList = resFile.listFiles();
            if (fileList == null || fileList.length <= 0) {
                ZipEntry entry = new ZipEntry(rootPath + '/');
                entry.setComment(comment);
                zos.putNextEntry(entry);
                zos.closeEntry();
                return true;
            }
            File[] entry = fileList;
            int n = entry.length;
            int n2 = 0;
            while (n2 < n) {
                File file = entry[n2];
                if (!ZipUtils.zipFile(file, rootPath, zos, comment)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        BufferedInputStream is = null;
        try {
            int len;
            is = new BufferedInputStream(new FileInputStream(resFile));
            ZipEntry entry = new ZipEntry(rootPath);
            entry.setComment(comment);
            zos.putNextEntry(entry);
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)is).read(buffer, 0, 8192)) != -1) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            CloseUtils.closeIO(is);
            throw throwable;
        }
        CloseUtils.closeIO(is);
        return true;
    }

    public static List<File> unzipFile(String zipFilePath, String destDirPath) throws IOException {
        return ZipUtils.unzipFileByKeyword(zipFilePath, destDirPath, null);
    }

    public static List<File> unzipFile(File zipFile, File destDir) throws IOException {
        return ZipUtils.unzipFileByKeyword(zipFile, destDir, null);
    }

    public static List<File> unzipFileByKeyword(String zipFilePath, String destDirPath, String keyword) throws IOException {
        return ZipUtils.unzipFileByKeyword(ZipUtils.getFileByPath(zipFilePath), ZipUtils.getFileByPath(destDirPath), keyword);
    }

    public static List<File> unzipFileByKeyword(File zipFile, File destDir, String keyword) throws IOException {
        if (zipFile == null || destDir == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        if (ZipUtils.isSpace(keyword)) {
            while (entries.hasMoreElements()) {
                String entryName;
                ZipEntry entry = entries.nextElement();
                if (ZipUtils.unzipChildFile(destDir, files, zf, entry, entryName = entry.getName())) continue;
                return files;
            }
        } else {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.contains(keyword) || ZipUtils.unzipChildFile(destDir, files, zf, entry, entryName)) continue;
                return files;
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean unzipChildFile(File destDir, List<File> files, ZipFile zf, ZipEntry entry, String entryName) throws IOException {
        String filePath = destDir + File.separator + entryName;
        File file = new File(filePath);
        files.add(file);
        if (entry.isDirectory()) {
            if (ZipUtils.createOrExistsDir(file)) return true;
            return false;
        }
        if (!ZipUtils.createOrExistsFile(file)) {
            return false;
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int len;
            in = new BufferedInputStream(zf.getInputStream(entry));
            out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)in).read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            CloseUtils.closeIO(in, out);
            throw throwable;
        }
        CloseUtils.closeIO(in, out);
        return true;
    }

    public static List<String> getFilesPath(String zipFilePath) throws IOException {
        return ZipUtils.getFilesPath(ZipUtils.getFileByPath(zipFilePath));
    }

    public static List<String> getFilesPath(File zipFile) throws IOException {
        if (zipFile == null) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = new ZipFile(zipFile).entries();
        while (entries.hasMoreElements()) {
            paths.add(entries.nextElement().getName());
        }
        return paths;
    }

    public static List<String> getComments(String zipFilePath) throws IOException {
        return ZipUtils.getComments(ZipUtils.getFileByPath(zipFilePath));
    }

    public static List<String> getComments(File zipFile) throws IOException {
        if (zipFile == null) {
            return null;
        }
        ArrayList<String> comments = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = new ZipFile(zipFile).entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            comments.add(entry.getComment());
        }
        return comments;
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!ZipUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static File getFileByPath(String filePath) {
        return ZipUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

