/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.file;

import android.os.Environment;
import com.dayouzc.e2e.core.DYUtils;
import com.dayouzc.e2e.core.util.StringUtils;
import java.io.File;

public final class CleanUtils {
    private CleanUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean cleanInternalCache() {
        return CleanUtils.deleteFilesInDir(DYUtils.getContext().getCacheDir());
    }

    public static boolean cleanInternalFiles() {
        return CleanUtils.deleteFilesInDir(DYUtils.getContext().getFilesDir());
    }

    public static boolean cleanInternalDbs() {
        return CleanUtils.deleteFilesInDir(new File(DYUtils.getContext().getFilesDir().getParent(), "databases"));
    }

    public static boolean cleanInternalDbByName(String dbName) {
        return DYUtils.getContext().deleteDatabase(dbName);
    }

    public static boolean cleanInternalSp() {
        return CleanUtils.deleteFilesInDir(new File(DYUtils.getContext().getFilesDir().getParent(), "shared_prefs"));
    }

    public static boolean cleanExternalCache() {
        return "mounted".equals(Environment.getExternalStorageState()) && CleanUtils.deleteFilesInDir(DYUtils.getContext().getExternalCacheDir());
    }

    public static boolean cleanCustomCache(String dirPath) {
        return CleanUtils.deleteFilesInDir(dirPath);
    }

    public static boolean cleanCustomCache(File dir) {
        return CleanUtils.deleteFilesInDir(dir);
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return CleanUtils.deleteFilesInDir(CleanUtils.getFileByPath(dirPath));
    }

    private static boolean deleteFilesInDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !CleanUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !CleanUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static File getFileByPath(String filePath) {
        return StringUtils.isSpace(filePath) ? null : new File(filePath);
    }
}

