/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.os.Environment;
import com.dayouzc.e2e.core.bean.DeviceData;
import com.dayouzc.e2e.core.bean.PublicData;
import com.dayouzc.e2e.core.util.LogUtils;
import com.dayouzc.e2e.core.util.data.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;

public class LoginUtils {
    static String filePath = "/mnt/sdcard/dycsctek/token/publicdata.txt";
    static String filePath2 = "/mnt/sdcard/dycsctek/token/youpie.txt";
    @SuppressLint(value={"SdCardPath"})
    private static String FALE_PATH = "/mnt/sdcard/dycsctek/token/publicdata.txt";
    @SuppressLint(value={"SdCardPath"})
    private static String YOUPIE_PATH = "/mnt/sdcard/dycsctek/token/youpie.txt";
    @SuppressLint(value={"SdCardPath"})
    private static String SAVE_PATH = "/mnt/sdcard/dycsctek/token/";

    public static boolean setUserInfo(PublicData publicData) {
        boolean isTrue = false;
        PublicData organInfo = LoginUtils.getOrganData();
        if (StringUtils.isNotEmpty((CharSequence)organInfo.getOrganId())) {
            publicData.setOrganId(organInfo.getOrganId());
            publicData.setOrganName(organInfo.getOrganName());
        }
        if (publicData != null) {
            String data = JsonUtils.toJSON(publicData);
            try {
                String fileName = "publicdata.txt";
                if (Environment.getExternalStorageState().equals("mounted")) {
                    File dir = new File(SAVE_PATH);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(SAVE_PATH + fileName);
                    fos.write(data.toString().getBytes("utf-8"));
                    fos.flush();
                    fos.close();
                    isTrue = true;
                    File file = new File(FALE_PATH);
                    FileInputStream fis = new FileInputStream(file);
                    InputStreamReader reader = new InputStreamReader(fis);
                    int line = -1;
                    line = ((Reader)reader).read();
                    if (line == -1) {
                        isTrue = false;
                    }
                    return isTrue;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return isTrue;
    }

    public static boolean setOrganInfo(String OrganId, String Organname) {
        boolean isTrue = false;
        PublicData publicData = LoginUtils.getData();
        if (StringUtils.isNotEmpty((CharSequence)OrganId) && StringUtils.isNotEmpty((CharSequence)Organname)) {
            publicData.setOrganId(OrganId);
            publicData.setOrganName(Organname);
            String data = JsonUtils.toJSON(publicData);
            try {
                String fileName = "publicdata.txt";
                if (Environment.getExternalStorageState().equals("mounted")) {
                    File dir = new File(SAVE_PATH);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(SAVE_PATH + fileName);
                    fos.write(data.toString().getBytes("utf-8"));
                    fos.flush();
                    fos.close();
                    isTrue = true;
                    File file = new File(FALE_PATH);
                    FileInputStream fis = new FileInputStream(file);
                    InputStreamReader reader = new InputStreamReader(fis);
                    int line = -1;
                    line = ((Reader)reader).read();
                    if (line == -1) {
                        isTrue = false;
                    }
                    return isTrue;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return isTrue;
    }

    public static boolean setYouPieSn(String deviceSn) {
        boolean isTrue = false;
        DeviceData deviceData = new DeviceData();
        if (StringUtils.isEmpty((CharSequence)deviceSn)) {
            return isTrue;
        }
        deviceData.setDevicesSn(deviceSn);
        if (deviceData != null) {
            String data = JsonUtils.toJSON(deviceData);
            try {
                String fileName = "youpie.txt";
                if (Environment.getExternalStorageState().equals("mounted")) {
                    File dir = new File(SAVE_PATH);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(SAVE_PATH + fileName);
                    fos.write(data.toString().getBytes("utf-8"));
                    fos.flush();
                    fos.close();
                    isTrue = true;
                    File file = new File(YOUPIE_PATH);
                    FileInputStream fis = new FileInputStream(file);
                    InputStreamReader reader = new InputStreamReader(fis);
                    int line = -1;
                    line = ((Reader)reader).read();
                    if (line == -1) {
                        isTrue = false;
                    }
                    return isTrue;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return isTrue;
    }

    public static String read(String filePath) {
        String sbStr = null;
        try {
            if (Environment.getExternalStorageState().equals("mounted")) {
                File sdDirFile = new File(filePath);
                FileInputStream fis = new FileInputStream(sdDirFile);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                StringBuilder sb = new StringBuilder("");
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                sbStr = sb.toString();
                return sbStr;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sbStr;
    }

    public static boolean fileIsExists(String filePath) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void deleteFileForPublicData() {
        try {
            File file = new File(filePath);
            if (file.isFile()) {
                file.delete();
            }
            file.exists();
        }
        catch (Exception e) {
            LogUtils.e("E2EContext", "\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u6743\u9650\uff01");
        }
    }

    public static PublicData getData() {
        PublicData response = new PublicData();
        if (!LoginUtils.fileIsExists(FALE_PATH)) {
            return response;
        }
        String userStr = LoginUtils.read(FALE_PATH);
        if (StringUtils.isNotEmpty((CharSequence)userStr)) {
            PublicData user;
            response = user = JsonUtils.fromJSON(userStr, PublicData.class);
        }
        return response;
    }

    public static PublicData getUserData() {
        PublicData response = new PublicData();
        PublicData data = new PublicData();
        if (!LoginUtils.fileIsExists(FALE_PATH)) {
            return response;
        }
        String userStr = LoginUtils.read(FALE_PATH);
        if (StringUtils.isNotEmpty((CharSequence)userStr)) {
            PublicData user = JsonUtils.fromJSON(userStr, PublicData.class);
            data.setAccountId(user.getAccountId());
            data.setAccountName(user.getAccountName());
            data.setUserName(user.getUserName());
            data.setPassword(user.getPassword());
            data.setMobile(user.getMobile());
            data.setEquipType("");
            data.setEquipName("");
            data.setEquipSn("");
        }
        return data;
    }

    public static String getAccountInfo() {
        String response = null;
        PublicData data = new PublicData();
        if (!LoginUtils.fileIsExists(filePath)) {
            return response;
        }
        String userStr = LoginUtils.read(filePath);
        PublicData user = JsonUtils.fromJSON(userStr, PublicData.class);
        data.setAccountId(user.getAccountId());
        data.setAccountName(user.getAccountName());
        data.setUserName(user.getUserName());
        data.setMobile(user.getMobile());
        response = JsonUtils.toJSON(data);
        return response;
    }

    public static String getEquipInfo() {
        String response = null;
        PublicData data = new PublicData();
        if (!LoginUtils.fileIsExists(filePath)) {
            return response;
        }
        String userStr = LoginUtils.read(filePath);
        PublicData user = JsonUtils.fromJSON(userStr, PublicData.class);
        data.setEquipType(user.getEquipType());
        data.setEquipName(user.getEquipName());
        data.setEquipSn(user.getEquipSn());
        response = JsonUtils.toJSON(data);
        return response;
    }

    public static PublicData getOrganData() {
        PublicData data = new PublicData();
        if (!LoginUtils.fileIsExists(FALE_PATH)) {
            return data;
        }
        String userStr = LoginUtils.read(FALE_PATH);
        if (StringUtils.isNotEmpty((CharSequence)userStr)) {
            PublicData user = JsonUtils.fromJSON(userStr, PublicData.class);
            data.setOrganId(user.getOrganId());
            data.setOrganName(user.getOrganName());
        }
        return data;
    }

    public static String getyoupieSn() {
        String youpiesn = "";
        DeviceData data = new DeviceData();
        if (!LoginUtils.fileIsExists(YOUPIE_PATH)) {
            return "";
        }
        String userStr = LoginUtils.read(YOUPIE_PATH);
        if (StringUtils.isNotEmpty((CharSequence)userStr)) {
            DeviceData user = JsonUtils.fromJSON(userStr, DeviceData.class);
            youpiesn = user.getDevicesSn();
        }
        return youpiesn;
    }
}

