/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.display;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.dayouzc.e2e.core.DYUtils;
import com.dayouzc.e2e.core.util.LogUtils;
import com.dayouzc.e2e.core.util.resource.ResUtils;

public final class ScreenUtils {
    private ScreenUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getScreenWidth() {
        WindowManager wm = (WindowManager)DYUtils.getContext().getSystemService("window");
        if (wm == null) {
            return ResUtils.getResources().getDisplayMetrics().widthPixels;
        }
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            wm.getDefaultDisplay().getRealSize(point);
        } else {
            wm.getDefaultDisplay().getSize(point);
        }
        return point.x;
    }

    @RequiresApi(api=13)
    public static int getScreenHeight() {
        WindowManager wm = (WindowManager)DYUtils.getContext().getSystemService("window");
        if (wm == null) {
            return ResUtils.getResources().getDisplayMetrics().heightPixels;
        }
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            wm.getDefaultDisplay().getRealSize(point);
        } else {
            wm.getDefaultDisplay().getSize(point);
        }
        return point.y;
    }

    @RequiresApi(api=4)
    public static double getDevicePhysicalSize(Context context) {
        int densityDpi = context.getResources().getDisplayMetrics().densityDpi;
        float xdpi = context.getResources().getDisplayMetrics().xdpi;
        float ydpi = context.getResources().getDisplayMetrics().ydpi;
        int width = context.getResources().getDisplayMetrics().widthPixels;
        int height = context.getResources().getDisplayMetrics().heightPixels;
        double size = Math.sqrt(Math.pow((float)width / xdpi, 2.0) + Math.pow((float)height / ydpi, 2.0));
        LogUtils.d("\u8ba1\u7b97\u51fa\u8bbe\u5907\u7684\u7269\u7406\u5c3a\u5bf8:", "\u8ba1\u7b97\u51fa\u6765\u7684\u7269\u7406\u5c3a\u5bf8:" + size + " , [width:" + width + ", height:" + height + ", xdpi:" + xdpi + ", ydpi:" + ydpi + ", densityDpi:" + densityDpi + "]");
        return size;
    }

    public static double getDensityDpi(Context context, float inch) {
        int width = context.getResources().getDisplayMetrics().widthPixels;
        int height = context.getResources().getDisplayMetrics().heightPixels;
        double densityDpi = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0)) / (double)inch;
        LogUtils.d("\u8bbe\u5907\u7684\u7269\u7406\u5c3a\u5bf8:", "\u8ba1\u7b97\u51fa\u6765\u7684\u5c4f\u5e55\u5bc6\u5ea6:" + densityDpi + " , [width:" + width + ", height:" + height + "]");
        return densityDpi;
    }

    public static float getScreenDensity() {
        return ResUtils.getResources().getDisplayMetrics().density;
    }

    @RequiresApi(api=4)
    public static int getScreenDensityDpi() {
        return ResUtils.getResources().getDisplayMetrics().densityDpi;
    }

    public static void setFullScreen(@NonNull Activity activity) {
        activity.getWindow().addFlags(1536);
    }

    public static void setNonFullScreen(@NonNull Activity activity) {
        activity.getWindow().clearFlags(1536);
    }

    public static void toggleFullScreen(@NonNull Activity activity) {
        int fullScreenFlag = 1024;
        Window window = activity.getWindow();
        if ((window.getAttributes().flags & fullScreenFlag) == fullScreenFlag) {
            window.clearFlags(1536);
        } else {
            window.addFlags(1536);
        }
    }

    public static boolean isFullScreen(@NonNull Activity activity) {
        int fullScreenFlag = 1024;
        return (activity.getWindow().getAttributes().flags & fullScreenFlag) == fullScreenFlag;
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public static void setLandscape(@NonNull Activity activity) {
        activity.setRequestedOrientation(0);
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public static void setPortrait(@NonNull Activity activity) {
        activity.setRequestedOrientation(1);
    }

    public static boolean isLandscape() {
        return ResUtils.getResources().getConfiguration().orientation == 2;
    }

    public static boolean isPortrait() {
        return ResUtils.getResources().getConfiguration().orientation == 1;
    }

    public static int getScreenRotation(@NonNull Activity activity) {
        switch (activity.getWindowManager().getDefaultDisplay().getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static Bitmap screenShot(@NonNull Activity activity) {
        return ScreenUtils.screenShot(activity, false);
    }

    public static Bitmap screenShot(@NonNull Activity activity, boolean isDeleteStatusBar) {
        Bitmap ret;
        View decorView = activity.getWindow().getDecorView();
        decorView.setDrawingCacheEnabled(true);
        decorView.buildDrawingCache();
        Bitmap bmp = decorView.getDrawingCache();
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        if (isDeleteStatusBar) {
            Resources resources = activity.getResources();
            int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
            int statusBarHeight = resources.getDimensionPixelSize(resourceId);
            ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)statusBarHeight, (int)dm.widthPixels, (int)(dm.heightPixels - statusBarHeight));
        } else {
            ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)dm.widthPixels, (int)dm.heightPixels);
        }
        decorView.destroyDrawingCache();
        return ret;
    }

    public static boolean isScreenLock() {
        KeyguardManager km = (KeyguardManager)DYUtils.getContext().getSystemService("keyguard");
        return km != null && km.inKeyguardRestrictedInputMode();
    }

    public static void setSleepDuration(int duration) {
        Settings.System.putInt((ContentResolver)DYUtils.getContext().getContentResolver(), (String)"screen_off_timeout", (int)duration);
    }

    public static int getSleepDuration() {
        try {
            return Settings.System.getInt((ContentResolver)DYUtils.getContext().getContentResolver(), (String)"screen_off_timeout");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isTablet() {
        return (ResUtils.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static void adaptScreen(Activity activity, int designDp) {
        if (ScreenUtils.isPortrait()) {
            ScreenUtils.adaptScreen4VerticalSlide(activity, designDp);
        } else {
            ScreenUtils.adaptScreen4HorizontalSlide(activity, designDp);
        }
    }

    public static void adaptScreen4VerticalSlide(Activity activity, int designWidthInDp) {
        ScreenUtils.adaptScreen(activity, designWidthInDp, true);
    }

    public static void adaptScreen4HorizontalSlide(Activity activity, int designHeightInDp) {
        ScreenUtils.adaptScreen(activity, designHeightInDp, false);
    }

    public static void cancelAdaptScreen(Activity activity) {
        DisplayMetrics appDm = DYUtils.getContext().getResources().getDisplayMetrics();
        DisplayMetrics activityDm = activity.getResources().getDisplayMetrics();
        activityDm.density = appDm.density;
        activityDm.scaledDensity = appDm.scaledDensity;
        activityDm.densityDpi = appDm.densityDpi;
    }

    private static void adaptScreen(Activity activity, float sizeInDp, boolean isVerticalSlide) {
        DisplayMetrics appDm = DYUtils.getContext().getResources().getDisplayMetrics();
        DisplayMetrics activityDm = activity.getResources().getDisplayMetrics();
        activityDm.density = isVerticalSlide ? (float)activityDm.widthPixels / sizeInDp : (float)activityDm.heightPixels / sizeInDp;
        activityDm.scaledDensity = activityDm.density * (appDm.scaledDensity / appDm.density);
        activityDm.densityDpi = (int)(160.0f * activityDm.density);
    }
}

