/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.display;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import com.dayouzc.e2e.core.DYUtils;

public final class DensityUtils {
    private DensityUtils() {
        throw new UnsupportedOperationException("Do not need instantiate!");
    }

    public static DisplayMetrics getDisplayMetrics() {
        return DensityUtils.getDisplayMetrics(DYUtils.getContext());
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        return context.getResources().getDisplayMetrics();
    }

    public static int dip2px(float dpValue) {
        return DensityUtils.dip2px(DYUtils.getContext(), dpValue);
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(float pxValue) {
        return DensityUtils.px2dip(DYUtils.getContext(), pxValue);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(float spValue) {
        return DensityUtils.sp2px(DYUtils.getContext(), spValue);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int px2sp(float pxValue) {
        return DensityUtils.px2sp(DYUtils.getContext(), pxValue);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int getScreenDpi() {
        return DensityUtils.getDisplayMetrics().densityDpi;
    }

    public static int getRealDpi(Context context) {
        DisplayMetrics metric = context.getResources().getDisplayMetrics();
        float xdpi = metric.xdpi;
        float ydpi = metric.ydpi;
        return (int)((xdpi + ydpi) / 2.0f + 0.5f);
    }

    public static int getScreenWidth() {
        return DensityUtils.getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight() {
        return DensityUtils.getDisplayMetrics().heightPixels;
    }

    public static float getScreenDensity() {
        return DensityUtils.getDisplayMetrics().density;
    }

    public static float applyDimension(float value, int unit) {
        return DensityUtils.applyDimension(DYUtils.getContext(), value, unit);
    }

    public static float applyDimension(Context context, float value, int unit) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        switch (unit) {
            case 0: {
                return value;
            }
            case 1: {
                return value * metrics.density;
            }
            case 2: {
                return value * metrics.scaledDensity;
            }
            case 3: {
                return value * metrics.xdpi * 0.013888889f;
            }
            case 4: {
                return value * metrics.xdpi;
            }
            case 5: {
                return value * metrics.xdpi * 0.03937008f;
            }
        }
        return 0.0f;
    }

    public static void forceGetViewSize(final View view, final onGetSizeListener listener) {
        view.post(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.onGetSize(view);
                }
            }
        });
    }

    public static int getMeasuredWidth(View view) {
        return DensityUtils.measureView(view)[0];
    }

    public static int getMeasuredHeight(View view) {
        return DensityUtils.measureView(view)[1];
    }

    public static int[] measureView(View view) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp == null) {
            lp = new ViewGroup.LayoutParams(-1, -2);
        }
        int widthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)lp.width);
        int lpHeight = lp.height;
        int heightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(widthSpec, heightSpec);
        return new int[]{view.getMeasuredWidth(), view.getMeasuredHeight()};
    }

    public static interface onGetSizeListener {
        public void onGetSize(View var1);
    }
}

