/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.FileProvider;
import com.dayouzc.e2e.core.DYUtils;
import com.dayouzc.e2e.core.util.StringUtils;
import com.dayouzc.e2e.core.util.file.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class IntentUtils {
    private IntentUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Intent getInstallAppIntent(String filePath, String authority) {
        return IntentUtils.getInstallAppIntent(FileUtils.getFileByPath(filePath), authority);
    }

    public static Intent getInstallAppIntent(File file, String authority) {
        return IntentUtils.getInstallAppIntent(file, authority, false);
    }

    public static Intent getInstallAppIntent(File file, String authority, boolean isNewTask) {
        Uri data;
        if (file == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        String type = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT < 24) {
            data = Uri.fromFile((File)file);
        } else {
            intent.setFlags(1);
            data = FileProvider.getUriForFile((Context)DYUtils.getContext(), (String)authority, (File)file);
        }
        intent.setDataAndType(data, type);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getUninstallAppIntent(String packageName) {
        return IntentUtils.getUninstallAppIntent(packageName, false);
    }

    public static Intent getUninstallAppIntent(String packageName, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.DELETE");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getLaunchAppIntent(String packageName) {
        return IntentUtils.getLaunchAppIntent(packageName, false);
    }

    public static Intent getLaunchAppIntent(String packageName, boolean isNewTask) {
        Intent intent = DYUtils.getContext().getPackageManager().getLaunchIntentForPackage(packageName);
        if (intent == null) {
            return null;
        }
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getAppDetailsSettingsIntent(String packageName) {
        return IntentUtils.getAppDetailsSettingsIntent(packageName, false);
    }

    public static Intent getAppDetailsSettingsIntent(String packageName, boolean isNewTask) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getShareTextIntent(String content) {
        return IntentUtils.getShareTextIntent(content, false);
    }

    public static Intent getShareTextIntent(String content, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", content);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getShareImageIntent(String content, String imagePath) {
        return IntentUtils.getShareImageIntent(content, imagePath, false);
    }

    public static Intent getShareImageIntent(String content, String imagePath, boolean isNewTask) {
        if (imagePath == null || imagePath.length() == 0) {
            return null;
        }
        return IntentUtils.getShareImageIntent(content, new File(imagePath), isNewTask);
    }

    public static Intent getShareImageIntent(String content, File image) {
        return IntentUtils.getShareImageIntent(content, image, false);
    }

    public static Intent getShareImageIntent(String content, File image, boolean isNewTask) {
        if (image != null && image.isFile()) {
            return null;
        }
        return IntentUtils.getShareImageIntent(content, Uri.fromFile((File)image), isNewTask);
    }

    public static Intent getShareImageIntent(String content, Uri uri) {
        return IntentUtils.getShareImageIntent(content, uri, false);
    }

    public static Intent getShareImageIntent(String content, Uri uri, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
        intent.setType("image/*");
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getComponentIntent(String packageName, String className) {
        return IntentUtils.getComponentIntent(packageName, className, null, false);
    }

    public static Intent getComponentIntent(String packageName, String className, boolean isNewTask) {
        return IntentUtils.getComponentIntent(packageName, className, null, isNewTask);
    }

    public static Intent getComponentIntent(String packageName, String className, Bundle bundle) {
        return IntentUtils.getComponentIntent(packageName, className, bundle, false);
    }

    public static Intent getComponentIntent(String packageName, String className, Bundle bundle, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        ComponentName cn = new ComponentName(packageName, className);
        intent.setComponent(cn);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getShutdownIntent() {
        return IntentUtils.getShutdownIntent(false);
    }

    public static Intent getShutdownIntent(boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getDialIntent(String phoneNumber) {
        return IntentUtils.getDialIntent(phoneNumber, false);
    }

    public static Intent getDialIntent(String phoneNumber, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber)));
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getCallIntent(String phoneNumber) {
        return IntentUtils.getCallIntent(phoneNumber, false);
    }

    public static Intent getCallIntent(String phoneNumber, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber)));
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getSendSmsIntent(String phoneNumber, String content) {
        return IntentUtils.getSendSmsIntent(phoneNumber, content, false);
    }

    public static Intent getSendSmsIntent(String phoneNumber, String content, boolean isNewTask) {
        Uri uri = Uri.parse((String)("smsto:" + phoneNumber));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", content);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getCaptureIntent(Uri outUri) {
        return IntentUtils.getCaptureIntent(outUri, false);
    }

    public static Intent getCaptureIntent(Uri outUri, boolean isNewTask) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)outUri);
        intent.addFlags(1);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    private static Intent getIntent(Intent intent, boolean isNewTask) {
        return isNewTask ? intent.addFlags(0x10000000) : intent;
    }

    public static Bundle getExtras(Intent intent) {
        return intent != null ? intent.getExtras() : null;
    }

    public static Bundle getBundleExtra(Intent intent, String key) {
        return intent != null ? intent.getBundleExtra(key) : null;
    }

    public static String getStringExtra(Intent intent, String key) {
        return intent != null ? intent.getStringExtra(key) : null;
    }

    public static boolean getBooleanExtra(Intent intent, String key, boolean defValue) {
        return intent != null ? intent.getBooleanExtra(key, defValue) : defValue;
    }

    public static int getIntExtra(Intent intent, String key, int defValue) {
        return intent != null ? intent.getIntExtra(key, defValue) : defValue;
    }

    public static float getFloatExtra(Intent intent, String key, float defValue) {
        return intent != null ? intent.getFloatExtra(key, defValue) : defValue;
    }

    public static <T> T getSerializableExtra(Intent intent, String key) {
        return (T)(intent != null ? intent.getSerializableExtra(key) : null);
    }

    public static <T> T getBundleSerializable(Intent intent, String key) {
        Bundle bundle = IntentUtils.getExtras(intent);
        return (T)(bundle != null ? bundle.getSerializable(key) : null);
    }

    @NonNull
    public static Intent getIntent(Context context, Class<?> cls, String action) {
        return IntentUtils.getIntent(context, cls, action, false);
    }

    @NonNull
    public static Intent getIntent(Context context, Class<?> cls, String action, boolean isNewTask) {
        Intent intent = new Intent();
        if (cls != null) {
            intent.setClass(context, cls);
        }
        if (action != null) {
            intent.setAction(action);
        }
        if (isNewTask) {
            intent.addFlags(0x10000000);
        }
        return intent;
    }

    public static Intent putExtra(Intent intent, String key, Object param) {
        if (param instanceof Serializable) {
            intent.putExtra(key, (Serializable)param);
        } else if (param instanceof String) {
            intent.putExtra(key, (String)param);
        } else if (param instanceof String[]) {
            intent.putExtra(key, (String[])param);
        } else if (param instanceof boolean[]) {
            intent.putExtra(key, (boolean[])param);
        } else if (param instanceof short[]) {
            intent.putExtra(key, (short[])param);
        } else if (param instanceof int[]) {
            intent.putExtra(key, (int[])param);
        } else if (param instanceof long[]) {
            intent.putExtra(key, (long[])param);
        } else if (param instanceof float[]) {
            intent.putExtra(key, (float[])param);
        } else if (param instanceof double[]) {
            intent.putExtra(key, (double[])param);
        } else if (param instanceof Bundle) {
            intent.putExtra(key, (Bundle)param);
        } else if (param instanceof byte[]) {
            intent.putExtra(key, (byte[])param);
        } else if (param instanceof char[]) {
            intent.putExtra(key, (char[])param);
        } else if (param instanceof Parcelable) {
            intent.putExtra(key, (Parcelable)param);
        } else if (param instanceof Parcelable[]) {
            intent.putExtra(key, (Parcelable[])param);
        } else if (param instanceof CharSequence) {
            intent.putExtra(key, (CharSequence)param);
        } else if (param instanceof CharSequence[]) {
            intent.putExtra(key, (CharSequence[])param);
        }
        return intent;
    }

    public static Bundle putBundle(Bundle bundle, String key, Object param) {
        if (param instanceof Serializable) {
            bundle.putSerializable(key, (Serializable)param);
        } else if (param instanceof String) {
            bundle.putString(key, (String)param);
        } else if (param instanceof String[]) {
            bundle.putStringArray(key, (String[])param);
        } else if (param instanceof boolean[]) {
            bundle.putBooleanArray(key, (boolean[])param);
        } else if (param instanceof short[]) {
            bundle.putShortArray(key, (short[])param);
        } else if (param instanceof int[]) {
            bundle.putIntArray(key, (int[])param);
        } else if (param instanceof long[]) {
            bundle.putLongArray(key, (long[])param);
        } else if (param instanceof float[]) {
            bundle.putFloatArray(key, (float[])param);
        } else if (param instanceof double[]) {
            bundle.putDoubleArray(key, (double[])param);
        } else if (param instanceof Bundle) {
            bundle.putBundle(key, (Bundle)param);
        } else if (param instanceof byte[]) {
            bundle.putByteArray(key, (byte[])param);
        } else if (param instanceof char[]) {
            bundle.putCharArray(key, (char[])param);
        } else if (param instanceof Parcelable) {
            bundle.putParcelable(key, (Parcelable)param);
        } else if (param instanceof Parcelable[]) {
            bundle.putParcelableArray(key, (Parcelable[])param);
        } else if (param instanceof CharSequence) {
            bundle.putCharSequence(key, (CharSequence)param);
        } else if (param instanceof CharSequence[]) {
            bundle.putCharSequenceArray(key, (CharSequence[])param);
        }
        return bundle;
    }

    public static Intent getPickIntentWithGallery() {
        Intent intent = new Intent("android.intent.action.PICK");
        return intent.setType("image/*");
    }

    public static Intent getPickIntentWithDocuments() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        return intent.setType("image/*");
    }

    public static Intent getDocumentPickerIntent(String documentType) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        if (!StringUtils.isEmpty(documentType)) {
            return intent.setType(documentType);
        }
        return intent.setType("*/*");
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DocumentType {
        public static final String IMAGE = "image/*";
        public static final String AUDIO = "audio/*";
        public static final String VIDEO = "video/*";
        public static final String ANY = "*/*";
    }
}

