package com.dayouzc.e2e.core.util.file;


import org.apache.commons.lang3.StringUtils;

import java.text.DecimalFormat;

/**
 * 文件大小转换工具类
 *
 * @author: hexin
 * @date 2017-04-28 20:35
 */
public class FileSizeConvertUtils {

    /**
     * 返回byte的数据大小对应的文本
     *
     * @param sizes
     * @return
     */
    public static String getDataSize(String sizes) {
        if (StringUtils.isEmpty(sizes)) {
            return "null";
        }
        long size = Long.parseLong(sizes);
        if (size < 0) {
            size = 0;
        }
        DecimalFormat formater = new DecimalFormat("####.00");
        if (size < 1024) {
            return size + "bytes";
        } else if (size < 1024 * 1024) {
            float kbsize = size / 1024f;
            return formater.format(kbsize) + "KB";
        } else if (size < 1024 * 1024 * 1024) {
            float mbsize = size / 1024f / 1024f;
            return formater.format(mbsize) + "MB";
        } else if (size < 1024 * 1024 * 1024 * 1024) {
            float gbsize = size / 1024f / 1024f / 1024f;
            return formater.format(gbsize) + "GB";
        } else {
            return "size: error";
        }

    }

    /**
     * 返回byte的数据大小对应的文本
     *
     * @param sizes
     * @return
     */
    public static String getDataSizeForUpdate(String sizes) {
        if (StringUtils.isEmpty(sizes)) {
            return "null";
        }
        long size = Long.parseLong(sizes);
        if (size < 0) {
            size = 0;
        }
        DecimalFormat formater = new DecimalFormat("####.00");
        if (size < 1024) {
            return size + "";
        } else if (size < 1024 * 1024) {
            float kbsize = size / 1024f;
            return formater.format(kbsize) + "";
        } else if (size < 1024 * 1024 * 1024) {
            float mbsize = size / 1024f / 1024f;
            return formater.format(mbsize) + "";
        } else {
            return "size: error";
        }

    }


    /**
     * 返回kb的数据大小对应的文本
     *//*
    public static String getKBDataSize(long size) {
        if (size < 0) {
            size = 0;
        }

        return getDataSize(size * 1024);

    }*/
}
