package com.dayouzc.e2e.core.util;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;

/**
 * 保存本地信息
 * @author Hexin
 */
public class AppPreferences {

    private static SharedPreferences _preferences;
    private static SharedPreferences.Editor _editor;
    private static final String NAME = "settings";

    private static final String TOKEN = "TOKEN";
    private static final String ISERVERSN = "ISERVERSN";
    /** //0云平台服务器1云端 2有派 3终端 4第三方系统 */
    private static final String OBJTYPR= "OBJTYPR";
    private static final String OBJID = "OBJID";
    private static final String USERAGENT = "USERAGENT";
    /** 确认领取信息  是否连接云端wifi信息*/
    private static final String ISAFFIRM = "ISAFFIRM";
    private static final String ISBINDING = "ISBINDING";
    private static final String ISSERVER = "ISSERVER";
    private static final String ISSERVER_NAME = "ISSERVER_NAME";
    /** 连接链路信息 */
    private static final String CONNLINK = "CONNLINK";
    private static final String LINKADDRESS = "LINKADDRESS";
    private static final String LINKADDRESS2 = "LINKADDRESS2";
    /** 连接的人和事信息 */
    private static final String ACCOUNT_ID = "ACCOUNT_ID";
    private static final String ACCOUNT_NAME = "ACCOUNT_NAME";
    private static final String USER_NAME = "USER_NAME";
    private static final String ORGANID = "ORGANID";
    private static final String ORGANNAME = "ORGANNAME";
    private static final String APPID = "APPID";
    private static final String APPNAME = "APPNAME";
    private static final String APPVER = "APPVER";
    private static final String PHONE = "PHONE";

    /** 连接的云端信息 */
    private static final String EQUIPMENTSN = "EQUIPMENTSN";
    private static final String EQUIPMENTTYPE = "EQUIPMENTTYPE";
    private static final String SHITI_NAME = "SHITI_NAME";
    private static final String SHITI_ID = "SHITI_ID";
    /** 连接的设备权限  管理员 普通用户  访客  无关系=空 */
    private static final String AUTHORITY = "AUTHORITY";

    /** 连接的人和事信息 */
    private static final String LOGIN_PHONENO = "LOGIN_PHONENO";
    /** 账号信息 */
    private static final String PASSWORD = "PASSWORD";
    private static final String ISAUTO = "ISAUTO";
    private static final String ISPASS = "ISPASS";
    /** 选择的组织信息 */
    private static final String ISFAST_ORGAN = "ISFAST_ORGAN";

    /** 默认信息 */
    private static final int DEFAULT_INTEGER = 0;
    private static final String DEFAULT_STRING = "";
    private static final boolean DEFAULT_BOOLEAN = false;

    /** 链路信息 */
    private static final String START = "start";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String ISERVER_SN = "iserver_sn";
    private static final String ISERVER_NAME = "iserver_name";

    /** 其他信息 */
    private static final String MAIN_TITLE = "maintitle";
    private static final String IS_GUIDE = "isGuide";
    private static final String IS_CHECK = "ischeck";
    private static final String IS_CHECK_PASS = "ischeckPass";
    private static final String USER_ACCOUNT = "useraccount";
    private static final String USER_PSW = "userpsw";
    private static final String LOGIN_USER_ID = "loginUserId";
    private static final String LOGIN_PHONE_NO = "loginPhoneNo";
    /** 云端-时 */
    private static final String ISERVER_DATE = "iserver_date";
    private static final String ISERVER_HOUR = "iserver_hour";
    private static final String ISERVER_TIMEZONE = "iserver_timezone";

    private static final String FIRST_HOME = "first_home";

    /** 初始化缓存 */
    public static void init(Application application) {
       if (_preferences == null){
           _preferences = application.getSharedPreferences(NAME, Context.MODE_PRIVATE);
       }
    }

    public static String getToken(Application application) {
        init(application);
        return _preferences.getString(TOKEN, DEFAULT_STRING);
    }

    public static void setToken(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(TOKEN, token);
        _editor.commit();
    }
    public static int getHomeNum(Application application) {
        init(application);
        return _preferences.getInt(FIRST_HOME, DEFAULT_INTEGER);
    }

    public static void setHomeNum(Application application,int num) {
        init(application);
        _editor = _preferences.edit();
        _editor.putInt(FIRST_HOME, num);
        _editor.commit();
    }
    public static String getAuthorityType(Application application) {
        init(application);
        return _preferences.getString(AUTHORITY, DEFAULT_STRING);
    }

    public static void setAuthorityType(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(AUTHORITY, token);
        _editor.commit();
    }


    public static boolean getIsFirstOrgan(Application application) {
        init(application);
        return _preferences.getBoolean(ISFAST_ORGAN, DEFAULT_BOOLEAN);
    }

    public static void setIsFirstOrgan(Application application,boolean sn) {
        init(application);
        _editor = _preferences.edit();
        _editor.putBoolean(ISFAST_ORGAN, sn);
        _editor.commit();
    }


    public static String getServerSn(Application application) {
        init(application);
        return _preferences.getString(ISERVERSN, DEFAULT_STRING);
    }

    public static void setServerSn(Application application,String sn) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ISERVERSN, sn);
        _editor.commit();
    }

    public static String getPassWord(Application application) {
        init(application);
        return _preferences.getString(PASSWORD, DEFAULT_STRING);
    }

    public static void setPassWord(Application application,String sn) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(PASSWORD, sn);
        _editor.commit();
    }
    /** 是否确认领取  true: 是 */
    public static boolean getIsAffirm(Application application) {
        init(application);
        return _preferences.getBoolean(ISAFFIRM, DEFAULT_BOOLEAN);
    }

    public static void setIsAffirm(Application application,boolean sn) {
        init(application);
        _editor = _preferences.edit();
        _editor.putBoolean(ISAFFIRM, sn);
        _editor.commit();
    }
    /** 是否绑定  true: 是 */
    public static boolean getIsBinding(Application application) {
        init(application);
        return _preferences.getBoolean(ISBINDING, DEFAULT_BOOLEAN);
    }

    public static void setIsBinding(Application application,boolean sn) {
        init(application);
        _editor = _preferences.edit();
        _editor.putBoolean(ISBINDING, sn);
        _editor.commit();
    }
    /** 是否连接的为云端wifi  true:是 */
    public static boolean getIsServer(Application application) {
        init(application);
        return _preferences.getBoolean(ISSERVER, DEFAULT_BOOLEAN);
    }

    public static void setIsServer(Application application,boolean sn) {
        init(application);
        _editor = _preferences.edit();
        _editor.putBoolean(ISSERVER, sn);
        _editor.commit();
    }

    public static String getWifiName(Application application) {
        init(application);
        return _preferences.getString(ISSERVER_NAME, DEFAULT_STRING);
    }

    public static void setWifiName(Application application,String name) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ISSERVER_NAME, name);
        _editor.commit();
    }
    public static boolean isAuto(Application application) {
        init(application);
        return _preferences.getBoolean(ISAUTO, DEFAULT_BOOLEAN);
    }

    public static void setIsAuto(Application application,boolean sn) {
        init(application);
        _editor = _preferences.edit();
        _editor.putBoolean(ISAUTO, sn);
        _editor.commit();
    }
    public static boolean isPass(Application application) {
        init(application);
        return _preferences.getBoolean(ISPASS, DEFAULT_BOOLEAN);
    }

    public static void setIsPass(Application application,boolean sn) {
        init(application);
        _editor = _preferences.edit();
        _editor.putBoolean(ISPASS, sn);
        _editor.commit();
    }
    public static String getObjType(Application application) {
        init(application);
        return _preferences.getString(OBJTYPR, DEFAULT_STRING);
    }

    public static void setObjType(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(OBJTYPR, token);
        _editor.commit();
    }
    public static String getObjId(Application application) {
        init(application);
        return _preferences.getString(OBJID, DEFAULT_STRING);
    }

    public static void setObjId(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(OBJID, token);
        _editor.commit();
    }
    public static String getUserAgent(Application application) {
        init(application);
        return _preferences.getString(USERAGENT, DEFAULT_STRING);
    }

    public static void setUserAgent(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(USERAGENT, token);
        _editor.commit();
    }

    public static String getConnLink(Application application) {
        init(application);
        return _preferences.getString(CONNLINK, DEFAULT_STRING);
    }
    public static void setConnLink(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(CONNLINK, token);
        _editor.commit();
    }
    public static String getLinkAddress(Application application) {
        init(application);
        return _preferences.getString(LINKADDRESS, DEFAULT_STRING);
    }

    public static void setLinkAddress(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(LINKADDRESS, token);
        _editor.commit();
    }
    public static String getLinkAddress2(Application application) {
        init(application);
        return _preferences.getString(LINKADDRESS2, DEFAULT_STRING);
    }

    public static void setLinkAddress2(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(LINKADDRESS2, token);
        _editor.commit();
    }

    public static String getAccountId(Application application) {
        init(application);
        return _preferences.getString(ACCOUNT_ID, DEFAULT_STRING);
    }

    public static void setAccountId(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ACCOUNT_ID, token);
        _editor.commit();
    }

    public static String getUserName(Application application) {
        init(application);
        return _preferences.getString(USER_NAME, DEFAULT_STRING);
    }

    public static void setUserName(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(USER_NAME, token);
        _editor.commit();
    }
    public static String getOrganId(Application application) {
        init(application);
        return _preferences.getString(ORGANID, DEFAULT_STRING);
    }

    public static void setOrganId(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ORGANID, token);
        _editor.commit();
    }
    public static String getOrganName(Application application) {
        init(application);
        return _preferences.getString(ORGANNAME, DEFAULT_STRING);
    }

    public static void setOrganName(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ORGANNAME, token);
        _editor.commit();
    }

    public static String getAppId(Application application) {
        init(application);
        return _preferences.getString(APPID, DEFAULT_STRING);
    }

    public static void setAppId(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(APPID, token);
        _editor.commit();
    }
    public static String getAppName(Application application) {
        init(application);
        return _preferences.getString(APPNAME, DEFAULT_STRING);
    }

    public static void setAppName(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(APPNAME, token);
        _editor.commit();
    }
    public static String getAppVer(Application application) {
        init(application);
        return _preferences.getString(APPVER, DEFAULT_STRING);
    }

    public static void setAppVer(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(APPVER, token);
        _editor.commit();
    }

    public static String getPhone(Application application) {
        init(application);
        return _preferences.getString(PHONE, DEFAULT_STRING);
    }

    public static void setPhone(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(PHONE, token);
        _editor.commit();
    }

    public static String getEquipmentsn(Application application) {
        init(application);
        return _preferences.getString(EQUIPMENTSN, DEFAULT_STRING);
    }

    public static void setEquipmentsn(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(EQUIPMENTSN, token);
        _editor.commit();
    }
    public static String getEquipmentType(Application application) {
        init(application);
        return _preferences.getString(EQUIPMENTTYPE, DEFAULT_STRING);
    }

    public static void setEquipmentType(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(EQUIPMENTTYPE, token);
        _editor.commit();
    }
    public static String getCustomerName(Application application) {
        init(application);
        return _preferences.getString(SHITI_NAME, DEFAULT_STRING);
    }

    public static void setCustomerName(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(SHITI_NAME, token);
        _editor.commit();
    }
    public static String getCustomerId(Application application) {
        init(application);
        return _preferences.getString(SHITI_ID, DEFAULT_STRING);
    }

    public static void setCustomerId(Application application,String token) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(SHITI_ID, token);
        _editor.commit();
    }

    public static String getStart(Application application) {
        init(application);
        return _preferences.getString(START, DEFAULT_STRING);
    }

    public static void setStart(Application application,String start) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(START, start);
        _editor.commit();
    }

    public static String getIp(Application application) {
        init(application);
        return _preferences.getString(IP, DEFAULT_STRING);
    }

    public static void setIp(Application application,String ip) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(IP, ip);
        _editor.commit();
    }

    public static String getPort(Application application) {
        init(application);
        return _preferences.getString(PORT, DEFAULT_STRING);
    }

    public static void setPort(Application application,String port) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(IP, port);
        _editor.commit();
    }

    public static String getIserver_Sn(Application application) {
        init(application);
        return _preferences.getString(ISERVER_SN, DEFAULT_STRING);
    }

    public static void setIserver_Sn(Application application,String port) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ISERVER_SN, port);
        _editor.commit();
    }


    public static String getIserver_Name(Application application) {
        init(application);
        return _preferences.getString(ISERVER_NAME, DEFAULT_STRING);
    }

    public static void setIserver_Name(Application application,String port) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ISERVER_NAME, port);
        _editor.commit();
    }


    public static String getMainTitle(Application application) {
        init(application);
        return _preferences.getString(MAIN_TITLE, DEFAULT_STRING);
    }

    public static void setMainTitle(Application application,String mainTitle) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(MAIN_TITLE, mainTitle);
        _editor.commit();
    }

    public static boolean getIsGuide(Application application) {
        init(application);
        return _preferences.getBoolean(IS_GUIDE, DEFAULT_BOOLEAN);
    }

    public static void setIsGuide(Application application,boolean isGuide) {
        init(application);
        _editor = _preferences.edit();
        _editor.putBoolean(IS_GUIDE, isGuide);
        _editor.commit();
    }

    public static boolean getIsCheck(Application application) {
        init(application);
        return _preferences.getBoolean(IS_CHECK, DEFAULT_BOOLEAN);
    }

    public static void setIsCheck(Application application,boolean isCheck) {
        init(application);
        _editor = _preferences.edit();
        _editor.putBoolean(IS_CHECK, isCheck);
        _editor.commit();
    }

    public static boolean getIsCheckPass(Application application) {
        init(application);
        return _preferences.getBoolean(IS_CHECK_PASS, DEFAULT_BOOLEAN);
    }

    public static void setIsCheckPass(Application application,boolean isCheckPass) {
        init(application);
        _editor = _preferences.edit();
        _editor.putBoolean(IS_CHECK_PASS, isCheckPass);
        _editor.commit();
    }

    public static String getAccountName(Application application) {
        init(application);
        return _preferences.getString(ACCOUNT_NAME, DEFAULT_STRING);
    }

    public static void setAccountName(Application application,String accountName) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ACCOUNT_NAME, accountName);
        _editor.commit();
    }

    public static String getUserAccount(Application application) {
        init(application);
        return _preferences.getString(USER_ACCOUNT, DEFAULT_STRING);
    }

    public static void setUserAccount(Application application,String userAccount) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(USER_ACCOUNT, userAccount);
        _editor.commit();
    }

    public static String getUserPsw(Application application) {
        init(application);
        return _preferences.getString(USER_PSW, DEFAULT_STRING);
    }

    public static void setUserPsw(Application application,String userPsw) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(USER_PSW, userPsw);
        _editor.commit();
    }

    public static String getLoginUserId(Application application) {
        init(application);
        return _preferences.getString(LOGIN_USER_ID, DEFAULT_STRING);
    }

    public static void setLoginUserId(Application application,String loginUserId) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(LOGIN_USER_ID, loginUserId);
        _editor.commit();
    }

    public static String getLoginPhoneNo(Application application) {
        init(application);
        return _preferences.getString(LOGIN_PHONE_NO, DEFAULT_STRING);
    }

    public static void setLoginPhoneNo(Application application,String loginPhoneNo) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(LOGIN_PHONE_NO, loginPhoneNo);
        _editor.commit();
    }

    public static String getIserverDate(Application application) {
        init(application);
        return _preferences.getString(ISERVER_DATE, DEFAULT_STRING);
    }

    public static void setIserverDate(Application application,String loginPhoneNo) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ISERVER_DATE, loginPhoneNo);
        _editor.commit();
    }

    public static String getIserverHour(Application application) {
        init(application);
        return _preferences.getString(ISERVER_HOUR, DEFAULT_STRING);
    }

    public static void setIserverHour(Application application,String loginPhoneNo) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ISERVER_HOUR, loginPhoneNo);
        _editor.commit();
    }

    public static String getIserverTimezone(Application application) {
        init(application);
        return _preferences.getString(ISERVER_TIMEZONE, DEFAULT_STRING);
    }

    public static void setIserverTimezone(Application application,String loginPhoneNo) {
        init(application);
        _editor = _preferences.edit();
        _editor.putString(ISERVER_TIMEZONE, loginPhoneNo);
        _editor.commit();
    }

    public static void clearAllInfo(Application application) {
        init(application);
        _editor = _preferences.edit();
        _editor.clear().commit();

    }

}
