package com.dayouzc.e2e.core.util.display;

import android.content.Context;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.dayouzc.android.util.common.R;


/**
 *  glide图片加载工具类
 *
 * @author 张金盼
 * @date 2018/5/23
 */
public class GlideUtils {

    /**
     * 默认加载
     * */
    public static void loadImage(Context context, String url, ImageView imageView){
        Glide.with(context)
                .load(url)
                .placeholder(R.drawable.sys_ic_load_img_ing)
                .error(R.drawable.sys_ic_error)
                .diskCacheStrategy(DiskCacheStrategy.RESULT)
                .into(imageView);
    }

    /**
     * 用于E2E图标的加载
     * */
    public static void loadImageForIcon(Context context, String url, ImageView imageView){
        Glide.with(context)
                .load(url)
                .placeholder(R.drawable.sys_ic_load_img_ing)
                .error(R.drawable.sys_ic_defaulticon)
                .diskCacheStrategy(DiskCacheStrategy.RESULT)
                .into(imageView);
    }

    /**
     * 用于头像的加载
     * */
    public static void loadImageForPerson(Context context, String url, ImageView imageView){
        Glide.with(context)
                .load(url)
                .placeholder(R.drawable.sys_ic_load_img_ing)
                .error(R.drawable.sys_ic_default_person)
                .diskCacheStrategy(DiskCacheStrategy.RESULT)
                .into(imageView);
    }
}
