/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.UUID;

public class NewDeviceIdUtil {
    public static String getDeviceId(Context context) {
        StringBuilder sbDeviceId = new StringBuilder();
        String imei = NewDeviceIdUtil.getIMEI(context);
        String androidid = NewDeviceIdUtil.getAndroidId(context);
        String serial = NewDeviceIdUtil.getSERIAL();
        String uuid = NewDeviceIdUtil.getDeviceUUID().replace("-", "");
        if (imei != null && imei.length() > 0) {
            sbDeviceId.append(imei);
            sbDeviceId.append("|");
        }
        if (androidid != null && androidid.length() > 0) {
            sbDeviceId.append(androidid);
            sbDeviceId.append("|");
        }
        if (serial != null && serial.length() > 0) {
            sbDeviceId.append(serial);
            sbDeviceId.append("|");
        }
        if (uuid != null && uuid.length() > 0) {
            sbDeviceId.append(uuid);
        }
        if (sbDeviceId.length() > 0) {
            try {
                byte[] hash = NewDeviceIdUtil.getHashByString(sbDeviceId.toString());
                String sha1 = NewDeviceIdUtil.bytesToHex(hash);
                if (sha1 != null && sha1.length() > 0) {
                    return sha1;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return UUID.randomUUID().toString().replace("-", "");
    }

    @SuppressLint(value={"MissingPermission"})
    private static String getIMEI(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            return tm.getDeviceId();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private static String getAndroidId(Context context) {
        try {
            return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private static String getSERIAL() {
        try {
            return Build.SERIAL;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private static String getDeviceUUID() {
        try {
            String dev = "3883756" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.DEVICE.length() % 10 + Build.HARDWARE.length() % 10 + Build.ID.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.SERIAL.length() % 10;
            return new UUID(dev.hashCode(), Build.SERIAL.hashCode()).toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private static byte[] getHashByString(String data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.reset();
            messageDigest.update(data.getBytes("UTF-8"));
            return messageDigest.digest();
        }
        catch (Exception e) {
            return "".getBytes();
        }
    }

    private static String bytesToHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < data.length; ++n) {
            String stmp = Integer.toHexString(data[n] & 0xFF);
            if (stmp.length() == 1) {
                sb.append("0");
            }
            sb.append(stmp);
        }
        return sb.toString().toUpperCase(Locale.CHINA);
    }
}

