/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import com.dayouzc.e2e.core.E2EAppClientContext;
import com.dayouzc.e2e.core.util.system.SystemUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;

@SuppressLint(value={"SimpleDateFormat"})
public class LogUtils {
    public static String path = "/mnt/sdcard/crash/";
    public static boolean isDebugModel = false;
    public static boolean isSaveDebugInfo = false;
    public static boolean isSaveCrashInfo = false;

    public static void init(boolean isDebugModel, boolean isSaveDebugInfo, boolean isSaveCrashInfo) {
        LogUtils.isDebugModel = isDebugModel;
        LogUtils.isSaveDebugInfo = isSaveDebugInfo;
        LogUtils.isSaveCrashInfo = isSaveCrashInfo;
    }

    public static void v(String tag, String msg) {
        if (isDebugModel) {
            Log.v((String)tag, (String)("--> " + msg));
        }
    }

    public static void d(String tag, String msg) {
        if (isDebugModel) {
            Log.d((String)tag, (String)("--> " + msg));
        }
    }

    public static void i(String tag, String msg) {
        if (isDebugModel) {
            Log.i((String)tag, (String)("--> " + msg));
        }
    }

    public static void w(String tag, String msg) {
        if (isDebugModel) {
            Log.w((String)tag, (String)("--> " + msg));
        }
    }

    public static void e(final String tag, final String msg) {
        if (isDebugModel) {
            Log.e((String)tag, (String)("--> " + msg));
        }
        if (isSaveDebugInfo) {
            new Thread(){

                @Override
                public void run() {
                    LogUtils.write(LogUtils.time() + tag + " --> " + msg + "\n");
                }
            }.start();
        }
    }

    public static void e(final String tag, final Throwable tr) {
        if (isSaveCrashInfo) {
            new Thread(){

                @Override
                public void run() {
                    LogUtils.write(LogUtils.time() + tag + " [CRASH] --> " + LogUtils.getStackTraceString(tr) + "\n");
                }
            }.start();
        }
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        return sw.toString();
    }

    private static String time() {
        return "[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis())) + "] ";
    }

    private static String date() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
    }

    public static synchronized void write(String content) {
        try {
            FileWriter writer = new FileWriter(LogUtils.getFile(), true);
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getFile() {
        path = "/mnt/sdcard/crash/" + SystemUtils.AppName((Context)E2EAppClientContext.getApplication());
        File filePath = new File(path + File.separator + LogUtils.date() + ".txt");
        return filePath.toString();
    }
}

