package com.dayouzc.e2e.core.util.data;


import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;

/**
 * json解析 相关帮助类
 *
 * @author 何鑫
 * @date 2018/5/24 10:41
 */
public class JsonUtils {

    /**
     * java 对象转换为 json 字符串
     *
     * @param obj
     *            对象
     * @return json
     */
    public static String toJSON(Object obj) {
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue(writer, obj);
        } catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        } catch (JsonMappingException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        String result = writer.toString();
        return (null == result) ? "" : result.replaceAll("null", "\"\"");
    }

    private static ObjectMapper mapper = new ObjectMapper();

    static{
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
//        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    /**
     * 反序列化复杂Collection如List<Bean>, 先使用createCollectionType构造类型,然后调用本函数.
     * @see #createCollectionType(Class, Class...)
     */
    @SuppressWarnings("unchecked")
    public static <T> T fromJson(String jsonString, JavaType javaType) {
        if (StringUtils.isEmpty(jsonString)) {
            return null;
        }

        try {
            return (T) mapper.readValue(jsonString, javaType);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 构造的Collection Type如:
     * ArrayList<Bean>, 则调用constructCollectionType(ArrayList.class,Bean.class)
     * HashMap<String,Bean>, 则调用(HashMap.class,String.class, Bean.class)
     */
    public static JavaType createCollectionType(Class<?> collectionClass, Class<?>... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, elementClasses);
    }

    /**
     * json字符串转换为对象
     *
     * @param <T>
     * @param json
     *            json字符串
     * @param clazz
     *            要转换对象的class
     * @return 对象
     */
    public static <T> T fromJSON(String json, Class<T> clazz) {

        try {
            return mapper.readValue(json, clazz);
        } catch (JsonParseException e) {
            throw new RuntimeException(e);
        } catch (JsonMappingException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * json的字节流转换为对象
     *
     * @param <T>
     * @param json
     *            json的字节流
     * @param clazz
     *            要转换对象的class
     * @return 对象
     */
    public static <T> T fromJSON(InputStream json, Class<T> clazz) {
        try {
            return mapper.readValue(json, clazz);
        } catch (JsonParseException e) {
            throw new RuntimeException(e);
        } catch (JsonMappingException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Object> getJsonList(String jstr, List<Object> li) {
        char[] cstr = jstr.toCharArray();
        boolean bend = false;
        int istart = 0;
        int iend = 0;
        for (int i = 0; i < cstr.length; i++) {
            if ((cstr[i] == '{') && !bend) {
                istart = i;
            }
            if (cstr[i] == '}' && !bend) {
                iend = i;
                bend = true;
            }
        }

        if (istart != 0) {
            String substr = jstr.substring(istart, iend + 1);
            jstr = jstr.substring(0, istart - 1)
                    + jstr.substring(iend + 1, jstr.length());
            substr = substr.replace(",\"children\":", "");
            substr = substr.replace("]", "");
            substr = substr.replace("[", "");
            li.add(substr);
            getJsonList(jstr, li);
        }
        return li;
    }

    /**
     * 封装将json对象转换为java集合对象
     *
     * @param <T>
     * @param clazz
     * @param jsons
     * @return
     *//*
    @SuppressWarnings("unchecked")
    public static <T> List<T> getJavaCollection(T clazz, String jsons) {
        List<T> objs = null;
        JSONArray jsonArray = (JSONArray) JSONSerializer.toJSON(jsons);
        if (jsonArray != null) {
            objs = new ArrayList<T>();
            List list = (List) JSONSerializer.toJava(jsonArray);
            for (Object o : list) {
                JSONObject jsonObject = JSONObject.fromObject(o);
                T obj = (T) JSONObject.toBean(jsonObject, clazz.getClass());
                objs.add(obj);
            }
        }
        return objs;
    }
    *//**
     * 封装PUB对象
     *//*
    public static PubModo setPubModo( String json) {
        PubModo pub= new PubModo();
        JSONObject obj = JSONObject.fromObject(json);
        JSONObject pubobj=obj.getJSONObject("pub");
        if(pubobj.containsKey("userId")){
            pub.setUserId(pubobj.getString("userId"));
        }
        if(pubobj.containsKey("apiVersion")){
            pub.setApiVersion(pubobj.getString("apiVersion"));
        }
        if(pubobj.containsKey("clientHash")){
            pub.setClientHash(pubobj.getString("clientHash"));
        }
        if(pubobj.containsKey("screen")){
            pub.setScreen(pubobj.getString("screen"));
        }
        if(pubobj.containsKey("os")){
            pub.setOs(pubobj.getString("os"));
        }
        if(pubobj.containsKey("model")){
            pub.setModel(pubobj.getString("model"));
        }
        if(pubobj.containsKey("channelCode")){
            pub.setChannelCode(pubobj.getString("channelCode"));
        }
        if(pubobj.containsKey("userId")){
            pub.setUserId(pubobj.getString("userId"));
        }
        if(pubobj.containsKey("imei")){
            pub.setImei(pubobj.getString("imei"));
        }
        if(pubobj.containsKey("imsi")){
            pub.setImsi(pubobj.getString("imsi"));
        }
        if(pubobj.containsKey("clientAgent")){
            pub.setClientAgent(pubobj.getString("clientAgent"));
        }
        if(pubobj.containsKey("appCode")){
            pub.setAppCode(pubobj.getString("appCode"));
        }
        if(pubobj.containsKey("pname")){
            pub.setPname(pubobj.getString("pname"));
        }
        if(pubobj.containsKey("apn")){
            pub.setApn(pubobj.getString("apn"));
        }
        return pub;
    }*/

}