/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.app;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.dayouzc.e2e.core.DYUtils;
import com.dayouzc.e2e.core.util.LogUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ProcessUtils {
    private ProcessUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public static String getForegroundProcessName() {
        ActivityManager manager = (ActivityManager)DYUtils.getContext().getSystemService("activity");
        if (manager == null) {
            return null;
        }
        List pInfo = manager.getRunningAppProcesses();
        if (pInfo != null && pInfo.size() > 0) {
            for (ActivityManager.RunningAppProcessInfo aInfo : pInfo) {
                if (aInfo.importance != 100) continue;
                return aInfo.processName;
            }
        }
        if (Build.VERSION.SDK_INT > 21) {
            PackageManager packageManager = DYUtils.getContext().getPackageManager();
            Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            List list = packageManager.queryIntentActivities(intent, 65536);
            LogUtils.i("ProcessUtils", list.toString());
            if (list.size() <= 0) {
                LogUtils.i("ProcessUtils", "getForegroundProcessName() called: \u65e0\"\u6709\u6743\u67e5\u770b\u4f7f\u7528\u6743\u9650\u7684\u5e94\u7528\"\u9009\u9879");
                return null;
            }
            try {
                ApplicationInfo info = packageManager.getApplicationInfo(DYUtils.getContext().getPackageName(), 0);
                AppOpsManager aom = (AppOpsManager)DYUtils.getContext().getSystemService("appops");
                if (aom != null) {
                    if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                        intent.addFlags(0x10000000);
                        DYUtils.getContext().startActivity(intent);
                    }
                    if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                        LogUtils.i("ProcessUtils", "\u6ca1\u6709\u6253\u5f00\"\u6709\u6743\u67e5\u770b\u4f7f\u7528\u6743\u9650\u7684\u5e94\u7528\"\u9009\u9879");
                        return null;
                    }
                }
                UsageStatsManager usageStatsManager = (UsageStatsManager)DYUtils.getContext().getSystemService("usagestats");
                List usageStatsList = null;
                if (usageStatsManager != null) {
                    long endTime = System.currentTimeMillis();
                    long beginTime = endTime - 604800000L;
                    usageStatsList = usageStatsManager.queryUsageStats(4, beginTime, endTime);
                }
                if (usageStatsList == null || usageStatsList.isEmpty()) {
                    return null;
                }
                UsageStats recentStats = null;
                for (UsageStats usageStats : usageStatsList) {
                    if (recentStats != null && usageStats.getLastTimeUsed() <= recentStats.getLastTimeUsed()) continue;
                    recentStats = usageStats;
                }
                return recentStats == null ? null : recentStats.getPackageName();
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Set<String> getAllBackgroundProcesses() {
        ActivityManager am = (ActivityManager)DYUtils.getContext().getSystemService("activity");
        if (am == null) {
            return Collections.emptySet();
        }
        List info = am.getRunningAppProcesses();
        HashSet<String> set = new HashSet<String>();
        if (info != null) {
            for (ActivityManager.RunningAppProcessInfo aInfo : info) {
                Collections.addAll(set, aInfo.pkgList);
            }
        }
        return set;
    }

    public static boolean isProcessRunning(@NonNull String processName) {
        ActivityManager am = (ActivityManager)DYUtils.getContext().getSystemService("activity");
        if (am == null) {
            return false;
        }
        List info = am.getRunningAppProcesses();
        if (info != null) {
            for (ActivityManager.RunningAppProcessInfo aInfo : info) {
                if (!processName.equals(aInfo.processName)) continue;
                return true;
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.KILL_BACKGROUND_PROCESSES")
    public static Set<String> killAllBackgroundProcesses() {
        ActivityManager am = (ActivityManager)DYUtils.getContext().getSystemService("activity");
        if (am == null) {
            return Collections.emptySet();
        }
        List info = am.getRunningAppProcesses();
        HashSet<String> set = new HashSet<String>();
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            for (String pkg : aInfo.pkgList) {
                am.killBackgroundProcesses(pkg);
                set.add(pkg);
            }
        }
        info = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            for (String pkg : aInfo.pkgList) {
                set.remove(pkg);
            }
        }
        return set;
    }

    @RequiresPermission(value="android.permission.KILL_BACKGROUND_PROCESSES")
    public static boolean killBackgroundProcesses(@NonNull String packageName) {
        ActivityManager am = (ActivityManager)DYUtils.getContext().getSystemService("activity");
        if (am == null) {
            return false;
        }
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (!Arrays.asList(aInfo.pkgList).contains(packageName)) continue;
            LogUtils.i("", "[killBackgroundProcesses]\uff1a" + aInfo.processName);
            am.killBackgroundProcesses(packageName);
        }
        info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (!Arrays.asList(aInfo.pkgList).contains(packageName)) continue;
            return false;
        }
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    public static int gc() {
        List processList;
        long beforeGCDeviceUsableMemory = ProcessUtils.getDeviceUsableMemory();
        int count = 0;
        ActivityManager am = (ActivityManager)DYUtils.getContext().getSystemService("activity");
        List serviceList = am.getRunningServices(100);
        if (serviceList != null) {
            for (ActivityManager.RunningServiceInfo service : serviceList) {
                if (service.pid == Process.myPid()) continue;
                try {
                    Process.killProcess((int)service.pid);
                    ++count;
                }
                catch (Exception e) {
                    e.getStackTrace();
                }
            }
        }
        if ((processList = am.getRunningAppProcesses()) != null) {
            for (ActivityManager.RunningAppProcessInfo process : processList) {
                String[] pkgList;
                if (process.importance <= 200) continue;
                for (String pkgName : pkgList = process.pkgList) {
                    LogUtils.i("shell", "======\u6b63\u5728\u6740\u6b7b\u5305\u540d\uff1a" + pkgName);
                    try {
                        am.killBackgroundProcesses(pkgName);
                        ++count;
                    }
                    catch (Exception e) {
                        e.getStackTrace();
                    }
                }
            }
        }
        LogUtils.i("shell", "\u6e05\u7406\u4e86" + ((long)ProcessUtils.getDeviceUsableMemory() - beforeGCDeviceUsableMemory) + "M\u5185\u5b58");
        return count;
    }

    public static int getDeviceUsableMemory() {
        ActivityManager am = (ActivityManager)DYUtils.getContext().getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return (int)(mi.availMem / 0x100000L);
    }

    public static boolean isMainProcess() {
        return DYUtils.getContext().getPackageName().equals(ProcessUtils.getCurrentProcessName());
    }

    public static String getCurrentProcessName() {
        ActivityManager am = (ActivityManager)DYUtils.getContext().getSystemService("activity");
        if (am == null) {
            return null;
        }
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return null;
        }
        int pid = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.pid != pid || aInfo.processName == null) continue;
            return aInfo.processName;
        }
        return "";
    }
}

