package com.dayouzc.e2e.core.util.display;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;

import com.dayouzc.android.util.common.R;
import com.nostra13.universalimageloader.cache.memory.impl.WeakMemoryCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;

/**
 * ImageLoaderUtils 相关帮助类
 *
 * @author 何鑫
 * @date 2018/5/24 10:43
 */
public class ImageLoaderUtils {

    public static final DisplayImageOptions options = new DisplayImageOptions.Builder()
            .showImageOnLoading(R.drawable.sys_ic_error)  // 设置图片下载期间显示的图片
            .showImageForEmptyUri(R.drawable.sys_ic_error)// 设置图片Uri为空或是错误的时候显示的图片
            .showImageOnFail(R.drawable.sys_ic_error)  // 设置图片加载或解码过程中发生错误显示的图片
            .cacheInMemory(true)
            .cacheOnDisk(true)
            .bitmapConfig(Bitmap.Config.RGB_565)
            .build();

    /**
     * 初始化ImageLoader
     *
     * @param context
     */
    public static void initImageLoader(Context context) {

        ImageLoaderConfiguration config = new ImageLoaderConfiguration.Builder(
                context)
                .threadPoolSize(3)// default
                .threadPriority(Thread.NORM_PRIORITY - 2)
                .denyCacheImageMultipleSizesInMemory()
                .tasksProcessingOrder(QueueProcessingType.LIFO)
                .denyCacheImageMultipleSizesInMemory()
                // .memoryCache(new LruMemoryCache((int) (6 * 1024 * 1024)))
                .memoryCache(new WeakMemoryCache())
                .memoryCacheSize((int) (2 * 1024 * 1024))
                .memoryCacheSizePercentage(13)
                .build();
        ImageLoader.getInstance().init(config);
    }

    /**
     * 下载图片并显示在ImageView上
     *
     * @param imgUrl    下载图片的地址
     * @param imageView 显示图片的ImageView
     */
    public static void display(String imgUrl, ImageView imageView) {
        ImageLoader.getInstance().displayImage(imgUrl, imageView, options);
    }

    /**
     * 下载图片并显示在ImageView上
     *
     * @param imgUrl    下载图片的地址
     * @param imageView 显示图片的ImageView
     */
    public static void display(String imgUrl, ImageView imageView, int loading) {
        //显示图片的配置
        DisplayImageOptions options = new DisplayImageOptions.Builder()
                .showImageOnLoading(loading)  // 设置图片下载期间显示的图片
                .showImageForEmptyUri(loading)// 设置图片Uri为空或是错误的时候显示的图片
                .showImageOnFail(loading)  // 设置图片加载或解码过程中发生错误显示的图片
                .cacheInMemory(true)
                .cacheOnDisc(false)
                .bitmapConfig(Bitmap.Config.RGB_565)
                .build();

        ImageLoader.getInstance().displayImage(imgUrl, imageView, options);
    }

    /**
     * 下载图片并显示在ImageView上
     *
     * @param imgUrl    下载图片的地址
     * @param imageView 显示图片的ImageView
     */
    public static void display(String imgUrl, ImageView imageView, int loading, SimpleImageLoadingListener simpleImageLoadingListener) {
        //显示图片的配置
        DisplayImageOptions options = new DisplayImageOptions.Builder()
                .showImageOnLoading(loading)  // 设置图片下载期间显示的图片
                .showImageForEmptyUri(loading)// 设置图片Uri为空或是错误的时候显示的图片
                .showImageOnFail(loading)  // 设置图片加载或解码过程中发生错误显示的图片
                .cacheInMemory(true)
                .cacheOnDisc(false)
                .bitmapConfig(Bitmap.Config.RGB_565)
                .build();

        ImageLoader.getInstance().displayImage(imgUrl, imageView, options, simpleImageLoadingListener);
    }

    /**
     * 下载图片并显示在ImageView上
     *
     * @param imgUrl 下载图片的地址
     */
    public static Bitmap getBitmap(String imgUrl, int loading) {
        //显示图片的配置
        DisplayImageOptions options = new DisplayImageOptions.Builder()
                .showImageOnLoading(loading)  // 设置图片下载期间显示的图片
                .showImageForEmptyUri(loading)// 设置图片Uri为空或是错误的时候显示的图片
                .showImageOnFail(loading)  // 设置图片加载或解码过程中发生错误显示的图片
                .cacheInMemory(true)
                .cacheOnDisc(false)
                .bitmapConfig(Bitmap.Config.RGB_565)
                .build();

        return ImageLoader.getInstance().loadImageSync(imgUrl, options);
    }
}
