package com.dayouzc.e2e.core.util.display;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.PixelFormat;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;

import java.io.ByteArrayOutputStream;

/**
 * 图片类型转换工具类<br>
 * 对一些常用的bitmap操作进行封装
 *
 * @author 何鑫
 * @date 2018/5/24 10:41
 */
public class ImageConvertUtils {

   public static byte[] bitmapToBytes(Bitmap bm){
       ByteArrayOutputStream baos = new ByteArrayOutputStream();
       bm.compress(Bitmap.CompressFormat.PNG, 100, baos);
       return baos.toByteArray();
   }

   public static Bitmap bytesToBitmap(byte[] b){
       if(b.length!=0){
           BitmapFactory.Options opts = new BitmapFactory.Options();
           opts.inSampleSize = 1;
           return BitmapFactory.decodeByteArray(b, 0, b.length,opts);
       } else {
           return null;
       }
   }

   public static Bitmap drawableToBitmap(Drawable drawable){

       int width = drawable.getIntrinsicWidth();
       int height = drawable.getIntrinsicHeight();
       Bitmap bitmap = Bitmap.createBitmap(width, height,
               drawable.getOpacity() != PixelFormat.OPAQUE ? Bitmap.Config.ARGB_8888: Bitmap.Config.RGB_565);
       Canvas canvas = new Canvas(bitmap);
       drawable.setBounds(0,0,width,height);
       drawable.draw(canvas);

       return bitmap;
   }

    public static Drawable bitmapToDrawable(Bitmap bitmap) {
        return new BitmapDrawable(bitmap);
    }

   public static byte[] drawableToBytes(Drawable bm){
       byte[] bytes = bitmapToBytes(drawableToBitmap(bm));
       return bytes;
   }

   public static Drawable bytesToDrawable(byte[] bytes){
       Drawable drawable = bitmapToDrawable(bytesToBitmap(bytes));
       return drawable;
   }

}
