/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.file;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.format.Formatter;
import com.dayouzc.e2e.core.util.FileUtils;
import com.dayouzc.e2e.core.util.LogUtils;
import com.dayouzc.e2e.core.util.ToastUtils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.callback.FileCallback;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.GetRequest;
import com.lzy.okgo.request.base.Request;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

@SuppressLint(value={"SimpleDateFormat"})
public class DownLoadUtils {
    public static String DM_TARGET_FOLDER = "/mnt/sdcard/DYYP/ISERVERAS/PREINST";
    public static Context sContext;
    public static Handler mHandler;

    private DownLoadUtils() {
    }

    public static void register(Context context, String downloadUrl) {
        sContext = context;
        if (StringUtils.isNotEmpty((CharSequence)downloadUrl)) {
            DM_TARGET_FOLDER = downloadUrl;
        }
    }

    public static void downFile(String url, Handler mHandler) {
        DownLoadUtils.mHandler = mHandler;
        String filename = null;
        if (filename == null || "".equals(filename)) {
            filename = url.substring(url.lastIndexOf("/") + 1);
        }
        DownLoadUtils.checkFile(url, filename);
    }

    public static void checkFile(String url, String filename) {
        String filenames = DM_TARGET_FOLDER + filename;
        LogUtils.e("downloadFilePath >>> ", filenames);
        if (DownLoadUtils.fileIsExists(filenames)) {
            File file = new File(filenames);
            FileUtils.openFile(sContext, file);
        } else {
            DownLoadUtils.fileDownLoad(url, filename);
        }
    }

    public static boolean fileIsExists(String filePath) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void fileDownLoad(String url, String filename) {
        ((GetRequest)OkGo.get((String)url).tag((Object)sContext)).execute((Callback)new FileCallback(DM_TARGET_FOLDER, null){

            public void onStart(Request<File, ? extends Request> request) {
                LogUtils.d("TAG", "\u6b63\u5728\u4e0b\u8f7d\u4e2d");
                mHandler.sendEmptyMessage(333);
            }

            public void onSuccess(Response<File> response) {
                File body = (File)response.body();
                LogUtils.d("TAG", "\u4e0b\u8f7d\u5b8c\u6210");
                Message msg = new Message();
                msg.what = 222;
                msg.obj = body;
                mHandler.sendMessage(msg);
            }

            public void onError(Response<File> response) {
                super.onError(response);
                ToastUtils.showToast(sContext, response.getException().getMessage());
            }

            public void downloadProgress(Progress progress) {
                String downloadLength = Formatter.formatFileSize((Context)sContext, (long)progress.currentSize);
                String totalLength = Formatter.formatFileSize((Context)sContext, (long)progress.totalSize);
                LogUtils.e("TAG", (float)Math.round(progress.fraction * 10000.0f) * 1.0f / 100.0f + "%");
                Message msg = new Message();
                msg.what = 111;
                msg.obj = Float.valueOf((float)Math.round(progress.fraction * 10000.0f) * 1.0f / 100.0f);
                mHandler.sendMessage(msg);
            }
        });
    }
}

