package com.dayouzc.e2e.core.util.security;

import java.net.URLDecoder;
import java.net.URLEncoder;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

import Decoder.BASE64Decoder;
import Decoder.BASE64Encoder;

/**
 * 加密 解密 相关帮助类
 *
 * @author 何鑫
 * @date 2018/5/24 10:50
 */
public class ThreeDesUtils {
	
	public static String encryptMode(String key, String src) throws Exception{
		return encryptMode(key.getBytes("UTF-8"),src);
	}
	
	public static String encryptMode(byte[] key, String src) throws Exception {
			DESedeKeySpec dks = new DESedeKeySpec(key);
			SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
			SecretKey securekey = keyFactory.generateSecret(dks);
			Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
			IvParameterSpec iv = new IvParameterSpec("01234567".getBytes("UTF-8")); 
			cipher.init(Cipher.ENCRYPT_MODE, securekey,  iv);
			byte[] b = cipher.doFinal(URLEncoder.encode(src, "UTF-8").replaceAll("\\+","%20").getBytes("UTF-8"));
			
			BASE64Encoder encoder = new BASE64Encoder();
			return encoder.encode(b).replaceAll("\r", "").replaceAll("\n", "");
	}  
	public static String decryptMode(String key, String src) throws Exception{
		return decryptMode(key.getBytes("UTF-8"),src);
	}
	//3DESECB解密,key必须是长度大于等于 3*8 = 24 位  
	public static String decryptMode(byte[] key, String src) throws Exception{
			// --通过base64,将字符串转成byte数组
			BASE64Decoder decoder = new BASE64Decoder();
			byte[] bytesrc = decoder.decodeBuffer(src.replaceAll(" ", "+"));
			// --解密的key
			DESedeKeySpec dks = new DESedeKeySpec(key);
			SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
			SecretKey securekey = keyFactory.generateSecret(dks);
			// --Chipher对象解密
			Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
			IvParameterSpec iv = new IvParameterSpec("01234567".getBytes("UTF-8")); 
			cipher.init(Cipher.DECRYPT_MODE, securekey,  iv);
			byte[] retByte = cipher.doFinal(bytesrc);

			return URLDecoder.decode(new String(retByte,"UTF-8"), "UTF-8");
	}
	
	public static void main(String[] args) throws Exception {
		
		String key = "SJdLgViYsZvlwoFDHI1KQMRO";// RandomStr.getString(24);
		System.out.println("密钥:" + key);
		String szSrc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request>  <accountId>20130527155011172</accountId>  <accountKey>9edp7HOJWBTE20</accountKey>  <appId></appId>  <appOrderNo></appOrderNo>  <createDate></createDate>  <createDateEnd></createDateEnd>  <orderId></orderId>  <orderName></orderName>  <orderStatus>0</orderStatus>  <partnerId></partnerId>  <paymentAmount></paymentAmount>  <paymentAmountEnd></paymentAmountEnd></Request>";
		System.out.println("加密前的字符串:" + URLEncoder.encode(szSrc,"UTF-8"));
		System.out.println("加密前的字符串:" + szSrc);
		String encoded = encryptMode(key,szSrc);
		System.out.println("加密后的字符串:" + encoded);
		String srcBytes = decryptMode(key,encoded);
		System.out.println("解密后的字符串:" + srcBytes);
		 
	}
}