/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.file;

import android.annotation.SuppressLint;
import android.os.Environment;
import android.support.annotation.Nullable;
import com.dayouzc.e2e.core.DYUtils;
import com.dayouzc.e2e.core.util.file.CloseUtils;
import com.dayouzc.e2e.core.util.file.FileIOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public final class FileUtils {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private FileUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isSDCardExist() {
        return "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable();
    }

    public static String getDiskCacheDir() {
        return FileUtils.isSDCardExist() && DYUtils.getContext().getExternalCacheDir() != null ? DYUtils.getContext().getExternalCacheDir().getPath() : DYUtils.getContext().getCacheDir().getPath();
    }

    public static String getDiskCacheDir(String fileDir) {
        return FileUtils.getDiskCacheDir() + File.separator + fileDir;
    }

    public static String getDiskFilesDir() {
        return FileUtils.isSDCardExist() && DYUtils.getContext().getExternalFilesDir(null) != null ? DYUtils.getContext().getExternalFilesDir(null).getPath() : DYUtils.getContext().getFilesDir().getPath();
    }

    public static String getDiskFilesDir(String fileDir) {
        return FileUtils.getDiskFilesDir() + File.separator + fileDir;
    }

    public static String getDiskDir(String fileDir) {
        if (FileUtils.isSDCardExist()) {
            return Environment.getExternalStorageDirectory() + File.separator + fileDir;
        }
        return DYUtils.getContext().getDir(fileDir, 0).getPath();
    }

    public static String getDiskDir() {
        return FileUtils.getDiskDir(DYUtils.getContext().getPackageName());
    }

    private String getFilePath(String dirPath, String fileName) {
        return this.getDirPath(dirPath) + fileName;
    }

    private String getDirPath(String dirPath) {
        if (FileUtils.isSpace(dirPath)) {
            return "";
        }
        if (!dirPath.trim().endsWith(File.separator)) {
            dirPath = dirPath.trim() + File.separator;
        }
        return dirPath;
    }

    @Nullable
    public static File getFileByPath(String filePath) {
        return FileUtils.isSpace(filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(String filePath) {
        return FileUtils.isFileExists(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean isFolderExist(String dirPath) {
        return FileUtils.isFolderExist(FileUtils.getFileByPath(dirPath));
    }

    public static boolean isFolderExist(File dir) {
        return dir != null && dir.exists() && dir.isDirectory();
    }

    public static boolean isDir(String dirPath) {
        return FileUtils.isDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean isDir(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    public static boolean isFile(String filePath) {
        return FileUtils.isFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static boolean rename(String filePath, String newName) {
        return FileUtils.rename(FileUtils.getFileByPath(filePath), newName);
    }

    public static boolean rename(File file, String newName) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (FileUtils.isSpace(newName)) {
            return false;
        }
        if (newName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public static File isFileNotExistCreate(String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        if (file == null) {
            return null;
        }
        if (file.exists()) {
            return file;
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return null;
        }
        try {
            file.createNewFile();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtils.createOrExistsDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return FileUtils.createOrExistsFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String filePath) {
        return FileUtils.createFileByDeleteOldFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean copyOrMoveDir(String srcDirPath, String destDirPath, OnReplaceListener listener, boolean isMove) {
        return FileUtils.copyOrMoveDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath), listener, isMove);
    }

    private static boolean copyOrMoveDir(File srcDir, File destDir, OnReplaceListener listener, boolean isMove) {
        File[] files;
        if (srcDir == null || destDir == null) {
            return false;
        }
        String srcPath = srcDir.getPath() + File.separator;
        String destPath = destDir.getPath() + File.separator;
        if (destPath.contains(srcPath)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (destDir.exists()) {
            if (listener == null || listener.onReplace()) {
                if (!FileUtils.deleteAllInDir(destDir)) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(destDir)) {
            return false;
        }
        for (File file : files = srcDir.listFiles()) {
            File oneDestFile = new File(destPath + file.getName());
            if (!(file.isFile() ? !FileUtils.copyOrMoveFile(file, oneDestFile, listener, isMove) : file.isDirectory() && !FileUtils.copyOrMoveDir(file, oneDestFile, listener, isMove))) continue;
            return false;
        }
        return !isMove || FileUtils.deleteDir(srcDir);
    }

    private static boolean copyOrMoveFile(String srcFilePath, String destFilePath, OnReplaceListener listener, boolean isMove) {
        return FileUtils.copyOrMoveFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath), listener, isMove);
    }

    private static boolean copyOrMoveFile(File srcFile, File destFile, OnReplaceListener listener, boolean isMove) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        if (srcFile.equals(destFile)) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (destFile.exists()) {
            if (listener == null || listener.onReplace()) {
                if (!destFile.delete()) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(destFile.getParentFile())) {
            return false;
        }
        try {
            return FileIOUtils.writeFileFromIS(destFile, (InputStream)new FileInputStream(srcFile), false) && (!isMove || FileUtils.deleteFile(srcFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyDir(String srcDirPath, String destDirPath, OnReplaceListener listener) {
        return FileUtils.copyDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath), listener);
    }

    public static boolean copyDir(File srcDir, File destDir, OnReplaceListener listener) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, listener, false);
    }

    public static boolean copyFile(String srcFilePath, String destFilePath, OnReplaceListener listener) {
        return FileUtils.copyFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath), listener);
    }

    public static boolean copyFile(File srcFile, File destFile, OnReplaceListener listener) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, listener, false);
    }

    public static boolean moveDir(String srcDirPath, String destDirPath, OnReplaceListener listener) {
        return FileUtils.moveDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath), listener);
    }

    public static boolean moveDir(File srcDir, File destDir, OnReplaceListener listener) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, listener, true);
    }

    public static boolean moveFile(String srcFilePath, String destFilePath, OnReplaceListener listener) {
        return FileUtils.moveFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath), listener);
    }

    public static boolean moveFile(File srcFile, File destFile, OnReplaceListener listener) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, listener, true);
    }

    public static boolean deleteDir(String dirPath) {
        return FileUtils.deleteDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String srcFilePath) {
        return FileUtils.deleteFile(FileUtils.getFileByPath(srcFilePath));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static boolean deleteFileSafely(File file) {
        if (file != null && file.exists()) {
            String tmpPath = file.getParent() + File.separator + System.currentTimeMillis();
            File tmp = new File(tmpPath);
            file.renameTo(tmp);
            return tmp.delete();
        }
        return false;
    }

    public static boolean deleteAllInDir(String dirPath) {
        return FileUtils.deleteAllInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteAllInDir(File dir) {
        return FileUtils.deleteFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        });
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return FileUtils.deleteFilesInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteFilesInDir(File dir) {
        return FileUtils.deleteFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
    }

    public static boolean deleteFilesInDirWithFilter(String dirPath, FileFilter filter) {
        return FileUtils.deleteFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter);
    }

    public static boolean deleteFilesInDirWithFilter(File dir, FileFilter filter) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!filter.accept(file) || !(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> listFilesInDir(String dirPath) {
        return FileUtils.listFilesInDir(dirPath, false);
    }

    public static List<File> listFilesInDir(File dir) {
        return FileUtils.listFilesInDir(dir, false);
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        }, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, false);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilter(dir, filter, false);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter, boolean isRecursive) {
        if (!FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (filter.accept(file)) {
                    list.add(file);
                }
                if (!isRecursive || !file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithFilter(file, filter, true));
            }
        }
        return list;
    }

    public static long getFileLastModified(String filePath) {
        return FileUtils.getFileLastModified(FileUtils.getFileByPath(filePath));
    }

    public static long getFileLastModified(File file) {
        if (file == null) {
            return -1L;
        }
        return file.lastModified();
    }

    public static String getFileCharsetSimple(String filePath) {
        return FileUtils.getFileCharsetSimple(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        int p = 0;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            p = (((InputStream)is).read() << 8) + ((InputStream)is).read();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtils.closeIO(is);
                throw throwable;
            }
            CloseUtils.closeIO(is);
        }
        CloseUtils.closeIO(is);
        switch (p) {
            case 61371: {
                return "UTF-8";
            }
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static int getFileLines(String filePath) {
        return FileUtils.getFileLines(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLines(File file) {
        int count = 1;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            if (LINE_SEP.endsWith("\n")) {
                int readChars;
                while ((readChars = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                    for (int i = 0; i < readChars; ++i) {
                        if (buffer[i] != 10) continue;
                        ++count;
                    }
                }
            } else {
                int readChars;
                while ((readChars = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                    for (int i = 0; i < readChars; ++i) {
                        if (buffer[i] != 13) continue;
                        ++count;
                    }
                }
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtils.closeIO(is);
                throw throwable;
            }
            CloseUtils.closeIO(is);
        }
        CloseUtils.closeIO(is);
        return count;
    }

    public static String getDirSize(String dirPath) {
        return FileUtils.getDirSize(FileUtils.getFileByPath(dirPath));
    }

    public static String getDirSize(File dir) {
        long len = FileUtils.getDirLength(dir);
        return len == -1L ? "" : FileUtils.byte2FitMemorySize(len);
    }

    public static String getFileSize(String filePath) {
        long len = FileUtils.getFileLength(filePath);
        return len == -1L ? "" : FileUtils.byte2FitMemorySize(len);
    }

    public static String getFileSize(File file) {
        long len = FileUtils.getFileLength(file);
        return len == -1L ? "" : FileUtils.byte2FitMemorySize(len);
    }

    public static long getDirLength(String dirPath) {
        return FileUtils.getDirLength(FileUtils.getFileByPath(dirPath));
    }

    public static long getDirLength(File dir) {
        if (!FileUtils.isDir(dir)) {
            return -1L;
        }
        long len = 0L;
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    len += FileUtils.getDirLength(file);
                    continue;
                }
                len += file.length();
            }
        }
        return len;
    }

    public static long getFileLength(String filePath) {
        boolean isURL = filePath.matches("[a-zA-z]+://[^\\s]*");
        if (isURL) {
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL(filePath).openConnection();
                conn.setRequestProperty("Accept-Encoding", "identity");
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    return conn.getContentLength();
                }
                return -1L;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return FileUtils.getFileLength(FileUtils.getFileByPath(filePath));
    }

    public static long getFileLength(File file) {
        if (!FileUtils.isFile(file)) {
            return -1L;
        }
        return file.length();
    }

    public static String getFileMD5ToString(String filePath) {
        File file = FileUtils.isSpace(filePath) ? null : new File(filePath);
        return FileUtils.getFileMD5ToString(file);
    }

    public static String getFileMD5ToString(File file) {
        return FileUtils.bytes2HexString(FileUtils.getFileMD5(file));
    }

    public static byte[] getFileMD5(String filePath) {
        return FileUtils.getFileMD5(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] getFileMD5(File file) {
        byte[] byArray;
        if (file == null) {
            return null;
        }
        DigestInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (dis.read(buffer) > 0) {
            }
            md = dis.getMessageDigest();
            byArray = md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtils.closeIO(dis);
                throw throwable;
            }
            CloseUtils.closeIO(dis);
            return null;
        }
        CloseUtils.closeIO(dis);
        return byArray;
    }

    public static String getDirName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getDirName(file.getPath());
    }

    public static String getDirName(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? "" : filePath.substring(0, lastSep + 1);
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileName(file.getPath());
    }

    public static String getFileName(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? filePath : filePath.substring(lastSep + 1);
    }

    public static String getFileNameNoExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileNameNoExtension(file.getPath());
    }

    public static String getFileNameNoExtension(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastSep == -1) {
            return lastPoi == -1 ? filePath : filePath.substring(0, lastPoi);
        }
        if (lastPoi == -1 || lastSep > lastPoi) {
            return filePath.substring(lastSep + 1);
        }
        return filePath.substring(lastSep + 1, lastPoi);
    }

    public static String getFileNameNoExtensionWithPath(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        if (lastPoi == -1) {
            return filePath;
        }
        return filePath.substring(0, lastPoi);
    }

    public static String changeFileExtension(String filePath, String extensionName) {
        if (FileUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastPoi == -1 || lastSep >= lastPoi) {
            return "";
        }
        return filePath.substring(0, lastPoi) + extensionName;
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastPoi == -1 || lastSep >= lastPoi) {
            return "";
        }
        return filePath.substring(lastPoi + 1);
    }

    private static String bytes2HexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        if (len <= 0) {
            return null;
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = hexDigits[bytes[i] >>> 4 & 0xF];
            ret[j++] = hexDigits[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String byte2FitMemorySize(long byteNum) {
        if (byteNum < 0L) {
            return "shouldn't be less than zero!";
        }
        if (byteNum < 1024L) {
            return String.format("%.3fB", byteNum);
        }
        if (byteNum < 0x100000L) {
            return String.format("%.3fKB", (double)byteNum / 1024.0);
        }
        if (byteNum < 0x40000000L) {
            return String.format("%.3fMB", (double)byteNum / 1048576.0);
        }
        return String.format("%.3fGB", (double)byteNum / 1.073741824E9);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String byte2FitMemorySize(long byteNum, int length) {
        if (byteNum < 0L) {
            return "shouldn't be less than zero!";
        }
        if (byteNum < 1024L) {
            return String.format("%." + length + "fB", byteNum);
        }
        if (byteNum < 0x100000L) {
            return String.format("%." + length + "fKB", (double)byteNum / 1024.0);
        }
        if (byteNum < 0x40000000L) {
            return String.format("%." + length + "fMB", (double)byteNum / 1048576.0);
        }
        return String.format("%." + length + "fGB", (double)byteNum / 1.073741824E9);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static interface OnReplaceListener {
        public boolean onReplace();
    }
}

