/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.dayouzc.e2e.core.DYUtils;
import com.dayouzc.e2e.core.util.JsonUtils;
import com.dayouzc.e2e.core.util.StringUtils;
import com.dayouzc.e2e.core.util.security.Base64Utils;
import com.dayouzc.e2eplatform.core.util.JsonUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;

public final class SPUtils {
    private SPUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static SharedPreferences getDefaultSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)DYUtils.getContext());
    }

    public static SharedPreferences getSharedPreferences(String spName) {
        return DYUtils.getContext().getSharedPreferences(spName, 0);
    }

    public static boolean putBoolean(SharedPreferences sp, String key, boolean value) {
        return sp.edit().putBoolean(key, value).commit();
    }

    public static boolean putFloat(SharedPreferences sp, String key, float value) {
        return sp.edit().putFloat(key, value).commit();
    }

    public static boolean putLong(SharedPreferences sp, String key, long value) {
        return sp.edit().putLong(key, value).commit();
    }

    public static boolean putString(SharedPreferences sp, String key, String value) {
        return sp.edit().putString(key, value).commit();
    }

    public static boolean putInt(SharedPreferences sp, String key, int value) {
        return sp.edit().putInt(key, value).commit();
    }

    public static boolean putObject(SharedPreferences sp, String key, Object value) {
        return sp.edit().putString(key, JsonUtils.toJSON(value)).commit();
    }

    public static boolean putEncodeObject(SharedPreferences sp, String key, Object value) {
        String base64Obj = Base64Utils.encode(JsonUtils.toJSON(value), "UTF-8");
        return sp.edit().putString(key, base64Obj).commit();
    }

    public static boolean put(SharedPreferences sp, String key, Object object) {
        if (object instanceof String) {
            return sp.edit().putString(key, (String)object).commit();
        }
        if (object instanceof Integer) {
            return sp.edit().putInt(key, ((Integer)object).intValue()).commit();
        }
        if (object instanceof Boolean) {
            return sp.edit().putBoolean(key, ((Boolean)object).booleanValue()).commit();
        }
        if (object instanceof Float) {
            return sp.edit().putFloat(key, ((Float)object).floatValue()).commit();
        }
        if (object instanceof Long) {
            return sp.edit().putLong(key, ((Long)object).longValue()).commit();
        }
        return sp.edit().putString(key, StringUtils.toString(object)).commit();
    }

    public static boolean getBoolean(SharedPreferences sp, String key, boolean defValue) {
        try {
            return sp.getBoolean(key, defValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static long getLong(SharedPreferences sp, String key, long defValue) {
        try {
            return sp.getLong(key, defValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static float getFloat(SharedPreferences sp, String key, float defValue) {
        try {
            return sp.getFloat(key, defValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static String getString(SharedPreferences sp, String key, String defValue) {
        try {
            return sp.getString(key, defValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static int getInt(SharedPreferences sp, String key, int defValue) {
        try {
            return sp.getInt(key, defValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static <T> T getEncodeObject(SharedPreferences sp, String key, Type type) throws IOException {
        String base64Obj = SPUtils.getString(sp, key, "");
        if (StringUtils.isEmpty(base64Obj)) {
            return null;
        }
        String json = Base64Utils.decode(base64Obj, "UTF-8");
        return (T)JsonUtil.fromJson((String)json, (Class)((Class)type));
    }

    public static <T> T getObject(SharedPreferences sp, String key, Type type) {
        try {
            return (T)JsonUtil.fromJson((String)SPUtils.getString(sp, key, ""), (Class)((Class)type));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object get(SharedPreferences sp, String key, Object defaultObject) {
        try {
            if (defaultObject instanceof String) {
                return sp.getString(key, (String)defaultObject);
            }
            if (defaultObject instanceof Integer) {
                return sp.getInt(key, ((Integer)defaultObject).intValue());
            }
            if (defaultObject instanceof Boolean) {
                return sp.getBoolean(key, ((Boolean)defaultObject).booleanValue());
            }
            if (defaultObject instanceof Float) {
                return Float.valueOf(sp.getFloat(key, ((Float)defaultObject).floatValue()));
            }
            if (defaultObject instanceof Long) {
                return sp.getLong(key, ((Long)defaultObject).longValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultObject;
    }

    public static boolean contains(SharedPreferences sp, String key) {
        return sp.contains(key);
    }

    public static Map<String, ?> getAll(SharedPreferences sp) {
        try {
            return sp.getAll();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean remove(SharedPreferences sp, String key) {
        return sp.edit().remove(key).commit();
    }

    public static boolean clear(SharedPreferences sp) {
        return sp.edit().clear().commit();
    }
}

