/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import java.lang.reflect.Method;

public class SystemUtils {
    static Context context;

    private static void init(Application application) {
        if (context == null) {
            context = application;
        }
    }

    public static String[] AppPremission(Context context) {
        try {
            SystemUtils.init((Application)context);
            PackageInfo packinfo = context.getPackageManager().getPackageInfo(context.getPackageCodePath(), 4096);
            return packinfo.requestedPermissions;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String AppSignature(Context context) {
        try {
            SystemUtils.init((Application)context);
            PackageInfo packinfo = context.getPackageManager().getPackageInfo(context.getPackageCodePath(), 64);
            return packinfo.signatures[0].toCharsString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "No Search";
        }
    }

    public static Drawable AppIcon(Context context) {
        try {
            SystemUtils.init((Application)context);
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            return info.loadIcon(context.getPackageManager());
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String AppName(Context context) {
        try {
            SystemUtils.init((Application)context);
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageCodePath(), 0);
            return info.loadLabel(context.getPackageManager()).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "No Search";
        }
    }

    public static int VersionCode(Context context) {
        int versioncode = 0;
        try {
            SystemUtils.init((Application)context);
            versioncode = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versioncode;
    }

    public static String VersionName(Context context) {
        String versionname = "unknow";
        try {
            SystemUtils.init((Application)context);
            versionname = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionname;
    }

    public static String PackgeName(Context context) {
        String packgename = "unknow";
        try {
            SystemUtils.init((Application)context);
            packgename = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return packgename;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String IMEI(Context context) {
        SystemUtils.init((Application)context);
        String imei = "NO Search";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        imei = telephonyManager.getDeviceId();
        return imei;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String IMSI(Context context) {
        SystemUtils.init((Application)context);
        String imsi = "NO Search";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        imsi = telephonyManager.getSubscriberId();
        return imsi;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String Num(Context context) {
        SystemUtils.init((Application)context);
        String num = "NO Search";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        num = telephonyManager.getLine1Number();
        return num;
    }

    public static String SN(Context context) {
        SystemUtils.init((Application)context);
        String sn = "NO Search";
        String serial = Build.SERIAL;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            sn = (String)get.invoke(c, "ro.serialno");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sn;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String SIM(Context context) {
        SystemUtils.init((Application)context);
        String sim = "NO Search";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        sim = telephonyManager.getSimSerialNumber();
        return sim;
    }

    public static String ID(Context context) {
        SystemUtils.init((Application)context);
        String id2 = "NO Search";
        id2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return id2;
    }

    public static String MAC(Context context) {
        SystemUtils.init((Application)context);
        String mac = "NO Search";
        WifiManager manager = (WifiManager)context.getSystemService("wifi");
        WifiInfo info = manager.getConnectionInfo();
        mac = info.getMacAddress();
        return mac;
    }

    public static String Country(Context context) {
        SystemUtils.init((Application)context);
        String country = "NO Search";
        country = context.getResources().getConfiguration().locale.getCountry();
        return country;
    }

    public static String Language(Context context) {
        SystemUtils.init((Application)context);
        String language = "NO Search";
        String country = context.getResources().getConfiguration().locale.getCountry();
        language = context.getResources().getConfiguration().locale.getLanguage();
        if (language.equals("zh")) {
            language = country.equals("CN") ? "Simplified Chinese" : "Traditional Chinese";
        }
        return language;
    }

    public static int Height(Context context) {
        SystemUtils.init((Application)context);
        int height = 0;
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        height = dm.heightPixels;
        return height;
    }

    public static int Width(Context context) {
        SystemUtils.init((Application)context);
        int width = 0;
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        width = dm.widthPixels;
        return width;
    }
}

