/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class NetWorkUtils {
    @SuppressLint(value={"MissingPermission"})
    public static boolean isOpenWifi(Context context) {
        WifiManager connectivityManager = (WifiManager)context.getSystemService("wifi");
        return connectivityManager.isWifiEnabled();
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isConnected(Context context) {
        boolean bisConnFlag = false;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo network = connectivityManager.getActiveNetworkInfo();
        if (network != null) {
            bisConnFlag = connectivityManager.getActiveNetworkInfo().isAvailable();
        }
        return bisConnFlag;
    }

    public static boolean isWifi(Context context) {
        boolean isWifi;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (!NetWorkUtils.isConnected(context)) {
            Log.i((String)"NetStatus", (String)"\u5f53\u524d\u7f51\u7edc----->\u4e0d\u53ef\u7528");
            return false;
        }
        boolean bl = isWifi = connectivityManager.getActiveNetworkInfo().getType() == 1;
        if (isWifi) {
            Log.i((String)"NetStatus", (String)"\u5f53\u524d\u7f51\u7edc----->WIFI\u73af\u5883");
        } else {
            Log.i((String)"NetStatus", (String)"\u5f53\u524d\u7f51\u7edc----->\u975eWIFI\u73af\u5883");
        }
        return isWifi;
    }

    public static void openSetting(Activity activity) {
        Intent intent = null;
        if (Build.VERSION.SDK_INT > 10) {
            intent = new Intent("android.settings.WIRELESS_SETTINGS");
        } else {
            intent = new Intent();
            ComponentName component = new ComponentName("com.android.settings", "com.android.settings.WirelessSettings");
            intent.setComponent(component);
            intent.setAction("android.intent.action.VIEW");
        }
        activity.startActivity(intent);
    }

    public static String getNetworkTypeName(Context context) {
        NetworkInfo info;
        ConnectivityManager connectMgr;
        if (context != null && (connectMgr = (ConnectivityManager)context.getSystemService("connectivity")) != null && (info = connectMgr.getActiveNetworkInfo()) != null) {
            switch (info.getType()) {
                case 1: {
                    return "WIFI";
                }
                case 0: {
                    return NetWorkUtils.getNetworkTypeName(info.getSubtype());
                }
            }
        }
        return NetWorkUtils.getNetworkTypeName(0);
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getNetworkName(Context context) {
        NetworkInfo wifiNetInfo;
        ConnectivityManager connectMgr;
        if (context != null && (connectMgr = (ConnectivityManager)context.getSystemService("connectivity")) != null && (wifiNetInfo = connectMgr.getNetworkInfo(1)).isConnected()) {
            return wifiNetInfo.getExtraInfo();
        }
        return "";
    }

    private static String getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNetworkOnline(String ip) {
        if (ip == null || ip.length() <= 0) {
            ip = "192.168.100.2";
        }
        Runtime runtime = Runtime.getRuntime();
        Process ipProcess = null;
        try {
            ipProcess = Runtime.getRuntime().exec("/system/bin/ping -c 2 -w 2 " + ip);
            InputStream input = ipProcess.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            StringBuffer stringBuffer = new StringBuffer();
            String content = "";
            while ((content = in.readLine()) != null) {
                stringBuffer.append(content);
            }
            int exitValue = ipProcess.waitFor();
            if (exitValue == 0) {
                boolean bl = true;
                return bl;
            }
            if (stringBuffer == null || stringBuffer.length() <= 0) {
                boolean bl = false;
                return bl;
            }
            if (stringBuffer.indexOf("100% packet loss") != -1) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (ipProcess != null) {
                ipProcess.destroy();
            }
            runtime.gc();
        }
        return false;
    }

    public static boolean isNetworkOnline2(String ip) {
        try {
            Process process = Runtime.getRuntime().exec("/system/bin/ping -c 2 -w 3 " + ip);
            int status = process.waitFor();
            return status == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }
}

