/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.format.Formatter;
import com.dayouzc.e2e.core.util.DownLoadUtils;
import com.dayouzc.e2e.core.util.FileUtils;
import com.dayouzc.e2e.core.util.LogUtils;
import com.dayouzc.e2e.core.util.LoginUtils;
import com.dayouzc.e2e.core.util.ToastUtils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.callback.FileCallback;
import com.lzy.okgo.model.Progress;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.GetRequest;
import com.lzy.okgo.request.base.Request;
import java.io.File;

@SuppressLint(value={"SimpleDateFormat"})
public class LoadFileUtils {
    public static final String DM_TARGET_FOLDER = "/mnt/sdcard/DYYP/ISERVERAS/PREINST";
    public static Context sContext;

    private LoadFileUtils() {
    }

    public static void register(Context context) {
        sContext = context.getApplicationContext();
    }

    public static void downFile(String url) {
        String filename = null;
        if (filename == null || "".equals(filename)) {
            filename = url.substring(url.lastIndexOf("/") + 1);
        }
        LoadFileUtils.checkFile(url, filename);
    }

    public static void checkFile(String url, String filename) {
        String filenames = DM_TARGET_FOLDER + filename;
        if (LoginUtils.fileIsExists(filenames)) {
            File file = new File(filenames);
            FileUtils.openFile(sContext, file);
        } else {
            LoadFileUtils.fileDownLoad(url, filename);
        }
    }

    public static void fileDownLoad(String url, String filename) {
        ((GetRequest)OkGo.get((String)url).tag((Object)sContext)).execute((Callback)new FileCallback(){

            public void onStart(Request<File, ? extends Request> request) {
                LogUtils.d("TAG", "\u6b63\u5728\u4e0b\u8f7d\u4e2d");
                ToastUtils.showToast(sContext, "\u6b63\u5728\u4e0b\u8f7d");
            }

            public void onSuccess(Response<File> response) {
                File body = (File)response.body();
                FileUtils.openFile(sContext, body);
            }

            public void onError(Response<File> response) {
                super.onError(response);
                File body = (File)response.body();
                ToastUtils.showToast(sContext, "\u4e0b\u8f7d\u51fa\u9519");
            }

            public void downloadProgress(Progress progress) {
                String downloadLength = Formatter.formatFileSize((Context)DownLoadUtils.sContext, (long)progress.currentSize);
                String totalLength = Formatter.formatFileSize((Context)DownLoadUtils.sContext, (long)progress.totalSize);
                LogUtils.e("TAG", (float)Math.round(progress.fraction * 10000.0f) * 1.0f / 100.0f + "%");
            }
        });
    }
}

