/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import com.dayouzc.e2e.core.util.DateUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class IDCardUtils {
    public static final int CHINA_ID_MIN_LENGTH = 15;
    public static final int CHINA_ID_MAX_LENGTH = 18;
    public static final String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    public static final int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    public static final String[] verifyCode = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    public static final int MIN = 1930;
    public static Map<String, String> cityCodes = new HashMap<String, String>();
    public static Map<String, Integer> twFirstCode = new HashMap<String, Integer>();
    public static Map<String, Integer> hkFirstCode = new HashMap<String, Integer>();

    private IDCardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    private static String convert15CardTo18(String idCard) {
        String sVal;
        String idCard18 = "";
        if (idCard.length() != 15) {
            return null;
        }
        if (IDCardUtils.isNum(idCard)) {
            String birthday = idCard.substring(6, 12);
            Date birthDate = null;
            try {
                birthDate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar cal = Calendar.getInstance();
            if (birthDate != null) {
                cal.setTime(birthDate);
            }
            String sYear = String.valueOf(cal.get(1));
            idCard18 = idCard.substring(0, 6) + sYear + idCard.substring(8);
            char[] cArr = idCard18.toCharArray();
            int[] iCard = IDCardUtils.convertCharToInt(cArr);
            int iSum17 = IDCardUtils.getPowerSum(iCard);
            sVal = IDCardUtils.getCheckCode18(iSum17);
            if (sVal.length() <= 0) {
                return null;
            }
        } else {
            return null;
        }
        idCard18 = idCard18 + sVal;
        return idCard18;
    }

    private static boolean validateIdCard18(String idCard) {
        boolean bTrue = false;
        if (idCard.length() == 18) {
            char[] cArr;
            int[] iCard;
            int iSum17;
            String val;
            String code17 = idCard.substring(0, 17);
            String code18 = idCard.substring(17, 18);
            if (IDCardUtils.isNum(code17) && (val = IDCardUtils.getCheckCode18(iSum17 = IDCardUtils.getPowerSum(iCard = IDCardUtils.convertCharToInt(cArr = code17.toCharArray())))).length() > 0 && val.equalsIgnoreCase(code18)) {
                bTrue = true;
            }
        }
        return bTrue;
    }

    private static boolean validateIdCard15(String idCard) {
        if (idCard.length() != 15) {
            return false;
        }
        if (IDCardUtils.isNum(idCard)) {
            String proCode = idCard.substring(0, 2);
            if (cityCodes.get(proCode) == null) {
                return false;
            }
            String birthCode = idCard.substring(6, 12);
            Date birthDate = null;
            try {
                birthDate = new SimpleDateFormat("yy").parse(birthCode.substring(0, 2));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar cal = Calendar.getInstance();
            if (birthDate != null) {
                cal.setTime(birthDate);
            }
            return IDCardUtils.validate(cal.get(1), Integer.valueOf(birthCode.substring(2, 4)), Integer.valueOf(birthCode.substring(4, 6)));
        }
        return false;
    }

    private static String[] validateIdCard10(String idCard) {
        String[] info = new String[3];
        String card = idCard.replaceAll("[\\(|\\)]", "");
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return null;
        }
        if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            System.out.println("11111");
            String char2 = idCard.substring(1, 2);
            if (char2.equals("1")) {
                info[1] = "M";
                System.out.println("MMMMMMM");
            } else if (char2.equals("2")) {
                info[1] = "F";
                System.out.println("FFFFFFF");
            } else {
                info[1] = "N";
                info[2] = "false";
                System.out.println("NNNN");
                return info;
            }
            info[2] = IDCardUtils.validateTWCard(idCard) ? "true" : "false";
        } else if (idCard.matches("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
        } else if (idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = IDCardUtils.validateHKCard(idCard) ? "true" : "false";
        } else {
            return null;
        }
        return info;
    }

    public static boolean validateTWCard(String idCard) {
        String start = idCard.substring(0, 1);
        String mid = idCard.substring(1, 9);
        String end = idCard.substring(9, 10);
        Integer iStart = twFirstCode.get(start);
        Integer sum = iStart / 10 + iStart % 10 * 9;
        char[] chars = mid.toCharArray();
        Integer iflag = 8;
        for (char c : chars) {
            sum = sum + Integer.valueOf(c + "") * iflag;
            Integer n = iflag;
            Integer n2 = iflag = Integer.valueOf(iflag - 1);
        }
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.valueOf(end);
    }

    public static boolean validateHKCard(String idCard) {
        String card = idCard.replaceAll("[\\(|\\)]", "");
        Integer sum = 0;
        if (card.length() == 9) {
            sum = (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 9 + (card.substring(1, 2).toUpperCase().toCharArray()[0] - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        Integer iflag = 7;
        for (char c : chars) {
            sum = sum + Integer.valueOf(c + "") * iflag;
            Integer n = iflag;
            Integer n2 = iflag = Integer.valueOf(iflag - 1);
        }
        sum = end.toUpperCase().equals("A") ? Integer.valueOf(sum + 10) : Integer.valueOf(sum + Integer.valueOf(end));
        return sum % 11 == 0;
    }

    private static int[] convertCharToInt(char[] ca) {
        int len = ca.length;
        int[] iArr = new int[len];
        try {
            for (int i = 0; i < len; ++i) {
                iArr[i] = Integer.parseInt(String.valueOf(ca[i]));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return iArr;
    }

    private static int getPowerSum(int[] iArr) {
        int iSum = 0;
        if (power.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                for (int j = 0; j < power.length; ++j) {
                    if (i != j) continue;
                    iSum += iArr[i] * power[j];
                }
            }
        }
        return iSum;
    }

    private static String getCheckCode18(int iSum) {
        String sCode = "";
        switch (iSum % 11) {
            case 10: {
                sCode = "2";
                break;
            }
            case 9: {
                sCode = "3";
                break;
            }
            case 8: {
                sCode = "4";
                break;
            }
            case 7: {
                sCode = "5";
                break;
            }
            case 6: {
                sCode = "6";
                break;
            }
            case 5: {
                sCode = "7";
                break;
            }
            case 4: {
                sCode = "8";
                break;
            }
            case 3: {
                sCode = "9";
                break;
            }
            case 2: {
                sCode = "x";
                break;
            }
            case 1: {
                sCode = "0";
                break;
            }
            case 0: {
                sCode = "1";
            }
        }
        return sCode;
    }

    public static String getAgeDescriptionByBirthday(String birthday, DateFormat format) {
        return IDCardUtils.getAgeDescriptionByBirthday(DateUtils.string2Date(birthday, format));
    }

    public static String getAgeDescriptionByBirthday(Date birthday) {
        String ageDescription = "";
        Calendar cal = Calendar.getInstance();
        int yearNow = cal.get(1);
        int monthNow = cal.get(2) + 1;
        int dayNow = cal.get(5);
        long millisNow = cal.getTimeInMillis();
        cal.setTime(birthday);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2) + 1;
        int dayBirth = cal.get(5);
        long millisBirth = cal.getTimeInMillis();
        int ages = yearNow - yearBirth;
        long time = millisNow - millisBirth;
        int days = (int)(time / 86400000L);
        int hours = (int)(time / 3600000L);
        if (ages > 2 && ages <= 150) {
            if (monthNow <= monthBirth) {
                if (monthNow == monthBirth) {
                    if (dayNow < dayBirth) {
                        --ages;
                    }
                } else {
                    --ages;
                }
            }
            ageDescription = ages + "\u5c81";
        } else if (ages <= 2) {
            ageDescription = days > 100 ? ages * 12 + (monthNow - monthBirth) + "\u6708" : (hours > 72 ? days + "\u5929" : hours + "\u65f6");
        }
        return ageDescription;
    }

    public static String getAgeDescriptionByIdCard(String idCard) {
        return IDCardUtils.getAgeDescriptionByBirthday(IDCardUtils.getBirthByIdCard(idCard), DateUtils.yyyyMMddNoSep.get());
    }

    public static String getBirthByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtils.convert15CardTo18(idCard);
        }
        return idCard.substring(6, 14);
    }

    public static Short getYearByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtils.convert15CardTo18(idCard);
        }
        return Short.valueOf(idCard.substring(6, 10));
    }

    public static Short getMonthByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtils.convert15CardTo18(idCard);
        }
        return Short.valueOf(idCard.substring(10, 12));
    }

    public static Short getDayByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtils.convert15CardTo18(idCard);
        }
        return Short.valueOf(idCard.substring(12, 14));
    }

    public static String getGenderByIdCard(String idCard) {
        String sCardNum;
        String sGender = "N";
        if (idCard.length() == 15) {
            idCard = IDCardUtils.convert15CardTo18(idCard);
        }
        sGender = Integer.parseInt(sCardNum = idCard.substring(16, 17)) % 2 != 0 ? "M" : "F";
        return sGender;
    }

    public static String getProvinceByIdCard(String idCard) {
        int len = idCard.length();
        String sProvince = null;
        String sProvinNum = "";
        if (len == 15 || len == 18) {
            sProvinNum = idCard.substring(0, 2);
        }
        sProvince = cityCodes.get(sProvinNum);
        return sProvince;
    }

    private static boolean isNum(String val) {
        return val != null && !"".equals(val) && val.matches("^[0-9]*$");
    }

    private static boolean validate(int iYear, int iMonth, int iDate) {
        int datePerMonth;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (iYear < 1930 || iYear >= year) {
            return false;
        }
        if (iMonth < 1 || iMonth > 12) {
            return false;
        }
        switch (iMonth) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                datePerMonth = 30;
                break;
            }
            case 2: {
                boolean dm = (iYear % 4 == 0 && iYear % 100 != 0 || iYear % 400 == 0) && iYear > 1930 && iYear < year;
                datePerMonth = dm ? 29 : 28;
                break;
            }
            default: {
                datePerMonth = 31;
            }
        }
        return iDate >= 1 && iDate <= datePerMonth;
    }

    public static boolean validateCard(String idCard) {
        String card = idCard.trim();
        if (IDCardUtils.validateIdCard18(card)) {
            return true;
        }
        if (IDCardUtils.validateIdCard15(card)) {
            return true;
        }
        String[] cardval = IDCardUtils.validateIdCard10(card);
        return cardval != null && "true".equals(cardval[2]);
    }

    public static String hideIdCard(String idCardNo) {
        if (StringUtils.isEmpty((CharSequence)idCardNo)) {
            return "";
        }
        if (idCardNo.length() >= 7) {
            String tempStr = idCardNo.substring(3, idCardNo.length() - 4);
            idCardNo = idCardNo.replaceAll(tempStr, "*****");
        }
        return idCardNo;
    }

    static {
        cityCodes.put("11", "\u5317\u4eac");
        cityCodes.put("12", "\u5929\u6d25");
        cityCodes.put("13", "\u6cb3\u5317");
        cityCodes.put("14", "\u5c71\u897f");
        cityCodes.put("15", "\u5185\u8499\u53e4");
        cityCodes.put("21", "\u8fbd\u5b81");
        cityCodes.put("22", "\u5409\u6797");
        cityCodes.put("23", "\u9ed1\u9f99\u6c5f");
        cityCodes.put("31", "\u4e0a\u6d77");
        cityCodes.put("32", "\u6c5f\u82cf");
        cityCodes.put("33", "\u6d59\u6c5f");
        cityCodes.put("34", "\u5b89\u5fbd");
        cityCodes.put("35", "\u798f\u5efa");
        cityCodes.put("36", "\u6c5f\u897f");
        cityCodes.put("37", "\u5c71\u4e1c");
        cityCodes.put("41", "\u6cb3\u5357");
        cityCodes.put("42", "\u6e56\u5317");
        cityCodes.put("43", "\u6e56\u5357");
        cityCodes.put("44", "\u5e7f\u4e1c");
        cityCodes.put("45", "\u5e7f\u897f");
        cityCodes.put("46", "\u6d77\u5357");
        cityCodes.put("50", "\u91cd\u5e86");
        cityCodes.put("51", "\u56db\u5ddd");
        cityCodes.put("52", "\u8d35\u5dde");
        cityCodes.put("53", "\u4e91\u5357");
        cityCodes.put("54", "\u897f\u85cf");
        cityCodes.put("61", "\u9655\u897f");
        cityCodes.put("62", "\u7518\u8083");
        cityCodes.put("63", "\u9752\u6d77");
        cityCodes.put("64", "\u5b81\u590f");
        cityCodes.put("65", "\u65b0\u7586");
        cityCodes.put("71", "\u53f0\u6e7e");
        cityCodes.put("81", "\u9999\u6e2f");
        cityCodes.put("82", "\u6fb3\u95e8");
        cityCodes.put("91", "\u56fd\u5916");
        twFirstCode.put("A", 10);
        twFirstCode.put("B", 11);
        twFirstCode.put("C", 12);
        twFirstCode.put("D", 13);
        twFirstCode.put("E", 14);
        twFirstCode.put("F", 15);
        twFirstCode.put("G", 16);
        twFirstCode.put("H", 17);
        twFirstCode.put("J", 18);
        twFirstCode.put("K", 19);
        twFirstCode.put("L", 20);
        twFirstCode.put("M", 21);
        twFirstCode.put("N", 22);
        twFirstCode.put("P", 23);
        twFirstCode.put("Q", 24);
        twFirstCode.put("R", 25);
        twFirstCode.put("S", 26);
        twFirstCode.put("T", 27);
        twFirstCode.put("U", 28);
        twFirstCode.put("V", 29);
        twFirstCode.put("X", 30);
        twFirstCode.put("Y", 31);
        twFirstCode.put("W", 32);
        twFirstCode.put("Z", 33);
        twFirstCode.put("I", 34);
        twFirstCode.put("O", 35);
        hkFirstCode.put("A", 1);
        hkFirstCode.put("B", 2);
        hkFirstCode.put("C", 3);
        hkFirstCode.put("R", 18);
        hkFirstCode.put("U", 21);
        hkFirstCode.put("Z", 26);
        hkFirstCode.put("X", 24);
        hkFirstCode.put("W", 23);
        hkFirstCode.put("O", 15);
        hkFirstCode.put("N", 14);
    }
}

