/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@SuppressLint(value={"SimpleDateFormat"})
public class DateConvertUtils {
    private static DateConvertUtils util;
    public SimpleDateFormat date_Formater_1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public SimpleDateFormat date_Formater_2 = new SimpleDateFormat("yyyy-MM-dd");

    public static DateConvertUtils getInstance() {
        if (util == null) {
            util = new DateConvertUtils();
        }
        return util;
    }

    private DateConvertUtils() {
    }

    public Date getDate(String dateStr) {
        Date date = new Date();
        if (TextUtils.isEmpty((CharSequence)dateStr)) {
            return date;
        }
        try {
            date = this.date_Formater_1.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return date;
        }
    }

    public String getDataString_1(Date date) {
        if (date == null) {
            date = new Date();
        }
        String str = this.date_Formater_1.format(date);
        return str;
    }

    public String getDataString_2(Date date) {
        if (date == null) {
            date = new Date();
        }
        String str = this.date_Formater_2.format(date);
        return str;
    }

    public String getRencentTime(String date) {
        int hour;
        String paramDate;
        Date time = this.getDate(date);
        if (time == null) {
            return "\u4e00\u4e2a\u6708\u524d";
        }
        String ftime = "";
        Calendar cal = Calendar.getInstance();
        String curDate = this.date_Formater_2.format(cal.getTime());
        if (curDate.equals(paramDate = this.date_Formater_2.format(time))) {
            int hour2 = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L);
            ftime = hour2 == 0 ? Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d" : hour2 + "\u5c0f\u65f6\u524d";
            return ftime;
        }
        long lt = time.getTime() / 86400000L;
        long ct = cal.getTimeInMillis() / 86400000L;
        int days = (int)(ct - lt);
        ftime = days == 0 ? ((hour = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L)) == 0 ? Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d" : hour + "\u5c0f\u65f6\u524d") : (days == 1 ? "\u6628\u5929" : (days == 2 ? "\u524d\u5929" : (days > 2 && days <= 10 ? days + "\u5929\u524d" : (days > 10 ? "\u4e00\u4e2a\u6708\u524d" : this.date_Formater_2.format(time)))));
        return ftime;
    }

    public String stringDateToStringData(String typeFrom, String typeTo, String value) {
        String re = value;
        SimpleDateFormat sdfFrom = new SimpleDateFormat(typeFrom);
        SimpleDateFormat sdfTo = new SimpleDateFormat(typeTo);
        try {
            re = sdfTo.format(sdfFrom.parse(re));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return re;
    }

    public int getMonthLastDay(int year, int month) {
        if (month == 0) {
            return 0;
        }
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public String getCurrentYear() {
        Calendar c = Calendar.getInstance();
        return c.get(1) + "";
    }

    public String getCurrentMonth() {
        Calendar c = Calendar.getInstance();
        return c.get(2) + 1 + "";
    }

    public String getCurrDay() {
        Calendar c = Calendar.getInstance();
        return c.get(5) + "";
    }

    public String getDayByDate(Calendar calendar, int calendarType, int next) {
        calendar.add(calendarType, next);
        Date date = calendar.getTime();
        String dateString = this.date_Formater_1.format(date);
        return dateString;
    }
}

