package com.dayouzc.e2e.core.util;

import com.dayouzc.e2e.core.consts.UIConsts;

import org.apache.commons.lang3.StringUtils;

/**
 * 设备Sn 相关帮助类
 *
 * @author 何鑫
 */
public class DevicesUtils {

    /** 获取当前设备类型 */
    public static String getDeviceType() {
        String type = getYPSN();
        if (type.startsWith(UIConsts.DeviceType.YP_DEVICE)) {
            return UIConsts.DeviceType.YP_DEVICE;
        } else if (type.startsWith(UIConsts.DeviceType.ARM_DEVICE)) {
            return UIConsts.DeviceType.ARM_DEVICE;
        } else {
            return UIConsts.DeviceType.OTHER_DEVICE;
        }
    }

    /** 获取设备SN  读取的本地文件*/
    public static String getYPSN() {
        String youpieSn = LoginUtils.getyoupieSn();
        if (StringUtils.isEmpty(youpieSn)) {
            LoginUtils.setYouPieSn(android.os.Build.SERIAL);
            return android.os.Build.SERIAL;
        } else {
            return youpieSn;
        }
    }

    /** 获取当前设备真实的类型 */
    public static String getDeviceMode() {
        String type = getYPNum();
        if (type.startsWith(UIConsts.DeviceType.YP_DEVICE)) {
            return UIConsts.DeviceType.YP_DEVICE;
        } else if (type.startsWith(UIConsts.DeviceType.ARM_DEVICE)) {
            return UIConsts.DeviceType.ARM_DEVICE;
        } else {
            return UIConsts.DeviceType.OTHER_DEVICE;
        }
    }

    /** 判断是否是 有派 设备 */
    public static boolean isYouPie() {
        String type = getDeviceType();
        if (type.equals(UIConsts.DeviceType.YP_DEVICE)) {
            return true;
        } else {
            return false;
        }
    }

    /** 判断是否是 ARM 设备 */
    public static boolean isARM() {
        String type = getDeviceType();
        if (type.equals(UIConsts.DeviceType.ARM_DEVICE)) {
            return true;
        } else {
            return false;
        }
    }

    // TODO: 2020/5/27  我们认证的其他设备 暂不考虑 如 K9 桌面机等
    /** 判断是否是 终端 设备 */
    public static boolean isOtherDevices() {
        String type = getDeviceType();
        if (type.equals(UIConsts.DeviceType.YP_DEVICE)) {
            return false;
        } else if (type.equals(UIConsts.DeviceType.ARM_DEVICE)) {
            return false;
        } else {
            return true;
        }
    }

    /** 获取真实的SN */
    public static String getYPNum() {
        return android.os.Build.SERIAL;
    }
}
