package com.dayouzc.e2e.core.util;

import android.os.Handler;
import android.os.Message;
import android.widget.TextView;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;


/**
 * 钟表自动计时<br>
 * 获取当前日期
 *              获取当前时间
 *                  获取今天星期几
 *                      获取 农历日期
 *
 * @author 何鑫
 * @date 2018/5/24 10:27
 */
public class ClockUtils implements Runnable {

   private TextView time_tv;
   private TextView date_tv;
   private MyHandler handler = new MyHandler();

   static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年MM月dd");

   /**
    * @use 显示当前日期 以及 时间
    * @param mTime_tv  时间 （15：09）
    * @param mDate_tv  日期 （年月日 星期 以及 农历）
    */
   public ClockUtils(TextView mTime_tv, TextView mDate_tv) {
        this.time_tv = mTime_tv;
        this.date_tv = mDate_tv;
        new Thread(this).start();
    }

   class MyHandler extends Handler {
       @Override
       public void handleMessage(Message msg) {
           super.handleMessage(msg);

           switch (msg.what) {
               case 100:
                   if (time_tv != null) {
                       time_tv.setText(((String) msg.obj));
                   }
                   break;

               case 200:
                   if (date_tv != null) {

                       try {
                           Calendar calendar = Calendar.getInstance();
                           calendar.setTime(simpleDateFormat.parse((String) msg.obj));

                           LunarUtils lunarUtils = new LunarUtils(calendar);

                           date_tv.setText(((String) msg.obj) + "  " + getWay() + "    农历  " + lunarUtils);
                       } catch (Exception e) {
                           e.printStackTrace();
                       }


                   }

                   break;
           }


       }
   }

   ;


   @Override
   public void run() {
       // TODO Auto-generated method stub
       try {
           while (true) {
               SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy年MM月dd");
               SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
               String str1 = sdf1.format(new Date());
               String str = sdf.format(new Date());
               handler.sendMessage(handler.obtainMessage(100, str));
               handler.sendMessage(handler.obtainMessage(200, str1));
               Thread.sleep(1000);
           }
       } catch (InterruptedException e) {
           // TODO Auto-generated catch block
           e.printStackTrace();
       }
   }

   String getWay() {
       final Calendar c = Calendar.getInstance();
       c.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
       String mWay = String.valueOf(c.get(Calendar.DAY_OF_WEEK));
       if ("1".equals(mWay)) {
           mWay = "天";
       } else if ("2".equals(mWay)) {
           mWay = "一";
       } else if ("3".equals(mWay)) {
           mWay = "二";
       } else if ("4".equals(mWay)) {
           mWay = "三";
       } else if ("5".equals(mWay)) {
           mWay = "四";
       } else if ("6".equals(mWay)) {
           mWay = "五";
       } else if ("7".equals(mWay)) {
           mWay = "六";
       }

       return "星期" + mWay;

   }
}
