/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OtherStringUtils {
    public static OtherStringUtils getInstancle() {
        return new OtherStringUtils();
    }

    private OtherStringUtils() {
    }

    public static Long toUnixTimestamp(Long timestamp) {
        Long r = timestamp / 1000L;
        return r;
    }

    public static Long unixTimestampToJAVA(Long timestamp) {
        Long r = timestamp * 1000L;
        return r;
    }

    public static int compareCharterEqualsCount(String input, String compare) {
        int flag = 0;
        for (int i = 0; i < input.length() && i < compare.length(); ++i) {
            if (input.charAt(i) != compare.charAt(i)) continue;
            ++flag;
        }
        return flag;
    }

    public static String convertUnicode(String str) {
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            str = str.replace(matcher.group(1), ch + "");
        }
        return str;
    }

    public static boolean isAlphanumeric(String str) {
        int flag = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            char n = c;
            if (n >= '\u0000' && n <= '\t' || n >= 'A' && n <= 'Z' || n == '_' || n >= 'a' && n <= 'z') continue;
            ++flag;
        }
        return flag == 0;
    }

    public static String getSystime() {
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dft.format(new Date());
    }

    public static String getjkhttime() {
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMMdd");
        return dft.format(new Date());
    }

    public static String getSystime(String format) {
        SimpleDateFormat dft = new SimpleDateFormat(format);
        return dft.format(new Date());
    }

    public static boolean isEmail(String email) {
        String str = "^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static List<String> getTimeDistance(String format, int distance) {
        ArrayList<String> dateList = new ArrayList<String>();
        for (int i = 0; i < distance; ++i) {
            Calendar curCal = Calendar.getInstance();
            SimpleDateFormat datef = new SimpleDateFormat(format);
            curCal.add(2, -i);
            Date beginTime = curCal.getTime();
            String time = datef.format(beginTime);
            dateList.add(time);
        }
        return dateList;
    }

    public static String getSystime(String format, long timestamp) {
        SimpleDateFormat dft = new SimpleDateFormat(format);
        return dft.format(new Date(timestamp));
    }

    public static String getPreMonth() {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.add(2, -1);
        Date beginTime = curCal.getTime();
        String time = datef.format(beginTime) + " 00:00:00";
        return time;
    }

    public static String getNextMonth() {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.add(2, 1);
        Date beginTime = curCal.getTime();
        String time = datef.format(beginTime) + " 00:00:00";
        return time;
    }

    public static String getFirstDay(Long time) {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.setTime(new Date(time));
        curCal.set(5, 1);
        Date beginTime = curCal.getTime();
        String sTime = datef.format(beginTime) + " 00:00:00";
        return sTime;
    }

    public static Long getFirstDayForTime(Long time) {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.setTime(new Date(time));
        curCal.set(5, 1);
        Date beginTime = curCal.getTime();
        String sTime = datef.format(beginTime) + " 00:00:00";
        Long res = null;
        try {
            res = datef.parse(sTime).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static Timestamp getFirstDayForTimestamp(Long time) {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.setTime(new Date(time));
        curCal.set(5, 1);
        Date beginTime = curCal.getTime();
        String sTime = datef.format(beginTime) + " 00:00:00";
        Long res = null;
        try {
            res = datef.parse(sTime).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new Timestamp(res);
    }

    public static String getEndDay(Long time) {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.setTime(new Date(time));
        curCal.set(5, 1);
        curCal.roll(5, -1);
        Date endTime = curCal.getTime();
        String eTime = datef.format(endTime) + " 23:59:59";
        return eTime;
    }

    public static Long getEndDayForTime(Long time) {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.setTime(new Date(time));
        curCal.set(5, 1);
        curCal.roll(5, -1);
        Date endTime = curCal.getTime();
        String eTime = datef.format(endTime) + " 23:59:59";
        Long res = null;
        try {
            res = datef.parse(eTime).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static Timestamp getEndDayForTimestamp(Long time) {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.setTime(new Date(time));
        curCal.set(5, 1);
        curCal.roll(5, -1);
        Date endTime = curCal.getTime();
        String eTime = datef.format(endTime) + " 23:59:59";
        Long res = null;
        try {
            res = datef.parse(eTime).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new Timestamp(res);
    }

    public static Long getTime(String time) throws ParseException {
        return OtherStringUtils.getTime(time, "yyyy-MM-dd HH:mm:ss");
    }

    public static Timestamp getTimestamp(String time, String formart) throws ParseException {
        return new Timestamp(OtherStringUtils.getTime(time, formart));
    }

    public static Timestamp getTimestamp(String time) throws ParseException {
        return new Timestamp(OtherStringUtils.getTime(time));
    }

    public static Long getTime(String time, String formart) throws ParseException {
        SimpleDateFormat datef = new SimpleDateFormat(formart);
        return datef.parse(time).getTime();
    }

    public static String getFirstDay() {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.set(5, 1);
        Date beginTime = curCal.getTime();
        String sTime = datef.format(beginTime) + " 00:00:00";
        return sTime;
    }

    public static String getEndDay() {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        curCal.set(5, 1);
        curCal.roll(5, -1);
        Date endTime = curCal.getTime();
        String eTime = datef.format(endTime) + " 23:59:59";
        return eTime;
    }

    public static String getWeek(Date date) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week = cal.get(7) - 1;
        if (week < 0) {
            week = 0;
        }
        return weekDays[week];
    }

    public static Long getBeforeTimeLong(int timeType, int intervalNumber, long currentTime) throws ParseException {
        String time = OtherStringUtils.getBeforeTimeStr(timeType, intervalNumber, currentTime);
        return OtherStringUtils.getTime(time);
    }

    public static String getBeforeTimeStr(int timeType, int intervalNumber, long currentTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(currentTime));
        if (timeType == 1) {
            calendar.add(5, -intervalNumber);
        } else if (timeType == 2) {
            calendar.add(2, -intervalNumber);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(calendar.get(1)).append("-");
        sb.append(calendar.get(2) + 1).append("-");
        sb.append(calendar.get(5)).append(" ");
        sb.append(calendar.get(11)).append(":");
        sb.append(calendar.get(12)).append(":");
        sb.append(calendar.get(13));
        return sb.toString();
    }

    public static String byte2hex(byte[] b) {
        StringBuffer hs = new StringBuffer(b.length);
        String stmp = "";
        int len = b.length;
        for (int n = 0; n < len; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs.append("0").append(stmp) : hs.append(stmp);
        }
        return String.valueOf(hs);
    }

    public static String getUnicode(String str) {
        if (str == null) {
            return "";
        }
        String hs = "";
        try {
            byte[] b = str.getBytes("UTF-16");
            for (int n = 0; n < b.length; ++n) {
                str = Integer.toHexString(b[n] & 0xFF);
                hs = str.length() == 1 ? hs + "0" + str : hs + str;
                if (n >= b.length - 1) continue;
                hs = hs + "";
            }
            str = hs.toUpperCase().substring(4);
            char[] chs = str.toCharArray();
            str = "";
            for (int i = 0; i < chs.length; i += 4) {
                str = str + "\\u" + chs[i] + chs[i + 1] + chs[i + 2] + chs[i + 3];
            }
            return str;
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
            return str;
        }
    }

    public int compare(Object o1, Object o2) {
        long bb;
        String a = (String)o1;
        String b = (String)o2;
        if (!OtherStringUtils.isDigit(a) || !OtherStringUtils.isDigit(b)) {
            throw new IllegalArgumentException("the object must a digit");
        }
        long aa = Long.valueOf(a);
        if (aa > (bb = Long.valueOf(b).longValue())) {
            return 1;
        }
        if (aa < bb) {
            return -1;
        }
        return 0;
    }

    public static String alterSpace(String content, String character) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < content.length(); ++i) {
            String c = new String(new char[]{content.charAt(i)});
            if (c.trim().length() == 0) {
                sb.append(character);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isEmail(String line, int length) {
        return line.matches("\\w+[\\w.]*@[\\w.]+\\.\\w+$") && line.length() <= length;
    }

    public static boolean isChineseName(String value, int length) {
        return value.matches("^[\u4e00-\u9fa5]+$") && value.length() <= length;
    }

    public static boolean isHaveHtmlTag(String value) {
        return value.matches("<(\\S*?)[^>]*>.*?</\\1>|<.*? />");
    }

    public static boolean isURL(String value) {
        return value.matches("[a-zA-z]+://[^\\s]*");
    }

    public static boolean iskIP(String value) {
        return value.matches("\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}");
    }

    public static boolean isQQ(String value) {
        return value.matches("[1-9][0-9]{4,13}");
    }

    public static boolean isPostCode(String value) {
        return value.matches("[1-9]\\d{5}(?!\\d)");
    }

    public static boolean isIDCard(String value) {
        return value.matches("\\d{15}|\\d{18}");
    }

    public static boolean isPhone(String line) {
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
        m = p.matcher(line);
        return m.matches();
    }

    public static String fixPhoneno(String phoneno) {
        if (phoneno.length() > 11 && phoneno.startsWith("86")) {
            return phoneno.substring(2);
        }
        if (phoneno.length() > 11 && phoneno.startsWith("+86")) {
            return phoneno.substring(3);
        }
        return phoneno;
    }

    public static boolean hasPhone(String line) {
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
        m = p.matcher(line);
        return m.find();
    }

    public static String getPhone(String line) {
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile("1[3,5][4,5,6,7,8,9]\\d{8}|15[8,9]\\d{8}");
        for (int i = 0; i < line.length(); ++i) {
            m = p.matcher(line);
            if (!m.find()) continue;
            String str = line.substring(m.start(), m.end());
            return str;
        }
        return "";
    }

    public static Set getTextBlock(String text, String compile) {
        HashSet<String> set = new HashSet<String>();
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile(compile);
        m = p.matcher(text);
        while (m.find()) {
            String str = text.substring(m.start(), m.end());
            set.add(str);
        }
        return set;
    }

    public static Set getCode(String strMail) {
        HashSet<String> set = new HashSet<String>();
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile("1[3,5][4,5,6,7,8,9]\\d{8}|15[8,9]\\d{8}");
        m = p.matcher(strMail);
        while (m.find()) {
            String str = strMail.substring(m.start(), m.end());
            set.add(str);
        }
        return set;
    }

    public static Set getMail(String content) {
        HashSet<String> set = new HashSet<String>();
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile("(?i)(?<=\\b)[a-z0-9][-a-z0-9_.]+[a-z0-9]@([a-z0-9][-a-z0-9]+\\.)+[a-z]{2,4}(?=\\b)");
        m = p.matcher(content);
        while (m.find()) {
            String str = content.substring(m.start(), m.end());
            set.add(str);
        }
        return set;
    }

    public static int getRandom(int min, int max) {
        return (int)((double)min + (double)(max - min) * Math.random());
    }

    public static int getRandom(int length) {
        return Integer.valueOf(OtherStringUtils.getRand(length));
    }

    public static long getRandomL(int length) {
        return Long.valueOf(OtherStringUtils.getRand(length));
    }

    public static String getRandomStr(int length) {
        return Long.toString(OtherStringUtils.getRandomL(length));
    }

    private static String getRand(int length) {
        StringBuffer t = new StringBuffer();
        for (int j = 0; j < length; ++j) {
            double d = Math.random() * 10.0;
            int c = (int)d;
            t.append(c);
        }
        String result = t.toString();
        if (result.substring(0, 1).equalsIgnoreCase("0")) {
            result.replaceAll("0", "1");
        }
        if (result.length() > length) {
            result = result.substring(0, length);
        } else if (result.length() < length) {
            result = result + OtherStringUtils.getRand(length - result.length());
        }
        return result;
    }

    public static String getRandomChar(int length) {
        String defaultContent = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        return OtherStringUtils.getRandomCharForInput(defaultContent, length);
    }

    public static String getRandomCharForInput(String inputContent, int length) {
        String chars = inputContent;
        String res = "";
        for (int i = 0; i <= length; ++i) {
            double d = Math.random() * (double)inputContent.length();
            int pos = new Double(d).intValue();
            res = res + new Character(inputContent.charAt(pos));
        }
        return res;
    }

    public static boolean isNull(String[] str) {
        for (int i = 0; i < str.length; ++i) {
            if (!OtherStringUtils.isNull(str[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isNull(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isDigit(String[] str) {
        for (int i = 0; i < str.length; ++i) {
            if (OtherStringUtils.isDigit(str[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(String str) {
        if (OtherStringUtils.isNull(str)) {
            throw new NullPointerException();
        }
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getStackInfo(Throwable e) {
        StringBuffer info = new StringBuffer("Found Exception: ");
        info.append("\n");
        info.append(e.getClass().getName());
        info.append(" : ").append(e.getMessage() == null ? "" : e.getMessage());
        StackTraceElement[] st = e.getStackTrace();
        for (int i = 0; i < st.length; ++i) {
            info.append("\t\n").append("at ");
            info.append(st[i].toString());
        }
        return info.toString();
    }

    private static String insteadCode(String str, String regEx, String code) {
        if (OtherStringUtils.isNull(str)) {
            return "";
        }
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        String s = m.replaceAll(code);
        return s;
    }

    public static String toHtml(String sourceStr) {
        if (OtherStringUtils.isNull(sourceStr)) {
            return "";
        }
        String targetStr = OtherStringUtils.insteadCode(sourceStr, ">", "&gt;");
        targetStr = OtherStringUtils.insteadCode(targetStr, "<", "&lt;");
        targetStr = OtherStringUtils.insteadCode(targetStr, "\n", "<br>");
        targetStr = OtherStringUtils.insteadCode(targetStr, " ", "&nbsp;");
        return targetStr.trim();
    }

    public static String sendGetParameter(String parameter) {
        parameter = OtherStringUtils.insteadCode(parameter, "&", "%26");
        parameter = OtherStringUtils.insteadCode(parameter, " ", "%20");
        parameter = OtherStringUtils.insteadCode(parameter, "%", "%25");
        parameter = OtherStringUtils.insteadCode(parameter, "#", "%23");
        return parameter.trim();
    }

    public static String spiltStr(String content, String start, String end) {
        int e;
        if (content.indexOf(start) <= -1 || content.indexOf(end) <= -1) {
            throw new IndexOutOfBoundsException("[start Character or end Character,isn't exist in the specified content]");
        }
        int s = content.indexOf(start);
        int n = e = start.equals(end) ? content.substring(s + 1).indexOf(end) : content.indexOf(end);
        if (s >= e) {
            throw new IndexOutOfBoundsException("[the Character end is smallness Character start]");
        }
        content = new String(content.substring(s + 1, e));
        return content.trim();
    }

    public static String[] splitStr(String content, String split) {
        if (content.indexOf(split) < 0) {
            return new String[]{content};
        }
        int s = 0;
        int e = content.indexOf(split);
        ArrayList<String> list = new ArrayList<String>();
        while (e <= content.length()) {
            if (content.indexOf(split) == -1 && list.size() != 0) {
                list.add(content);
                break;
            }
            list.add(content.substring(s, e));
            content = content.substring(e + 1, content.length());
            e = s + content.indexOf(split);
        }
        return list.toArray(new String[0]);
    }

    public static String splitStr(String str, int num, String end) {
        StringBuffer sb = new StringBuffer();
        if (str == null || end == null) {
            throw new NullPointerException();
        }
        if (str.length() > num) {
            str = sb.append(str.substring(0, num)).append(end).toString();
        }
        return OtherStringUtils.toHtml(str);
    }

    public static String completeText(String content, int count) {
        StringBuffer sb = new StringBuffer();
        if (count > content.length()) {
            for (int i = count - content.length(); content.length() < count && i != 0; --i) {
                sb.append("0");
            }
        }
        sb.append(content);
        return sb.toString();
    }

    public static String completeText(int content, int count) {
        String c = Integer.toString(content);
        StringBuffer sb = new StringBuffer();
        if (count > c.length()) {
            for (int i = count - c.length(); c.length() < count && i != 0; --i) {
                sb.append("0");
            }
        }
        sb.append(content);
        return sb.toString();
    }

    public static String completeTextSpace(String content, int count) {
        StringBuffer sb = new StringBuffer();
        sb.append(content);
        if (count > content.length()) {
            for (int i = 0; i < count - content.length(); ++i) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public static String completeTextSpace(int content, int count) {
        StringBuffer sb = new StringBuffer();
        String c = Integer.toString(content);
        sb.append(content);
        if (count > c.length()) {
            for (int i = 0; i < count - c.length(); ++i) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public static String processPhone(String phone) {
        StringBuffer sb = new StringBuffer();
        sb.append(phone.substring(0, 3));
        sb.append(phone.substring(5, 6));
        sb.append(phone.substring(4, 5));
        sb.append(phone.substring(3, 4));
        sb.append(phone.substring(6, 7));
        sb.append(phone.substring(9, 10));
        sb.append(phone.substring(7, 8));
        sb.append(phone.substring(8, 9));
        sb.append(phone.substring(10, 11));
        return sb.toString();
    }

    public static String toHex(String phoneno) {
        if (OtherStringUtils.isNull(phoneno)) {
            return "";
        }
        long i = new Long(phoneno);
        String i_16 = Long.toHexString(i);
        return i_16;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String getUrlEncode(String content) throws UnsupportedEncodingException {
        char[] a = content.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            if (OtherStringUtils.isChinese(a[i])) {
                sb.append(URLEncoder.encode(a[i] + "", "GBK"));
                continue;
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String getUrlEncode(String content, String encode) throws UnsupportedEncodingException {
        char[] a = content.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            if (OtherStringUtils.isChinese(a[i])) {
                sb.append(URLEncoder.encode(a[i] + "", encode));
                continue;
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String getUrlDecode(String content) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        sb.append(URLDecoder.decode(content, "GBK"));
        return sb.toString();
    }

    public static String getUrlDecode(String content, String encode) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        sb.append(URLDecoder.decode(content, encode));
        return sb.toString();
    }

    public static String toStringHex(String bytes) {
        String hexString = "0123456789ABCDEF ";
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length() / 2);
        for (int i = 0; i < bytes.length(); i += 2) {
            baos.write(hexString.indexOf(bytes.charAt(i)) << 4 | hexString.indexOf(bytes.charAt(i + 1)));
        }
        return new String(baos.toByteArray());
    }

    public static String fromUnicode(String str) {
        if (str.indexOf("\\u") < 0) {
            return str;
        }
        return OtherStringUtils.fromUnicode(str.toCharArray(), 0, str.length(), new char[1024]);
    }

    public static String fromUnicode(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String removeSpace(String content) {
        String unicode = OtherStringUtils.toUnicode(content);
        unicode = unicode.replaceAll("\\\\u0020", "");
        unicode = unicode.replaceAll("\\\\u3000", "");
        return OtherStringUtils.fromUnicode(unicode);
    }

    public static String toUnicode(String str) {
        str = str == null ? "" : str;
        StringBuffer sb = new StringBuffer(1000);
        sb.setLength(0);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            sb.append("\\u");
            int j = c >>> 8;
            String tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
            j = c & 0xFF;
            tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return new String(sb);
    }

    public static String toHexString(String str) {
        if (str.length() <= 0) {
            return "";
        }
        String hexString = "0123456789ABCDEF ";
        byte[] bytes = str.getBytes();
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(hexString.charAt((bytes[i] & 0xF0) >> 4));
            sb.append(hexString.charAt((bytes[i] & 0xF) >> 0));
        }
        return sb.toString();
    }

    public static Integer findPerc(Integer max, Integer perc) {
        Double a = (double)max.intValue() * ((double)perc.intValue() * 0.01);
        return new Long(Math.round(a)).intValue();
    }

    public static Double formartDecimalToDouble(Double d) {
        return new Double(OtherStringUtils.formartDecimalToStr(d));
    }

    public static String formartDecimalToStr(Double d) {
        return OtherStringUtils.formartDecimalToStr(d, "0.00");
    }

    public static String formartDecimalToStr(Float d) {
        return OtherStringUtils.formartDecimalToStr(d.doubleValue(), "0.00");
    }

    public static Double formartDecimalToDouble(Double d, String formart) {
        return new Double(OtherStringUtils.formartDecimalToStr(d, formart));
    }

    public static String formartDecimalToStr(Double d, String formart) {
        DecimalFormat decimalFormat = new DecimalFormat(formart);
        String resultStr = decimalFormat.format(d);
        return resultStr;
    }

    public static Integer[] strToInt(String[] str) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (String e : str) {
            l.add(new Integer(e));
        }
        return l.toArray(new Integer[0]);
    }

    public static String[] intToStr(String[] in) {
        ArrayList<String> l = new ArrayList<String>();
        for (String e : in) {
            l.add(new Integer(e).toString());
        }
        return l.toArray(new String[0]);
    }

    public static int getDiffMinute(Date td1, Date td2) throws Exception {
        long lBeginTime = td1.getTime();
        long lEndTime = td2.getTime();
        int iminte = (int)((lEndTime - lBeginTime) / 60000L);
        return iminte;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Calendar curCal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        Date s = datef.parse("2012-10-15");
        Date e = datef.parse("2012-12-15");
        System.out.println("------------------------");
        System.out.println(OtherStringUtils.getFirstDay(s.getTime()));
        System.out.println(OtherStringUtils.getEndDay(e.getTime()));
        System.out.println("------------------------");
        System.out.println(OtherStringUtils.getBeforeTimeStr(2, 3, System.currentTimeMillis()));
        System.out.println(OtherStringUtils.getSystime("yyyy_MM-dd", OtherStringUtils.getBeforeTimeLong(2, 3, System.currentTimeMillis())));
        System.out.println("------------------------");
        System.out.println(OtherStringUtils.formartDecimalToStr(new Double(1.34567)));
        System.out.println(OtherStringUtils.getPreMonth());
        List<String> timeList = OtherStringUtils.getTimeDistance("yyyy-MM", 12);
        for (int i = 0; i < timeList.size(); ++i) {
            System.out.println(timeList.get(i));
        }
        String time = "2014-03-22 17:04:32";
        SimpleDateFormat dateff = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date td1 = dateff.parse(time);
        Date td2 = new Date(System.currentTimeMillis());
        System.out.println(OtherStringUtils.getDiffMinute(td1, td2));
    }
}

